/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser2;

import java.util.Map;
/**
 * Represents one line in Tasks tab. 
 * */
public class ThreadInfo2 {

	public static final Object kRunning = new Object();
	public static final Object kSuspended = new Object();
	/** mandatory field */
	//private Object threadKind;
	/** mandatory field */
	private final String name;
	/** mandatory field */
	private final String state;
	/** optional fields */
	private Map<String, String> extendedInfo;

	public ThreadInfo2(String name, String state, Map<String, String> extendedInfo) {
		this.name = name;
		this.state = state;
		this.extendedInfo = extendedInfo;
	}

	public final String getName() {
		return name;
	}

	public final String getState() {
		return state;
	}

	public final String getExtendedInfo(final String dataId) {
		return extendedInfo.get(dataId);
	}

	public final long getThreadId() {
		// TODO
		return 0L;
	}

}
