/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/
package com.freescale.system.browser.internal.ui.tabbed;

import com.freescale.system.browser.epl.ITabbedPageContributorEpl;

/**
 * Interface for a workbench/non-workbench part to contribute content to the tabbed view.
 * <p>
 * It is expected that the contributor ID is unique for a configuration of tabs
 * and sections. A configuration could be shared by sharing a
 * contributor ID. Tabs and sections cannot be shared from/across
 * multiple contributors.
 * </p>
 * <p>
 * As a workaround, if more elements implement
 * ITabbedPageContributor and they all return the same unique
 * contributor ID, then that configuration of tabs and sections will be used by
 * the tabbed view for that selection.
 * </p>
 */
public interface ITabbedPageContributor extends ITabbedPageContributorEpl {
	
}
