/*
 * Copyright 2014-2016 Freescale
 * Copyright 2018,2021,2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 */

package com.nxp.sa.ui.common.epl;

import java.io.File;
import java.util.HashMap;

import com.freescale.sa.util.Logger;
import org.eclipse.core.runtime.Path;

import com.freescale.sa.configurator.ls.jni.AttributeType;
import com.freescale.sa.configurator.ls.jni.LSConfigLoader_JNI;
//import com.freescale.sa.ui.common.SAUILSPlugin;
import com.freescale.sa.util.CommonConstants;

/**
 * Helper class used to get a mapped path for a filename.
 * 
 * Functionality is similar to
 * org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
 */
public class SASourceLookupDirector {

	/*
	 * resultsConfig file name which will be updated after locating the file or
	 * the source lookup paths
	 */
	private String m_resultsConfig = null;
	private LSConfigLoader_JNI m_configLoader;
	private static HashMap<String, String> mappedFileNames = new HashMap<String, String>();

	/**
	 * Constructor. It requires the results config file to be used for lookup
	 * and updated
	 * 
	 * @param resultsConfig
	 *            the results config file name
	 */
	public SASourceLookupDirector(String resultsConfig) {
		m_resultsConfig = resultsConfig;

		m_configLoader = new LSConfigLoader_JNI(
				new File(m_resultsConfig).getAbsolutePath());
		boolean status = m_configLoader
				.configBlockExists(CommonConstants.RESULTS_SOURCE_MAPPING_CONFIG_BLOCK_NAME);
		if (!status) {
			SAUILSPlugin.getDefault().logError("Error at reading results config file. It has no SourceMapping config block!"); //$NON-NLS-1$			
		}
		getMappedFileNames(m_configLoader);
	}

	private static void getMappedFileNames(LSConfigLoader_JNI configLoader) {
		if (configLoader != null) {
			try {
				mappedFileNames = (HashMap<String, String>) configLoader
						.getConfigBlockStringAttributes(CommonConstants.RESULTS_SOURCE_MAPPING_CONFIG_BLOCK_NAME);
			} catch (Exception e) {
				SAUILSPlugin.getDefault().logInfo("Unable to initialize mapped file names from results config file!"); //$NON-NLS-1$
			}
		}
	}

	public synchronized String getSourceElement(String fileName) {
		Path fileNamePath = new Path(fileName);
		String filename = fileNamePath.toString();
		return mappedFileNames.get(filename);
	}

	public synchronized void setMappedFileName(String fileName,
			String mappedFile) {
		// add the path mapping to hashmap
		mappedFileNames.put(fileName, mappedFile);
		// add the path mapping as StringAttribute to results config file
		boolean statusOk = m_configLoader.addMutableAttributeToConfigBlock(AttributeType.STRING_ATTR.value(), fileName, mappedFile,
				CommonConstants.RESULTS_SOURCE_MAPPING_CONFIG_BLOCK_NAME);
		
		if (statusOk) {
		    m_configLoader.saveConfigToXml();
		}

	}
}
