/*******************************************************************************
 * Copyright (c) 2014 Freescale Semiconductor, Inc
 * Copyright 2023 NXP
 * 
 * SPDX-License-Identifier: EPL-1.0
 *******************************************************************************/

package com.nxp.sa.ui.common.epl;


public class OS {
	static Boolean mWindows = null;
	static Boolean mWindowsVista = null;
	static Boolean mMac = null;

	static synchronized public boolean isWindows() {
		if (mWindows == null) {
			mWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
		}
		return mWindows;
	}

	static public boolean isLinux() {
		return !isWindows() && !isMac();
	}

	static synchronized public boolean isMac() {
		if (mMac == null) {
			mMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
		}
		return mMac;
	}

	static public String getOSDesc() {
		return System.getProperty("os.name") + " (" + System.getProperty("os.version") + "-"
				+ System.getProperty("os.arch") + ")";
	}
}
