/*
 * Copyright 2014 Freescale
 * Copyright 2018,2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 */

package com.nxp.sa.ui.common.epl;

/**
 * Various GUI related constants
 */
public interface ITraceWidgetConstants {
	
	/**
	 * A clear margin value that defaults to 0 pixels. Use this for composites that need 
	 * to occupy the entire area of the parent (e.g. usually these composites are not 
	 * visible and are used as containers for other widgets).
	 */
	public static final int CLEAR_MARGIN = 0;
	
	/**
	 * The default horizontal margin around a composite (left and right).
	 */
	public static final int DEFAULT_HMARGIN = 2;
	
	/**
	 * The default vertical margin around a composite (top and bottom).
	 */
	public static final int DEFAULT_VMARGIN = 2;
	
	/**
	 * A more generous horizontal margin around a composite (left and right).
	 */
	public static final int HMARGIN = 6;
	
	/**
	 * A more generous vertical margin around the composite (top and bottom).
	 */
	public static final int VMARGIN = 6;

	/**
	 * <p>Horizontal space to leave between related widgets. 
	 * Each section should use these values for spacing its widgets. 
	 * For example, you can use +/- HSPACE as the offset of a left or 
	 * right FlatFormAttachment.</p>
	 * 
	 * <p>HSPACE pixels will be inserted between section composites if more 
	 * than one section is displayed in a horizontal layout of a form.</p>  
	 */
	public static final int HSPACE = 5;
	
	/**
	 * <p>Vertical space to leave between related widgets.</p>
	 * 
	 * <p>VSPACE pixels will be inserted between section composites if more 
	 * than one section is displayed in a vertical layout of a form.</p>
	 */ 
	public static final int VSPACE = 5;

	/**
	 * String to be used when no source information is available for the
	 * the disassembly.
	 */
	public static final String NO_SOURCE_INFORMATION = MessageResourceBundle.DefaultTraceEventVisitor_0;
}
