/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.internal.lang.symbol;

import com.nxp.s32ds.cle.runtime.lang.symbol.LangSymbolDescriptor;
import com.nxp.s32ds.cle.runtime.lang.symbol.LangSymbolRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class LangSymbolRegistryImplementation
extends BaseRegistry
implements LangSymbolRegistry {
    private final Map<String, Collection<LangSymbolDescriptor>> lang2langSymbolDescriptors = new HashMap<String, Collection<LangSymbolDescriptor>>();
    private final Map<String, Collection<LangSymbolDescriptor>> symbol2langSdkDescriptors = new HashMap<String, Collection<LangSymbolDescriptor>>();

    @Override
    public List<LangSymbolDescriptor> getLangSymbolDescriptorsByLangId(String coreId) {
        return this.getReferenceDescriptorsBySourceId(coreId, this.lang2langSymbolDescriptors, LangSymbolDescriptor.class);
    }

    @Override
    public List<LangSymbolDescriptor> getLangSymbolDescriptorsBySymbolId(String symbolId) {
        return this.getReferenceDescriptorsByTargetId(symbolId, this.symbol2langSdkDescriptors, LangSymbolDescriptor.class);
    }

    @Override
    public void addLangSymbolDescriptor(LangSymbolDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.lang2langSymbolDescriptors, this.symbol2langSdkDescriptors, LangSymbolDescriptor.class);
    }

    @Override
    public void removeLangSymbolDescriptor(LangSymbolDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.lang2langSymbolDescriptors, this.symbol2langSdkDescriptors, LangSymbolDescriptor.class);
    }

    @Override
    public void removeLangSymbolDescriptorsBySymbolId(String symbolId) {
        Collection<LangSymbolDescriptor> collection = this.symbol2langSdkDescriptors.get(symbolId);
        if (collection != null) {
            ArrayList<LangSymbolDescriptor> descriptors = new ArrayList<LangSymbolDescriptor>(collection);
            descriptors.forEach(this::removeLangSymbolDescriptor);
            descriptors.clear();
        }
    }

    @Override
    public List<LangSymbolDescriptor> getLangSymbolDescriptors() {
        ArrayList<LangSymbolDescriptor> result = new ArrayList<LangSymbolDescriptor>();
        this.lang2langSymbolDescriptors.values().stream().flatMap(v -> v.stream()).forEach(result::add);
        return result;
    }
}

