/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.view;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.actions.AddGlobalVariableAction;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;

public class AddGlobalVariableDialog
extends Dialog {
    private static final String FILE_IMAGE_URL = "platform:/plugin/org.eclipse.cdt.ui/icons/obj16/c_file_obj.gif";
    private static final String VARIABLE_IMAGE_URL = "platform:/plugin/org.eclipse.debug.ui/icons/full/eview16/variable_view.png";
    private static final String SHOW_PATH_WITH_FILE_NAME = "GlobalVariablesAddVariableDialog_Show_path_with_file_name";
    private static final String TREE_EXPAND_STATE_PROJECT_SCOPE_ID = String.valueOf(AddGlobalVariableAction.ACTION_ID) + ".expand.state";
    private static final String TREE_EXPAND_STATE_PROJECT_SCOPE_ELEMENT_ID = String.valueOf(TREE_EXPAND_STATE_PROJECT_SCOPE_ID) + "_";
    private Map<String, SortedSet<GlobalVariableModel>> path2globalVariables;
    private Map<String, SortedSet<GlobalVariableModel>> input;
    private CheckboxTreeViewer treeViewer;
    private List<GlobalVariableModel> selection;
    private Image fileImage;
    private Image variableImage;
    private boolean showPathCondition;
    private final ProjectScope projectScope;

    public AddGlobalVariableDialog(Shell parentShell, Map<String, SortedSet<GlobalVariableModel>> input, List<GlobalVariableModel> currentSelection, ProjectScope pScope) {
        super(parentShell);
        this.path2globalVariables = new TreeMap<String, SortedSet<GlobalVariableModel>>(input);
        this.selection = new ArrayList<GlobalVariableModel>();
        this.selection.addAll(currentSelection);
        this.projectScope = pScope;
        this.showPathCondition = Activator.getInstance().getPreferenceStore().getBoolean(SHOW_PATH_WITH_FILE_NAME);
        try {
            this.fileImage = ImageDescriptor.createFromURL((URL)new URL(FILE_IMAGE_URL)).createImage();
            this.variableImage = ImageDescriptor.createFromURL((URL)new URL(VARIABLE_IMAGE_URL)).createImage();
        }
        catch (MalformedURLException e) {
            this.fileImage = null;
            this.variableImage = null;
            Activator.getInstance().logError(e.getMessage());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(S32GlobalVariablesMessages.AddGlobalVariableDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite howToShowPath = new Composite(composite, 2048);
        howToShowPath.setLayout((Layout)new GridLayout(2, false));
        howToShowPath.setLayoutData((Object)new GridData(4, 4, true, false));
        final Button showPath = new Button(howToShowPath, 2);
        showPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddGlobalVariableDialog.this.showPathCondition = showPath.getSelection();
                AddGlobalVariableDialog.this.treeViewer.refresh();
                AddGlobalVariableDialog.this.checkInitStateForParent();
            }
        });
        showPath.setImage(Activator.addPathToNameImage);
        showPath.setToolTipText(S32GlobalVariablesMessages.AddGlobalVariableDialog_Path_tooltip);
        showPath.setSelection(this.showPathCondition);
        Text text = new Text(howToShowPath, 2048);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        text.addModifyListener(modifyEvent -> this.modifyListener(text));
        Composite treeviewcomposite = new Composite(composite, 2048);
        treeviewcomposite.setLayout((Layout)new GridLayout(1, false));
        treeviewcomposite.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite scrolledComposite = new ScrolledComposite(treeviewcomposite, 768);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.treeViewer = new CheckboxTreeViewer((Composite)scrolledComposite);
        this.treeViewer.setContentProvider((IContentProvider)new GlobalVariablesTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GlobalVariablesTreeLabelProvider());
        this.treeViewer.setCheckStateProvider((ICheckStateProvider)new GlobalVariablesTreeCheckStateProvider());
        this.treeViewer.addCheckStateListener(this::checkStateListener);
        this.input = this.path2globalVariables;
        this.treeViewer.setInput(this.path2globalVariables);
        this.treeViewer.addCheckStateListener(this::checkStateChangedListener);
        this.checkInitStateForParent();
        Composite buttons = new Composite(composite, 2048);
        buttons.setLayout((Layout)new GridLayout(4, false));
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        Button selectAllButton = (Button)WidgetFactory.button((int)8).text(S32GlobalVariablesMessages.AddGlobalVariableDialog_Select_all).onSelect(this.selectAllButtonHandler()).create((Widget)buttons);
        Button selectNoneButton = (Button)WidgetFactory.button((int)8).text(S32GlobalVariablesMessages.AddGlobalVariableDialog_Select_none).onSelect(this.selectNoneButtonHandler()).create((Widget)buttons);
        Button collapseAllButton = (Button)WidgetFactory.button((int)8).text(S32GlobalVariablesMessages.AddGlobalVariableDialog_Collapse_all).onSelect(event -> {
            this.treeViewer.collapseAll();
            this.getButton(0).forceFocus();
        }).create((Widget)buttons);
        Button expandAllButton = (Button)WidgetFactory.button((int)8).text(S32GlobalVariablesMessages.AddGlobalVariableDialog_Expand_all).onSelect(event -> {
            this.treeViewer.expandAll();
            this.getButton(0).forceFocus();
        }).create((Widget)buttons);
        this.createButtonsLogic(selectAllButton, selectNoneButton, collapseAllButton, expandAllButton);
        parent.addListener(11, e -> {
            parent.layout();
            this.treeViewer.getControl().computeSize(-1, -1, true);
        });
        scrolledComposite.setContent(this.treeViewer.getControl());
        if (this.projectScope != null) {
            this.initExpandStateByProjectScope();
        }
        expandAllButton.setEnabled(this.treeViewer.getExpandedElements().length + 1 < this.input.keySet().size());
        collapseAllButton.setEnabled(this.treeViewer.getExpandedElements().length - 1 > 0);
        selectAllButton.setEnabled(this.selection.size() < this.input.values().stream().mapToInt(Set::size).sum());
        selectNoneButton.setEnabled(!this.selection.isEmpty());
        return parent;
    }

    private void initExpandStateByProjectScope() {
        IEclipsePreferences e = this.projectScope.getNode(TREE_EXPAND_STATE_PROJECT_SCOPE_ID);
        String elem = e.get(String.valueOf(TREE_EXPAND_STATE_PROJECT_SCOPE_ELEMENT_ID) + "0", "");
        int i = 1;
        while (elem != null && !elem.isEmpty()) {
            this.treeViewer.setExpandedState((Object)elem, true);
            elem = e.get(String.valueOf(TREE_EXPAND_STATE_PROJECT_SCOPE_ELEMENT_ID) + i++, "");
        }
    }

    private void createButtonsLogic(final Button selectAllButton, final Button selectNoneButton, final Button collapseAllButton, final Button expandAllButton) {
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selectAllButton.setEnabled(false);
                selectNoneButton.setEnabled(true);
            }
        });
        selectNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selectAllButton.setEnabled(true);
                selectNoneButton.setEnabled(false);
            }
        });
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                expandAllButton.setEnabled(true);
                collapseAllButton.setEnabled(false);
            }
        });
        expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                expandAllButton.setEnabled(false);
                collapseAllButton.setEnabled(true);
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent arg0) {
                expandAllButton.setEnabled(AddGlobalVariableDialog.this.treeViewer.getExpandedElements().length + 1 < AddGlobalVariableDialog.this.input.keySet().size());
                collapseAllButton.setEnabled(true);
            }

            public void treeCollapsed(TreeExpansionEvent arg0) {
                expandAllButton.setEnabled(true);
                collapseAllButton.setEnabled(AddGlobalVariableDialog.this.treeViewer.getExpandedElements().length - 1 > 0);
            }
        });
        this.treeViewer.addCheckStateListener(event -> {
            selectAllButton.setEnabled(this.selection.size() < this.input.values().stream().mapToInt(Set::size).sum());
            selectNoneButton.setEnabled(this.treeViewer.getCheckedElements().length > 0);
        });
    }

    private void checkStateChangedListener(CheckStateChangedEvent checkStateEvent) {
        if (checkStateEvent.getElement() instanceof GlobalVariableModel) {
            if (checkStateEvent.getChecked()) {
                this.selection.add((GlobalVariableModel)checkStateEvent.getElement());
            } else {
                this.selection.remove(checkStateEvent.getElement());
            }
        } else if (checkStateEvent.getElement() instanceof String) {
            for (GlobalVariableModel globalVariableModel : this.input.getOrDefault(checkStateEvent.getElement(), Collections.emptySortedSet())) {
                if (checkStateEvent.getChecked()) {
                    this.selection.add(globalVariableModel);
                    continue;
                }
                this.selection.remove(globalVariableModel);
            }
        }
    }

    private void modifyListener(Text text) {
        if (text.getText().isEmpty()) {
            this.input = this.path2globalVariables;
            this.treeViewer.setInput(this.path2globalVariables);
            this.checkInitStateForParent();
            this.treeViewer.expandAll();
            return;
        }
        String filterVar = text.getText();
        TreeMap<String, SortedSet<GlobalVariableModel>> newPath2globalVariables = new TreeMap<String, SortedSet<GlobalVariableModel>>();
        for (Map.Entry<String, SortedSet<GlobalVariableModel>> entry : this.path2globalVariables.entrySet()) {
            for (GlobalVariableModel globalVariable : entry.getValue()) {
                String checkVarString = String.format(S32GlobalVariablesMessages.AddGlobalVariableDialog_Variable_format, globalVariable.getName(), globalVariable.getType());
                if (!checkVarString.toLowerCase().contains(filterVar.toLowerCase())) continue;
                if (newPath2globalVariables.get(globalVariable.getFilePath().toOSString()) == null) {
                    TreeSet<GlobalVariableModel> list = new TreeSet<GlobalVariableModel>();
                    list.add(globalVariable);
                    newPath2globalVariables.put(globalVariable.getFilePath().toOSString(), list);
                    continue;
                }
                ((SortedSet)newPath2globalVariables.get(globalVariable.getFilePath().toOSString())).add(globalVariable);
            }
        }
        this.input = newPath2globalVariables;
        this.treeViewer.setInput(newPath2globalVariables);
        this.checkInitStateForParent();
        this.treeViewer.expandAll();
    }

    private Consumer<SelectionEvent> selectNoneButtonHandler() {
        return event -> {
            this.selection.clear();
            this.input.values().stream().flatMap(Collection::stream).forEach(var -> {
                boolean bl = this.treeViewer.setChecked(var, false);
            });
            this.input.keySet().stream().forEach(elem -> {
                boolean bl = this.treeViewer.setChecked(elem, false);
            });
            this.getButton(0).setEnabled(false);
        };
    }

    private Consumer<SelectionEvent> selectAllButtonHandler() {
        return event -> {
            ArrayList<String> toCheck = new ArrayList<String>();
            this.selection.clear();
            for (Map.Entry<String, SortedSet<GlobalVariableModel>> entry : this.input.entrySet()) {
                this.treeViewer.setGrayChecked((Object)entry.getKey(), false);
                toCheck.add(entry.getKey());
                toCheck.addAll((Collection)entry.getValue());
                this.selection.addAll((Collection<GlobalVariableModel>)entry.getValue());
            }
            this.treeViewer.setCheckedElements(toCheck.toArray());
            this.getButton(0).setEnabled(true);
            this.getButton(0).forceFocus();
        };
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void checkInitStateForParent() {
        for (Map.Entry<String, SortedSet<GlobalVariableModel>> parentElem : this.input.entrySet()) {
            this.treeViewer.setGrayed((Object)parentElem.getKey(), false);
            Set intersection = parentElem.getValue().stream().filter(this.selection::contains).collect(Collectors.toSet());
            if (intersection.isEmpty()) {
                this.treeViewer.setChecked((Object)parentElem.getKey(), false);
                continue;
            }
            if (intersection.size() == parentElem.getValue().size()) {
                this.treeViewer.setGrayed((Object)parentElem.getKey(), false);
                this.treeViewer.setChecked((Object)parentElem.getKey(), true);
                continue;
            }
            this.treeViewer.setGrayChecked((Object)parentElem.getKey(), true);
        }
    }

    public boolean close() {
        boolean toClose;
        if (this.projectScope != null) {
            IEclipsePreferences eclipsePreferences = this.projectScope.getNode(TREE_EXPAND_STATE_PROJECT_SCOPE_ID);
            try {
                eclipsePreferences.clear();
            }
            catch (BackingStoreException e) {
                Activator.getInstance().logError(e.getMessage(), e);
            }
            int i = 0;
            Object[] objectArray = this.treeViewer.getExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object elem = objectArray[n2];
                eclipsePreferences.put(String.valueOf(TREE_EXPAND_STATE_PROJECT_SCOPE_ELEMENT_ID) + i++, (String)elem);
                ++n2;
            }
        }
        if (toClose = super.close()) {
            this.fileImage.dispose();
            this.variableImage.dispose();
            Activator.getInstance().getPreferenceStore().setValue(SHOW_PATH_WITH_FILE_NAME, this.showPathCondition);
        }
        return toClose;
    }

    protected boolean isResizable() {
        return true;
    }

    private void enableOkButton() {
        boolean anyMatch = this.path2globalVariables.keySet().stream().anyMatch(key -> this.treeViewer.getChecked(key));
        this.getButton(0).setEnabled(anyMatch);
    }

    public List<GlobalVariableModel> getAddedGlobalVariables() {
        return this.selection;
    }

    private void checkStateListener(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof String) {
            this.treeViewer.setGrayed(element, false);
            SortedSet children = this.input.getOrDefault(element, Collections.emptySortedSet());
            for (GlobalVariableModel variable : children) {
                this.treeViewer.setChecked((Object)variable, event.getChecked());
            }
            this.enableOkButton();
            return;
        }
        if (element instanceof GlobalVariableModel) {
            String parentElem = ((GlobalVariableModel)element).getFilePath().toOSString();
            boolean allMatch = this.input.get(parentElem).stream().allMatch(child -> this.treeViewer.getChecked(child));
            boolean noneMatch = this.input.get(parentElem).stream().allMatch(child -> !this.treeViewer.getChecked(child));
            if (noneMatch) {
                this.treeViewer.setChecked((Object)parentElem, false);
            } else if (allMatch) {
                this.treeViewer.setGrayed((Object)parentElem, false);
                this.treeViewer.setChecked((Object)parentElem, true);
            } else {
                this.treeViewer.setGrayChecked((Object)parentElem, true);
            }
            this.enableOkButton();
        }
    }

    private class GlobalVariablesTreeCheckStateProvider
    implements ICheckStateProvider {
        private GlobalVariablesTreeCheckStateProvider() {
        }

        public boolean isChecked(Object inputObject) {
            if (inputObject instanceof GlobalVariableModel) {
                return AddGlobalVariableDialog.this.selection.contains(inputObject);
            }
            return false;
        }

        public boolean isGrayed(Object arg0) {
            return false;
        }
    }

    private class GlobalVariablesTreeContentProvider
    implements ITreeContentProvider {
        private GlobalVariablesTreeContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            return AddGlobalVariableDialog.this.input.getOrDefault(arg0, Collections.emptySortedSet()).toArray();
        }

        public Object[] getElements(Object input) {
            if (input instanceof Map) {
                Map mapInput = (Map)input;
                return mapInput.keySet().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object inputObject) {
            if (inputObject instanceof String) {
                return null;
            }
            if (inputObject instanceof GlobalVariableModel) {
                return ((GlobalVariableModel)inputObject).getFilePath().toOSString();
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof String) {
                return !AddGlobalVariableDialog.this.input.getOrDefault(arg0, Collections.emptySortedSet()).isEmpty();
            }
            return false;
        }
    }

    private class GlobalVariablesTreeLabelProvider
    extends LabelProvider {
        private GlobalVariablesTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (AddGlobalVariableDialog.this.fileImage == null || AddGlobalVariableDialog.this.variableImage == null) {
                return super.getImage(element);
            }
            if (element instanceof String) {
                return AddGlobalVariableDialog.this.fileImage;
            }
            if (element instanceof GlobalVariableModel) {
                return AddGlobalVariableDialog.this.variableImage;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof String) {
                if (!AddGlobalVariableDialog.this.showPathCondition) {
                    return new Path((String)element).lastSegment();
                }
                return (String)element;
            }
            if (element instanceof GlobalVariableModel) {
                return String.format(S32GlobalVariablesMessages.AddGlobalVariableDialog_Variable_format, ((GlobalVariableModel)element).getName(), ((GlobalVariableModel)element).getType());
            }
            return super.getText(element);
        }
    }
}

