/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.actions;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.actions.ActionsUtil;
import com.nxp.s32ds.debug.ide.global.variables.actions.RemoveAllGlobalVariablesAction;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.GlobalVariablesService;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.S32DSGlobalVariablesManager;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import com.nxp.s32ds.debug.ide.global.variables.view.AddGlobalVariableDialog;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;

public class AddGlobalVariableAction
extends Action {
    public static final String ACTION_ID = String.valueOf(Activator.getInstance().getBundleId()) + ".add.global.variables";
    private IDebugView fDebugView;

    public AddGlobalVariableAction(IDebugView view) {
        super(S32GlobalVariablesMessages.AddGlobalVariableAction_Name, 1);
        this.fDebugView = view;
        this.setToolTipText(S32GlobalVariablesMessages.AddGlobalVariableAction_Name);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.setId(ACTION_ID);
    }

    public void runWithEvent(Event event) {
        String sessionId = ActionsUtil.getCurrentSessionId(this.fDebugView);
        if (sessionId.isEmpty()) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)sessionId);
        ILaunch launch = (ILaunch)session.getModelAdapter(ILaunch.class);
        String projectName = "";
        try {
            projectName = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException e) {
            Activator.getInstance().logError(e.getMessage(), e);
        }
        ProjectScope projectScope = null;
        if (!projectName.isEmpty()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            projectScope = new ProjectScope(project);
        }
        Map<String, SortedSet<GlobalVariableModel>> path2globalVariables = S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId).getPath2GlobalVariables();
        AddGlobalVariableDialog globalVariableDialog = new AddGlobalVariableDialog(this.fDebugView.getSite().getShell(), path2globalVariables, S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId).getGlobalVariablesToShow(), projectScope);
        if (globalVariableDialog.open() == 0) {
            S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId).addGlobalVariableInToShowList(globalVariableDialog.getAddedGlobalVariables());
            this.fDebugView.getAction(RemoveAllGlobalVariablesAction.ACTION_ID).setEnabled(true);
            this.fDebugView.getViewer().refresh();
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            String sessionId = ActionsUtil.getCurrentSessionId(this.fDebugView);
            if (sessionId.isEmpty()) {
                super.setEnabled(false);
                return;
            }
            GlobalVariablesService globalVariablesService = S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId);
            if (globalVariablesService == null || globalVariablesService.getGlobalVariables().isEmpty()) {
                super.setEnabled(false);
                return;
            }
        }
        super.setEnabled(enabled);
    }
}

