/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core.operations;

import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.internal.core.ModularInstallerActivator;
import com.nxp.s32ds.rcp.modular.internal.core.ModularMetaModelReader;
import com.nxp.s32ds.rcp.modular.internal.core.operations.InstallModularOperation;
import com.nxp.s32ds.rcp.modular.internal.core.operations.UninstallModularOperation;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;

public class ReinstallOperation {
    private final UninstallModularOperation uninstallModularOperation;
    private final InstallModularOperation installModularOperation;

    public ReinstallOperation(ProvisioningSession provisioningSession, ModularMetaModelReader metaModelReader) {
        this.uninstallModularOperation = new UninstallModularOperation(provisioningSession, metaModelReader);
        this.installModularOperation = new InstallModularOperation(provisioningSession, metaModelReader);
    }

    public void execute(Set<ModularPack> modularPacks, IProgressMonitor progressMonitor) {
        ProvisioningJob provisioningJob;
        final MultiStatus status = ModularInstallerActivator.getInstance().createMultiStatus();
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        ModularOperationStatus resolutionStatus = this.uninstallModularOperation.computeOperation(modularPacks, (IProgressMonitor)convert.split(20));
        ProfileChangeOperation operationObject = resolutionStatus.getExecutableOperation();
        try {
            try {
                provisioningJob = operationObject.getProvisioningJob((IProgressMonitor)convert.split(20));
                provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        status.add(event.getResult());
                    }
                });
                status.add(provisioningJob.runModal((IProgressMonitor)convert.split(60)));
                provisioningJob.join();
            }
            catch (InterruptedException e) {
                ModularInstallerActivator.getInstance().logWarning("Reinstall Operation was interrupted", e);
                convert.done();
                return;
            }
        }
        finally {
            convert.done();
        }
        convert = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        resolutionStatus = this.installModularOperation.computeOperation(modularPacks, (IProgressMonitor)convert.split(20));
        provisioningJob = resolutionStatus.getExecutableOperation().getProvisioningJob((IProgressMonitor)convert.split(20));
        if (provisioningJob != null) {
            provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    status.add(event.getResult());
                }
            });
            status.add(provisioningJob.runModal((IProgressMonitor)convert.split(60)));
            try {
                try {
                    provisioningJob.join();
                }
                catch (InterruptedException e) {
                    ModularInstallerActivator.getInstance().logWarning("Reinstall Operation was interrupted", e);
                    convert.done();
                    return;
                }
            }
            finally {
                convert.done();
            }
        }
    }
}

