/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.debugger.core;

import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.HardwareDebuggerCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.CoreDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CoreDebuggerDescriptors {
    public static CoreDebuggerRegistry getCoreRegistry() {
        CoreDebuggerRegistry coreRegistry = HardwareDebuggerCoreActivator.getInstance().getCoreDebuggerRegistry();
        return coreRegistry;
    }

    public static List<CoreDebuggerDescriptor> getCoreDescriptors(String coreId) {
        CoreDebuggerRegistry coreRegistry = HardwareDebuggerCoreActivator.getInstance().getCoreDebuggerRegistry();
        return coreRegistry.getCoreDebuggerDescriptors(coreId);
    }

    public static String getClientPath(String coreId, String debuggerId) {
        return CoreDebuggerDescriptors.getClientPath(coreId, debuggerId, null);
    }

    public static String getClientPath(String coreId, String debuggerId, String toolchain) {
        CoreDebuggerDescriptor found = CoreDebuggerDescriptors.getCoreDebuggerDescriptor(coreId, debuggerId, toolchain);
        if (found == null) {
            return "";
        }
        String clientPath = found.getClientPath();
        if (clientPath == null) {
            return "";
        }
        return clientPath;
    }

    public static String getSeggerPath(String coreId, String debuggerId, String toolchainId) {
        CoreDebuggerDescriptor found = CoreDebuggerDescriptors.getCoreDebuggerDescriptor(coreId, debuggerId, toolchainId);
        if (found == null) {
            return "";
        }
        String seggerPath = found.getSeggerPath();
        if (seggerPath == null) {
            return "";
        }
        return seggerPath;
    }

    private static CoreDebuggerDescriptor getCoreDebuggerDescriptor(String coreId, String debuggerId, String toolchain) {
        CoreDescriptor coreDescriptor = CoreDescriptors.getCoreDescriptor((String)coreId);
        if (coreDescriptor == null) {
            return null;
        }
        CoreDebuggerRegistry coreRegistry = HardwareDebuggerCoreActivator.getInstance().getCoreDebuggerRegistry();
        List coreDebuggerDescriptors = coreRegistry.getCoreDebuggerDescriptors(coreDescriptor.getId());
        if (coreDebuggerDescriptors.isEmpty()) {
            return null;
        }
        CoreDebuggerDescriptor found = null;
        if (toolchain != null) {
            for (CoreDebuggerDescriptor coreDebuggerDescriptor : coreDebuggerDescriptors) {
                String toolchainId;
                if (!coreDebuggerDescriptor.getDebuggerId().equals(debuggerId) || (toolchainId = coreDebuggerDescriptor.getToolchainId()) == null || !toolchain.startsWith(toolchainId)) continue;
                found = coreDebuggerDescriptor;
                break;
            }
        } else {
            for (CoreDebuggerDescriptor coreDebuggerDescriptor : coreDebuggerDescriptors) {
                if (!coreDebuggerDescriptor.getDebuggerId().equals(debuggerId)) continue;
                found = coreDebuggerDescriptor;
                break;
            }
        }
        return found;
    }

    public static Collection<String> getClientPaths(String coreId, String debuggerId) {
        CoreDescriptor coreDescriptor = CoreDescriptors.getCoreDescriptor((String)coreId);
        if (coreDescriptor == null) {
            return Collections.emptySet();
        }
        CoreDebuggerRegistry coreRegistry = HardwareDebuggerCoreActivator.getInstance().getCoreDebuggerRegistry();
        List coreDebuggerDescriptors = coreRegistry.getCoreDebuggerDescriptors(coreDescriptor.getId());
        return coreDebuggerDescriptors.stream().filter(desc -> desc.getDebuggerId().equals(debuggerId) && desc.getClientPath() != null).map(desc -> desc.getClientPath()).collect(Collectors.toSet());
    }

    public static Collection<String> getDeviceClientPaths(String deviceId, String debuggerId) {
        if (deviceId == null || deviceId.isEmpty() || debuggerId == null || debuggerId.isEmpty()) {
            return Collections.emptyList();
        }
        return DeviceDescriptors.getDeviceCoreDescriptors().stream().filter(desc -> desc.getDeviceId().equals(deviceId)).map(desc -> CoreDebuggerDescriptors.getClientPaths(desc.getCoreId(), debuggerId)).flatMap(paths -> paths.stream()).collect(Collectors.toSet());
    }
}

