/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.importWizards;

import com.nxp.swtools.asr.convertor.ImportEpcResultEnum;
import com.nxp.swtools.asr.importWizards.ImportEpcWizardPage;
import com.nxp.swtools.asr.importWizards.Messages;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.wizards.KExWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportEpcWizard
extends KExWizard
implements IImportWizard {
    static final Logger LOGGER = LogManager.getLogger(ImportEpcWizard.class);
    ImportEpcWizardPage mainPage;
    ISharedConfiguration targetConfig;

    public ImportEpcWizard() {
        this.setNeedsProgressMonitor(true);
        this.targetConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.mainPage = new ImportEpcWizardPage(this.targetConfig);
    }

    public void init(@Nullable IWorkbench workbench, @Nullable IStructuredSelection selection) {
        this.setWindowTitle(Messages.get().ImportWizardTitle);
        this.setNeedsProgressMonitor(true);
        this.mainPage.setTitle(this.mainPage.getTitle());
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        if (!this.mainPage.isPageComplete()) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        if (!this.mainPage.isPageComplete()) {
            return false;
        }
        if (this.mainPage.importAsNew) {
            if (!this.mainPage.isToolSupported()) {
                return false;
            }
            if (this.targetConfig.isDirty() && !this.targetConfig.isEmpty()) {
                Shell shell = this.getShell();
                assert (shell != null);
                int res = ConfigurationUtils.saveDirtyConfiguration((Shell)shell, null, null, (boolean)true);
                switch (res) {
                    case 64: 
                    case 128: {
                        break;
                    }
                    case 256: {
                        return false;
                    }
                }
            }
        }
        final AtomicReference<ImportEpcResultEnum> result = new AtomicReference<ImportEpcResultEnum>(ImportEpcResultEnum.FAIL_NO_MODULES);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(@Nullable IProgressMonitor monitor) {
                    if (monitor != null) {
                        monitor.beginTask(Messages.get().ImportTaskCaption, 2);
                        result.set(ImportEpcWizard.this.mainPage.performFinish());
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            result.set(ImportEpcResultEnum.FAIL);
            LOGGER.severe(e.getMessage());
        }
        ImportEpcResultEnum finishResult = result.get();
        switch (finishResult) {
            case FAIL: {
                this.openErrorMessageDialog(Messages.get().ErrorDialogFailMessage);
                break;
            }
            case FAIL_NO_VARIANTS: {
                this.openErrorMessageDialog(Messages.get().ErrorDialogNoVariantsMessage);
                break;
            }
            case FAIL_NO_MODULES: {
                this.openErrorMessageDialog(Messages.get().ErrorDialogMessage);
                break;
            }
            case FAIL_CHECK_ECUC_MODULE_DEF: {
                this.openErrorMessageDialog(Messages.get().ErrorDialogModuleCheckDefMessage);
                break;
            }
        }
        return finishResult.equals((Object)ImportEpcResultEnum.SUCCESS);
    }

    private void openErrorMessageDialog(String message) {
        LOGGER.log(Level.SEVERE, "Configuration couldn't be imported.");
        if (!SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode") && !SWToolsProperties.isHeadlessOn()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.get().ErrorDialogTitle, (String)message);
        }
    }
}

