/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.epc.model;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.asr.epc.model.FunctionalProperty;
import com.nxp.swtools.asr.epc.model.PinMapping;
import com.nxp.swtools.asr.epc.model.PinMode;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="pins_mapping")
public class AsrPinsMapping {
    private static final Logger LOGGER = LogManager.getLogger(AsrPinsMapping.class);
    private static final String PERIPHERAL_PINS_MAPPING_FILE_NAME = "port_mapping.xml";
    @ElementList(type=PinMapping.class, required=true, inline=true)
    private List<PinMapping> pinMappings;
    @ElementList(name="functional_properties", entry="functional_property", empty=false, required=false)
    private List<FunctionalProperty> functionalProperties;

    protected AsrPinsMapping() {
        this(new ArrayList<PinMapping>(), new ArrayList<FunctionalProperty>());
    }

    public AsrPinsMapping(List<PinMapping> pinMappings, List<FunctionalProperty> functionalProperties) {
        this.pinMappings = pinMappings;
        this.functionalProperties = functionalProperties;
    }

    public static void loadPinsPeripheralsMappingFile() {
        ICommonConfig commonConfig = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig();
        String mcu = commonConfig.getMcu();
        String sdkVersion = commonConfig.getSdkVersion();
        IProcessorMasterToolInfo processorMasterToolInfo = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getProcessorMasterToolInfo(mcu, sdkVersion);
        if (processorMasterToolInfo != null) {
            String mcuDataDir = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getDataDir();
            String subDir = processorMasterToolInfo.getSubDir();
            String selectedMcuPackage = commonConfig.getPackage();
            String pinsMappingFilePath = String.valueOf(mcuDataDir) + File.separator + subDir + File.separator + selectedMcuPackage + File.separator + PERIPHERAL_PINS_MAPPING_FILE_NAME;
            File pinsPeripheralsMappingFile = new File(pinsMappingFilePath);
            if (pinsPeripheralsMappingFile.exists() && pinsPeripheralsMappingFile.isFile()) {
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (InputStream fileInStr = UtilsDecryption.getFileInputStream((File)pinsPeripheralsMappingFile);){
                        Persister serializer = new Persister();
                        AsrPinsMapping result = (AsrPinsMapping)serializer.read(AsrPinsMapping.class, fileInStr);
                        AsrImporterHelper.getInstance().setPeripheralsPinsMapping(result);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.warning(MessageFormat.format("[DATA] The following exception occured when trying to read the content of {0} file {1}.", PERIPHERAL_PINS_MAPPING_FILE_NAME, e.getLocalizedMessage()));
                }
            }
        }
    }

    public @Nullable FunctionalProperty findFunctionalPropertyByForeignId(String id) {
        for (FunctionalProperty property : this.functionalProperties) {
            if (!property.getForeignId().equals(id)) continue;
            return property;
        }
        return null;
    }

    public @Nullable PinMapping getPinMappingByMscrAndSiul2Instance(int mscr, String siul2Instance) {
        for (PinMapping pinMapping : this.pinMappings) {
            if (pinMapping.getMSCR() != mscr) continue;
            for (PinMode pinMode : pinMapping.getPinModes()) {
                if (!pinMode.getCtPeripheral().equals(siul2Instance)) continue;
                return pinMapping;
            }
        }
        return null;
    }

    public List<PinMapping> getPinMappings() {
        return this.pinMappings;
    }

    public @Nullable PinMapping getPinMappingByMscr(int mscr) {
        for (PinMapping pinMapping : this.pinMappings) {
            if (pinMapping.getMSCR() != mscr) continue;
            return pinMapping;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.functionalProperties, this.pinMappings);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsrPinsMapping other = (AsrPinsMapping)obj;
        return Objects.equals(this.functionalProperties, other.functionalProperties) && Objects.equals(this.pinMappings, other.pinMappings);
    }
}

