/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.convertor;

import com.nxp.swtools.asr.epc.model.EcucNumericalParamValue;
import com.nxp.swtools.asr.epc.model.EcucTextualParamValue;
import com.nxp.swtools.asr.epc.model.FunctionalProperty;
import com.nxp.swtools.asr.epc.model.PropertyValue;
import com.nxp.swtools.asr.epc.model.SreOption;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageValue;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinsFunction;
import com.nxp.swtools.provider.configuration.storage.pins.StoragePinsTool;
import com.nxp.swtools.provider.configuration.storage.pins.StorageRoutedPin;
import java.util.ArrayList;
import java.util.List;

public class PinsImporterHelper {
    public static @Nullable StoragePinsFunction getOrCreateStoragePinsFunction(ISharedConfiguration sharedConfig, String containerId, String name) {
        StoragePinsTool storagePins;
        if (containerId.equals("PortContainer") && (storagePins = sharedConfig.getTools().getPins()) != null) {
            StoragePinsFunction function = storagePins.findFunctionByName(name);
            if (function != null) {
                return function;
            }
            StoragePinsFunction newFunction = new StoragePinsFunction(name);
            ArrayList<StoragePinsFunction> newFunctionsList = new ArrayList<StoragePinsFunction>(storagePins.getFunctions());
            newFunctionsList.add(newFunction);
            storagePins.setFunctions(newFunctionsList);
            return newFunction;
        }
        return null;
    }

    public static void clearPinsFunctions(ISharedConfiguration sharedCfg) {
        StoragePinsTool storagePinsTool = sharedCfg.getTools().getPins();
        if (storagePinsTool != null) {
            storagePinsTool.setFunctions(new ArrayList());
        }
    }

    private static String getSettingId(String definitionRef) {
        if (definitionRef.isEmpty()) {
            return definitionRef;
        }
        String[] defRefVals = definitionRef.split("/");
        return defRefVals[defRefVals.length - 1];
    }

    public static @Nullable String getPinMode(List<EcucTextualParamValue> textualValues) {
        for (EcucTextualParamValue textualValue : textualValues) {
            String settingId = PinsImporterHelper.getSettingId(textualValue.getDefinitionRef().getValue());
            if (!settingId.equals("PortPinMode")) continue;
            return textualValue.getValue();
        }
        return null;
    }

    public static int getPinMscr(List<EcucNumericalParamValue> numericalValues) {
        for (EcucNumericalParamValue numericalValue : numericalValues) {
            String settingId = PinsImporterHelper.getSettingId(numericalValue.getDefinitionRef().getValue());
            if (!settingId.equals("PortPinPcr")) continue;
            return Integer.valueOf(numericalValue.getValue());
        }
        return -1;
    }

    public static @Nullable String getPinSiul2Instance(List<EcucTextualParamValue> textualValues) {
        for (EcucTextualParamValue textualValue : textualValues) {
            String settingId = PinsImporterHelper.getSettingId(textualValue.getDefinitionRef().getValue());
            if (!settingId.equals("PortPinSiul2Instance")) continue;
            return textualValue.getValue();
        }
        return null;
    }

    public static void addPinFeatureFromProperty(StorageRoutedPin routedPin, FunctionalProperty property, String value) {
        String featureName = property.getCtId();
        String featureValue = "";
        for (PropertyValue propertyValue : property.getValues()) {
            if (!propertyValue.getForeignValue().equalsIgnoreCase(value)) continue;
            featureValue = propertyValue.getCtValue();
            break;
        }
        PinsImporterHelper.addPinFeature(routedPin, new StorageValue(featureName, featureValue));
    }

    public static void addPinFeatureFromSreOption(StorageRoutedPin routedPin, SreOption sreOption, String value) {
        String featureName = sreOption.getCtId();
        String featureValue = "";
        for (PropertyValue propertyValue : sreOption.getValues()) {
            if (!propertyValue.getForeignValue().equalsIgnoreCase(value)) continue;
            featureValue = propertyValue.getCtValue();
            break;
        }
        PinsImporterHelper.addPinFeature(routedPin, new StorageValue(featureName, featureValue));
    }

    private static void addPinFeature(StorageRoutedPin routedPin, StorageValue storageValue) {
        List pinFeatures = routedPin.getPinFeatures();
        if (pinFeatures == null) {
            ArrayList<StorageValue> storageValues = new ArrayList<StorageValue>();
            storageValues.add(storageValue);
            routedPin.setPinFeatures(storageValues);
        } else {
            pinFeatures.add(storageValue);
        }
    }
}

