/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.convertor;

import com.nxp.swtools.asr.epc.model.AsrPinsMapping;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.scripting.api.ScriptUtils;
import com.nxp.swtools.utils.scripting.api.ScriptXMLDocument;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AsrImporterHelper {
    private static final Logger LOGGER = LogManager.getLogger(AsrImporterHelper.class);
    private static ScriptUtils utils = new ScriptUtils();
    protected boolean clearArPackageDoc = true;
    private Map<String, String> peripheralsClockMap = new HashMap<String, String>();
    @Nullable
    private AsrPinsMapping periphsPinsMapping = null;

    private AsrImporterHelper() {
        SharedConfigurationFactory.getSharedConfigurationSingleton().addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(ISharedConfiguration sharedConfig, ConfigChangeReason reason) {
                if ((reason == ConfigChangeReason.LOAD_CONFIG || reason == ConfigChangeReason.NEW_CONFIG) && AsrImporterHelper.this.clearArPackageDoc) {
                    utils.setArPackageDocument(null);
                    AsrImporterHelper.this.getPeripheralClocksMapping().clear();
                    AsrImporterHelper.this.periphsPinsMapping = null;
                } else {
                    AsrImporterHelper.this.clearArPackageDoc = true;
                }
            }
        });
    }

    public void buildArPackageDOM(List<String> files) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document arPackageDocument = docBuilder.newDocument();
            Element root = arPackageDocument.createElement("AR-PACKAGES");
            for (String file : files) {
                Document importedDoc = docBuilder.parse(new File(file));
                NodeList arPackageList = importedDoc.getElementsByTagName("AR-PACKAGE");
                int i = 0;
                while (i < arPackageList.getLength()) {
                    Node nodeToImport = arPackageDocument.importNode(arPackageList.item(i), true);
                    Element elementToImport = (Element)nodeToImport;
                    if (elementToImport.getElementsByTagName("ECUC-MODULE-CONFIGURATION-VALUES").getLength() != 0) {
                        ++i;
                        continue;
                    }
                    root.appendChild(nodeToImport);
                    i += elementToImport.getElementsByTagName("AR-PACKAGE").getLength() + 1;
                }
            }
            arPackageDocument.appendChild(root);
            if (root.getChildNodes().getLength() > 0) {
                utils.setArPackageDocument(new ScriptXMLDocument(arPackageDocument));
                this.setClearArPackageDoc(false);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.severe(MessageFormat.format("[DATA] The following exception occured when creating AR-PACKAGE nodes document: {0}", e.getMessage()));
        }
    }

    public void setClearArPackageDoc(boolean clearArPackageDoc) {
        this.clearArPackageDoc = clearArPackageDoc;
    }

    public static AsrImporterHelper getInstance() {
        try {
            return (AsrImporterHelper)SWTFactoryProxy.INSTANCE.getSingletonInstance(AsrImporterHelper.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot create instance of ASR importer helper", e);
        }
    }

    public boolean isFileBswmdModule(String fileName) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document importedDoc = docBuilder.parse(new File(fileName));
            NodeList moduleDescriptionList = importedDoc.getElementsByTagName("BSW-MODULE-DESCRIPTION");
            NodeList implementationList = importedDoc.getElementsByTagName("BSW-IMPLEMENTATION");
            return moduleDescriptionList.getLength() > 0 || implementationList.getLength() > 0;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.severe(MessageFormat.format("[DATA] The following exception occured {0} when parsing the following file: {1}", e.getMessage(), fileName));
            return false;
        }
    }

    public Map<String, String> getPeripheralClocksMapping() {
        return this.peripheralsClockMap;
    }

    public void setPeripheralsPinsMapping(AsrPinsMapping mapping) {
        this.periphsPinsMapping = mapping;
    }

    public @Nullable AsrPinsMapping getPeripheralsPinsMapping() {
        return this.periphsPinsMapping;
    }
}

