/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.descriptors.CoreBootRole;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import com.nxp.swtools.sdkmanifest.loader.MultipleManifestLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class SdkDeviceCore {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkDeviceCore.class);
    @NonNull
    static final Set<CoreBootRole> DEFAULT_BOOT_ROLES;
    @NonNull
    private static final String BOOT_ROLES_ATTR = "boot_role";
    @NonNull
    private static final String SLAVE_ROLES_ATTR = "slave_roles";
    @NonNull
    private final String coreName;
    @NonNull
    private final String coreType;
    @NonNull
    private final String coreId;
    private boolean hasFPU;
    @NonNull
    private final Set<CoreBootRole> bootRoles;
    @Nullable
    private final Set<@NonNull String> slaveRoles;

    static {
        Set<CoreBootRole> defaultBootRoles = Collections.unmodifiableSet(EnumSet.allOf(CoreBootRole.class));
        assert (defaultBootRoles != null);
        DEFAULT_BOOT_ROLES = defaultBootRoles;
    }

    public SdkDeviceCore(@NonNull String coreId, @NonNull String coreName, @NonNull String coreType, boolean hasFPU, @NonNull Set<CoreBootRole> bootRoles, @Nullable Set<@NonNull String> slaveRoles) throws IllegalArgumentException {
        if (UtilsText.isEmpty((String)coreName)) {
            throw new IllegalArgumentException("Parameter cannot be empty");
        }
        this.coreName = coreName;
        if (!coreName.equals(coreName.trim())) {
            LOGGER.log(Level.SEVERE, "The core name contains some leading or trailing spaces. Identifier expected. '" + coreName + '\'');
            assert (false);
        }
        if (!coreName.equals(coreName.toLowerCase(Locale.ENGLISH)) && !coreName.equals("CoRe")) {
            LOGGER.log(Level.SEVERE, "The core name extected in lower case: '" + coreName + '\'');
            assert (false);
        }
        if (coreId.isEmpty()) {
            this.coreId = coreName;
            if (MultipleManifestLoader.getMinFormatVersion() >= 3.0) {
                LOGGER.log(Level.WARNING, "`id` attr not specified in `core` element");
            }
        } else {
            this.coreId = coreId;
        }
        if (coreType.isEmpty()) {
            this.coreType = this.coreId;
            if (MultipleManifestLoader.getMinFormatVersion() >= 3.0) {
                LOGGER.log(Level.WARNING, "`type` attr not specified in `core` element");
            }
        } else {
            this.coreType = coreType;
        }
        this.hasFPU = hasFPU;
        this.bootRoles = bootRoles;
        this.slaveRoles = slaveRoles;
    }

    public SdkDeviceCore(@NonNull Element coreElem) throws IllegalArgumentException {
        this(UtilsText.safeString((String)coreElem.getAttribute("id")), UtilsText.safeString((String)coreElem.getAttribute("name")), UtilsText.safeString((String)coreElem.getAttribute("type")), ManifestLoaderUtils.isXmlTrue(coreElem.getAttribute("fpu")), coreElem.hasAttribute(BOOT_ROLES_ATTR) ? CoreBootRole.loadBootRoles(UtilsText.safeString((String)coreElem.getAttribute(BOOT_ROLES_ATTR))) : DEFAULT_BOOT_ROLES, (Set<String>)(coreElem.hasAttribute(SLAVE_ROLES_ATTR) ? new HashSet<String>(Arrays.asList(coreElem.getAttribute(SLAVE_ROLES_ATTR).split(" "))) : null));
    }

    public @Nullable Collection<@NonNull String> getSlavesRoles() {
        return this.slaveRoles;
    }

    public @NonNull String getCoreId() {
        return this.coreId;
    }

    public @NonNull String getCoreName() {
        return this.coreName;
    }

    public @NonNull String getCoreType() {
        return this.coreType;
    }

    public boolean hasFPU() {
        return this.hasFPU;
    }

    public boolean canBootPrimary() {
        return this.bootRoles.contains((Object)CoreBootRole.PRIMARY);
    }

    public boolean canBootSecondary() {
        return this.bootRoles.contains((Object)CoreBootRole.SECONDARY);
    }

    public String toString() {
        return String.valueOf(this.coreId) + '/' + this.coreName + '/' + this.coreType;
    }

    public boolean isCortexM() {
        return this.coreType.startsWith("cm");
    }
}

