/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardExample;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceCore;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkIncludePath;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;

@NonNullByDefault
public abstract class ASdkProjectExample {
    protected static final Logger LOGGER = LogManager.getLogger(SdkBoardExample.class);
    protected final String id;
    protected final String name;
    protected final String category;
    protected final String path;
    @Nullable
    protected final String description;
    protected final List<@NonNull SdkSourceFile> srcFiles;
    @Nullable
    protected final List<@NonNull SdkIncludePath> includePaths;
    protected final Collection<@NonNull String> dependencies;
    @Nullable
    protected final Collection<@NonNull String> devices;
    @Nullable
    protected Collection<@NonNull String> toolchains;
    @Nullable
    protected Collection<@NonNull String> compilers;
    @Nullable
    protected final String deviceCoreId;
    protected ProjectExampleType type;

    public ASdkProjectExample(String id, String name, String category, String path, @Nullable String description, List<@NonNull SdkSourceFile> srcFiles, @Nullable List<@NonNull SdkIncludePath> includePaths, Collection<@NonNull String> dependencies, @Nullable Collection<@NonNull String> devices, @Nullable Collection<@NonNull String> toolchains, @Nullable Collection<@NonNull String> compilers, @Nullable String deviceCoreId, ProjectExampleType type) {
        this.id = id;
        this.name = name;
        this.category = category;
        this.path = UtilsFile.convertToOSPathFormat((String)path);
        this.description = description;
        this.srcFiles = CollectionsUtils.unmodifiableList(srcFiles);
        this.includePaths = includePaths == null ? null : CollectionsUtils.unmodifiableList(includePaths);
        this.dependencies = CollectionsUtils.unmodifiableCollection(dependencies);
        this.devices = devices != null ? CollectionsUtils.unmodifiableCollection(devices) : null;
        this.toolchains = toolchains != null ? CollectionsUtils.unmodifiableCollection(toolchains) : null;
        this.compilers = compilers != null ? CollectionsUtils.unmodifiableCollection(compilers) : null;
        this.deviceCoreId = deviceCoreId;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSdkRelPath() {
        return this.path;
    }

    public @Nullable List<@NonNull SdkIncludePath> getIncludePaths() {
        return this.includePaths;
    }

    public @Nullable String getDeviceCoreId() {
        return this.deviceCoreId;
    }

    public @Nullable String getDeviceCoreName() {
        SdkDeviceCore core;
        Collection<Object> cores;
        String exampleCoreId = this.getDeviceCoreId();
        SdkDeviceDescriptor device = this.getParentProcessor();
        Collection<Object> collection = cores = device != null ? device.getCores() : Collections.emptyList();
        if (cores.size() == 1) {
            core = (SdkDeviceCore)CollectionsUtils.first(cores);
        } else {
            if (exampleCoreId == null || device == null) {
                return null;
            }
            core = (SdkDeviceCore)CollectionsUtils.findAny(device.getCores(), devCore -> devCore.getCoreId().equals(exampleCoreId));
        }
        return core != null ? core.getCoreName() : null;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    protected List<@NonNull SdkSourceFile> getSourceFiles() {
        return this.srcFiles;
    }

    public Stream<@NonNull SdkSourceFile> getSourceFiles(SdkManifestDescriptor.ManifestHelper variableResolver) {
        Stream<@NonNull SdkSourceFile> result = this.getSourceFiles().stream().map(src -> new SdkSourceFile((SdkSourceFile)src, variableResolver));
        assert (result != null);
        return result;
    }

    public Collection<@NonNull String> getDependencies() {
        return this.dependencies;
    }

    public @Nullable Collection<String> getDevices() {
        return this.devices;
    }

    public @Nullable Collection<@NonNull String> getToolchains() {
        return this.toolchains;
    }

    public void setToolchains(Collection<@NonNull String> t) {
        this.toolchains = CollectionsUtils.unmodifiableCollection(t);
    }

    public boolean isToolchainSupported(String toolchainId) {
        if (this.toolchains != null) {
            return this.toolchains.contains(toolchainId);
        }
        return true;
    }

    public @Nullable Collection<@NonNull String> getCompilers() {
        return this.compilers;
    }

    public void setCompilers(Collection<@NonNull String> c) {
        this.compilers = CollectionsUtils.unmodifiableCollection(c);
    }

    public boolean isAnyCompilerSupported(List<@NonNull String> compilersIds) {
        Collection<@NonNull String> locCompilers = this.compilers;
        if (locCompilers == null) {
            return true;
        }
        return !CollectionsUtils.intersection(compilersIds, locCompilers).isEmpty();
    }

    public String getFullName() {
        return String.valueOf(this.category) + '/' + this.name;
    }

    public String toString() {
        return this.getFullName();
    }

    public abstract String getFullName4CmdLineTest();

    public abstract String getFullName4UI();

    public abstract @Nullable SdkDeviceDescriptor getParentProcessor();

    public abstract boolean isBoardSpecific();

    public abstract  @Nullable SdkBoardsDescriptor.SdkBoardDescriptor getParentBoard();

    public abstract @Nullable String getMcuXpressoExamplePrjRelPath();

    public abstract Collection<@NonNull String> getLinkedProjectIds();

    public abstract @Nullable ASdkProjectExample getLinkedSlaveProject();

    public abstract @Nullable ASdkProjectExample getLinkedMasterProject();

    public ProjectExampleType getType() {
        return this.type;
    }

    public static enum ProjectExampleType {
        UNDEFINED,
        APPLICATION,
        LIBRARY,
        DEVICE_PROJECT_TEMPLATE;

    }
}

