/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.internal.usb.devices.greenboxii.cmsisdap;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.connection.DebuggerUsbConnectionInterface;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.greenboxii.cmsisdap.GreenBoxIICmsisDapUsbDeviceAccessorLinuxImpl;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.greenboxii.cmsisdap.GreenBoxIICmsisDapUsbDeviceAccessorWindowsImpl;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;

public class GreenBoxIICmsisDapUsbDeviceAccessor
implements DebuggerConnectionAccessor {
    public static final String CMSIS_DAP_VIRTUAL_IP_PREFIX = "cmsisdap";
    public static final String CMSIS_DAP_SERIAL_SEPARATOR = "#";
    public static final String CMSIS_DAP_PROTOCOL_PREFIX = ":%s";
    static final String VID = "0D28";
    static final String PID = "0204";
    private static final String BASE_SPEED = "5000";
    private DebuggerUsbConnectionInterface usbConnectionImpl = null;

    public GreenBoxIICmsisDapUsbDeviceAccessor() {
        if ("win32".equals(Platform.getOS())) {
            this.usbConnectionImpl = new GreenBoxIICmsisDapUsbDeviceAccessorWindowsImpl();
        }
        if ("linux".equals(Platform.getOS())) {
            this.usbConnectionImpl = new GreenBoxIICmsisDapUsbDeviceAccessorLinuxImpl();
        }
    }

    public Collection<DeviceConnection> getActiveDeviceConnections(DebuggerConnectionDescriptor connectionDescriptor) {
        if (connectionDescriptor == null || this.usbConnectionImpl == null) {
            return Collections.emptySet();
        }
        return this.usbConnectionImpl.getConnectedDevices(connectionDescriptor, VID, PID);
    }

    public String getConnectionString(DebuggerConnectionDescriptor connectionDescriptor, DeviceConnection connectionData) {
        if (this.usbConnectionImpl == null) {
            return null;
        }
        return this.usbConnectionImpl.getConnectionString(connectionDescriptor, connectionData);
    }

    public String getBaseSpeed() {
        return BASE_SPEED;
    }
}

