/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.gui.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.report.EFuseSummaryGenerator;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.utils.EfuseExpressions;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.controls.ArraySettingControl;
import com.nxp.swtools.efuse.controls.ButtonSettingControl;
import com.nxp.swtools.efuse.controls.EnumSettingControl;
import com.nxp.swtools.efuse.controls.IntegerSettingControl;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.gui.utils.Messages;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseEnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.AdvancedFuseSetting;
import com.nxp.swtools.efuse.xml.settings.HeaderSetting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.services.IDisposable;

public class EfuseActions {
    private static final Logger LOGGER = LogManager.getLogger(EfuseActions.class);
    private static final Pattern RESET_STRUCTS_REGEX = Pattern.compile("(resetStructSettings)\\((.*)\\)", 8);
    private static final Pattern EXPORT_CONFIG_REGEX = Pattern.compile("(exportConfig)", 8);
    private static final Pattern IMPORT_CONFIG_REGEX = Pattern.compile("(importConfig)", 8);
    private static final Pattern UPDATE_DEPENDENT_SETTINGS_REGEX = Pattern.compile("(updateDependentSettings)\\((.*)\\)", 8);
    private static final Pattern REMOVE_FUSE_WORD_REGEX = Pattern.compile("(removeFuseWord)", 8);
    private static final Pattern SYNC_REGEX = Pattern.compile("(sync)\\((.*)\\)", 8);
    private static final Pattern EXPORT_ELF_REGEX = Pattern.compile("(exportELF)", 8);

    public static void executeAction(String action) {
        Matcher resetStructsActionMatcher = RESET_STRUCTS_REGEX.matcher(action);
        if (resetStructsActionMatcher.find() && resetStructsActionMatcher.groupCount() == 2) {
            EfuseActions.resetStructsAction(resetStructsActionMatcher);
        } else {
            Matcher exportConfigMatcher = EXPORT_CONFIG_REGEX.matcher(action);
            if (exportConfigMatcher.find()) {
                Shell currentShell;
                Display currentDisplay = Display.getCurrent();
                if (currentDisplay != null && (currentShell = currentDisplay.getActiveShell()) != null) {
                    EfuseActions.exportConfigAction(currentShell);
                }
            } else {
                Matcher importConfigMatcher = IMPORT_CONFIG_REGEX.matcher(action);
                if (importConfigMatcher.find()) {
                    EfuseActions.importEfuseImage();
                } else {
                    Shell shell;
                    Display display;
                    Matcher exportELFAction = EXPORT_ELF_REGEX.matcher(action);
                    if (exportELFAction.find() && (display = Display.getCurrent()) != null && (shell = display.getActiveShell()) != null) {
                        EfuseActions.exportELFAction(shell);
                    }
                }
            }
        }
    }

    private static void resetStructsAction(Matcher actionMatcher) {
        String structIdentifiers = actionMatcher.group(2);
        if (structIdentifiers != null) {
            String[] structIdentifiersList;
            String[] stringArray = structIdentifiersList = structIdentifiers.split("\\,");
            int n = structIdentifiersList.length;
            int n2 = 0;
            while (n2 < n) {
                String structId = stringArray[n2];
                ABaseUIComponentSetting componentSetting = EfuseControllerUtils.getUIComponentSettingById((String)structId);
                if (EfuseUtils.isImportProcessRunning()) {
                    if (componentSetting instanceof EfuseStructSetting && !((EfuseStructSetting)componentSetting).isVisible()) {
                        EfuseControllerUtils.resetStructSetting((EfuseStructSetting)((EfuseStructSetting)componentSetting));
                    }
                } else if (componentSetting instanceof EfuseStructSetting && !EfuseUtils.isSwitchingBetweenModesInProgress()) {
                    EfuseControllerUtils.resetStructSetting((EfuseStructSetting)((EfuseStructSetting)componentSetting));
                }
                ++n2;
            }
        }
    }

    private static boolean exportConfigAction(Shell shell) {
        if (EfuseController.getInstance().getProblemsManager().hasEfuseToolErrors()) {
            MessageDialog.openError((Shell)shell, (String)Messages.ExportConfiguration, (String)Messages.ExportConfigurationMessage);
            return false;
        }
        FileDialog fileDialogChooser = EfuseGuiUtils.createFileDialogChooser(8192, Messages.SavePanelTitle, "", EfuseGuiUtils.createBinaryFormatExtensionsList(), EfuseGuiUtils.createBinaryFormatNamesList(), shell, false);
        String filePath = fileDialogChooser.open();
        if (filePath != null) {
            filePath = UctLayoutUtils.concatExtensionToFile((FileDialog)fileDialogChooser, (String)filePath, (String)"*.bin");
            String htmlReportPath = UtilsText.safeString((String)new StringJoiner(File.separator).add(filePath.substring(0, filePath.lastIndexOf(File.separator))).add("efuse_report.html").toString());
            File selectedFile = new File(filePath);
            File reportFile = new File(htmlReportPath);
            if (selectedFile.exists() && !EfuseGuiUtils.shouldOverwriteFile(shell, selectedFile)) {
                return false;
            }
            EfuseActions.exportEfuseConfig(selectedFile);
            EfuseActions.exportEfuseHtmlReport(reportFile);
            return true;
        }
        return false;
    }

    private static boolean exportELFAction(Shell shell) {
        if (EfuseController.getInstance().getProblemsManager().hasEfuseToolErrors()) {
            MessageDialog.openError((Shell)shell, (String)Messages.ExportConfiguration, (String)Messages.ExportConfigurationMessage);
            return false;
        }
        FileDialog fileDialogChooser = EfuseGuiUtils.createFileDialogChooser(8192, Messages.SavePanelTitle, "", EfuseGuiUtils.createELFFormatExtensionsList(), EfuseGuiUtils.createELFFormatNamesList(), shell, false);
        String filePath = fileDialogChooser.open();
        if (filePath != null) {
            filePath = UctLayoutUtils.concatExtensionToFile((FileDialog)fileDialogChooser, (String)filePath, (String)"*.elf");
            String htmlReportPath = UtilsText.safeString((String)new StringJoiner(File.separator).add(filePath.substring(0, filePath.lastIndexOf(File.separator))).add("efuse_report.html").toString());
            File selectedFile = new File(filePath);
            File reportFile = new File(htmlReportPath);
            if (selectedFile.exists() && !EfuseGuiUtils.shouldOverwriteFile(shell, selectedFile)) {
                return false;
            }
            EfuseActions.exportEfuseELFConfig(selectedFile);
            EfuseActions.exportEfuseHtmlReport(reportFile);
            return true;
        }
        return false;
    }

    public static void exportEfuseConfig(File selectedFile) {
        EfuseActions.export(selectedFile, EfuseControllerUtils.getEfuseBinaryContent());
    }

    public static void exportEfuseHtmlReport(File selectedFile) {
        EfuseActions.export(selectedFile, EFuseSummaryGenerator.getReportConfiguration().getBytes(Charset.forName("UTF-8")));
    }

    public static void exportEfuseHtmlTable(File selectedFile) {
        String eFuseReportTable = EFuseSummaryGenerator.createTableFromFuseWords((int)0);
        if (eFuseReportTable != null) {
            EfuseActions.export(selectedFile, eFuseReportTable.getBytes(Charset.forName("UTF-8")));
        }
    }

    public static void exportEfuseELFConfig(File selectedFile) {
        EfuseActions.export(selectedFile, EfuseControllerUtils.getElfApplicationContent());
    }

    private static void export(File selectedFile, byte[] data) {
        try {
            if (!selectedFile.exists() && !selectedFile.createNewFile()) {
                LOGGER.log(Level.WARNING, Messages.ErrMsg_CreateNewFile);
            }
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileOutputStream outputStream = new FileOutputStream(selectedFile);){
                    outputStream.write(data);
                    outputStream.flush();
                    EfuseController.getInstance().setSaved(true);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException err) {
                LOGGER.log(Level.WARNING, Messages.ErrMsg_WriteToFile, err);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, Messages.ErrMsg_CreateNewFile, exception);
        }
    }

    private static void importEfuseImage() {
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            Shell currentShell = currentDisplay.getActiveShell();
            int result = 1;
            if (currentShell != null) {
                if (!EfuseController.getInstance().isSaved().get() && !EfuseController.getInstance().getProblemsManager().hasEfuseToolErrors()) {
                    String[] buttonLabels = new String[]{UtilsText.safeString((String)Messages.Btn_Yes), UtilsText.safeString((String)Messages.Btn_No), UtilsText.safeString((String)Messages.Btn_Cancel)};
                    MessageDialog confirmDialog = new MessageDialog(currentShell, Messages.ImportTitle_Confirmation, null, Messages.ImportMessage_DoYouWantToSaveConfig, 3, buttonLabels, 0);
                    result = confirmDialog.open();
                }
                switch (result) {
                    case 0: {
                        if (!EfuseActions.exportConfigAction(currentShell)) break;
                        EfuseActions.importEfuseImage(currentShell);
                        break;
                    }
                    case 1: {
                        EfuseActions.importEfuseImage(currentShell);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    private static void importEfuseImage(Shell shell) {
        try {
            String filterPath = "";
            FileDialog fileDialogChooser = EfuseGuiUtils.createFileDialogChooser(4096, Messages.ImportEfuseImage, filterPath, EfuseGuiUtils.createBinaryFormatExtensionsList(), EfuseGuiUtils.createBinaryFormatNamesList(), shell, true);
            String selectedPath = fileDialogChooser.open();
            if (selectedPath != null) {
                File selectedFile = new File(selectedPath);
                if (selectedFile.exists()) {
                    EfuseActions.importEfuseImage(selectedFile);
                } else {
                    Display currentDisplay = Display.getCurrent();
                    if (currentDisplay != null) {
                        MessageDialog.openError((Shell)currentDisplay.getActiveShell(), (String)Messages.ErrorTitle_InvalidFile, (String)Messages.ErrorMsg_FileDoesNotExist);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "[TOOL] Error during the eFUSE image import ", exception);
        }
    }

    public static void importEfuseImage(File selectedFile) {
        Display currentDisplay = Display.getCurrent();
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        if (selectedFile.exists()) {
            byte[] data = new byte[]{};
            try {
                data = Files.readAllBytes(Paths.get(selectedFile.getPath(), new String[0]));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "[TOOL] Error while reading from file ", e);
            }
            try {
                Throwable e = null;
                Object var5_8 = null;
                try (FileInputStream inputStream = new FileInputStream(selectedFile);){
                    if (selectedFile.length() == 0L && currentDisplay != null) {
                        MessageDialog.openWarning((Shell)currentDisplay.getActiveShell(), (String)Messages.ImportEfuseImage, (String)Messages.ImportEfuseEmptyFile);
                    } else if (selectedFile.length() < (long)EfuseUtils.getSizeOfEntireFusesStruct((IEfuseMcu)selectedMcu) && currentDisplay != null) {
                        MessageDialog.openError((Shell)currentDisplay.getActiveShell(), (String)Messages.ImportEfuseImage, (String)Messages.ImportEfuseInvalidFile);
                    } else if (inputStream.read(data, 0, data.length) != -1 && selectedFile.length() > 0L) {
                        ByteBuffer byteImage = ByteBuffer.wrap(data);
                        assert (byteImage != null);
                        EfuseUtils.setIsImportProcessRunning((boolean)true);
                        HeaderSetting efuseHeader = EfuseController.getInstance().getEfuseXmlConfig().getHeader();
                        HeaderSetting serialBootHeader = EfuseController.getInstance().getEfuseXmlConfig().getSerialBootHeader();
                        assert (efuseHeader != null);
                        assert (serialBootHeader != null);
                        if (byteImage.capacity() - efuseHeader.getSizeValueInBytes() != selectedMcu.getTemplateAppBinaryContent().capacity() && byteImage.capacity() - (efuseHeader.getSizeValueInBytes() + serialBootHeader.getSizeValueInBytes()) != selectedMcu.getTemplateAppBinaryContent().capacity() && currentDisplay != null) {
                            MessageDialog.openError((Shell)currentDisplay.getActiveShell(), (String)Messages.ImportEfuseImage, (String)Messages.ImportEfuseInvalidFile);
                            EfuseUtils.setIsImportProcessRunning((boolean)false);
                            return;
                        }
                        if (!EfuseControllerUtils.processEfuseImageComponents((IEfuseMcu)selectedMcu, (ByteBuffer)(byteImage = EfuseControllerUtils.removeSerialBootHeader((IEfuseMcu)selectedMcu, (ByteBuffer)byteImage))) && currentDisplay != null) {
                            MessageDialog.openError((Shell)currentDisplay.getActiveShell(), (String)Messages.ImportEfuseImage, (String)Messages.ImportEfuseInvalidHeader);
                            EfuseUtils.setIsImportProcessRunning((boolean)false);
                            return;
                        }
                        EfuseControllerUtils.clearAdvancedFusesArray();
                        for (EfuseEntity efuseEntity : selectedMcu.getAllEfuseEntities()) {
                            ABaseUIComponentSetting componentSetting = efuseEntity.getUIComponentSetting();
                            componentSetting.setVisibleState(EfuseControllerUtils.isComponentVisible((ABaseUIComponentSetting)componentSetting));
                            componentSetting.setDisableState(EfuseControllerUtils.isComponentDisable((ABaseUIComponentSetting)componentSetting));
                        }
                        if (currentDisplay != null) {
                            EfuseControllerUtils.addModifiedFusesInAdvancedArray();
                            EfuseGuiUtils.refreshEfuseBinaryConfigurationTable();
                            EfuseControllerUtils.initAllComponentsState((IEfuseMcu)selectedMcu);
                            EfuseController.getInstance().handleSettingChange(16, null, null, null);
                        }
                        EfuseUtils.setIsImportProcessRunning((boolean)false);
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException err) {
                LOGGER.log(Level.SEVERE, "[TOOL]" + Messages.ErrorAlertTitle + ": " + "Error while reading from file " + err);
            }
        }
    }

    public static void executeRemoveFuseWordAction(String action, ButtonSettingControl buttonSettingControl) {
        Matcher removeFuseWordMatcher = REMOVE_FUSE_WORD_REGEX.matcher(action);
        boolean removed = false;
        Parent parentControl = buttonSettingControl.getParentControl();
        IntegerSettingControl integerControl = parentControl.getChildrenUnmodifiable().stream().filter(child -> child instanceof IntegerSettingControl && ((IntegerSettingControl)((Object)child)).getId().equals("value_advanced")).findFirst().orElse(null);
        if (removeFuseWordMatcher.find()) {
            for (Node node : parentControl.getChildrenUnmodifiable()) {
                String customFuseToRemove;
                AdvancedFuseSetting advancedFuseSetting;
                if (!(node instanceof EnumSettingControl)) continue;
                EnumSettingControl enumNode = (EnumSettingControl)node;
                String fuseWordId = enumNode.getEnumSetting().getCurrentValue();
                ArraySetting fuseArray = EfuseControllerUtils.getAdvancedFusesArray();
                if (fuseArray == null) continue;
                AdvancedFuseSetting advancedFuseWord = fuseArray.getAdvancedFuseSettingByFuseWordId(fuseWordId);
                if (advancedFuseWord != null) {
                    IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
                    fuseArray.getSettings().remove(advancedFuseWord);
                    removed = true;
                    FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)fuseWordId);
                    if (fuseWord != null) {
                        EfuseControllerUtils.resetFuseWordAndComponentsToDefault((FuseWord)fuseWord);
                        StorageEfuseUtils.updateStorageForAdvancedFuseWord((Object)((Object)buttonSettingControl), (String)fuseWordId);
                        if (integerControl != null) {
                            integerControl.checkSynchronizationBetweenModesForFuseWords();
                        }
                    }
                    EfuseControllerUtils.computeAllGuiComponentsExpressions((IEfuseMcu)mcu);
                    continue;
                }
                ABaseUIComponentSetting parent = enumNode.getEnumSetting().getParent();
                if (parent == null || (advancedFuseSetting = fuseArray.getAdvancedFuseSettingByFuseWordId(customFuseToRemove = parent.getId())) == null) continue;
                fuseArray.getSettings().remove(advancedFuseSetting);
                removed = true;
            }
            if (removed && parentControl instanceof IDisposable) {
                ((IDisposable)parentControl).dispose();
            }
            if (removed && parentControl.getParent() instanceof ArraySettingControl) {
                ((ArraySettingControl)parentControl.getParent()).refreshArraySize();
            }
        }
    }

    public static void executeUpdateDependentNodesAction(EnumSettingControl enumSettingControl, @Nullable String oldValue, String selection, String action) {
        Matcher updateDependentSettingsMatcher = UPDATE_DEPENDENT_SETTINGS_REGEX.matcher(action);
        EfuseEnumSetting enumSetting = enumSettingControl.getEnumSetting();
        if (updateDependentSettingsMatcher.find() && updateDependentSettingsMatcher.groupCount() == 2) {
            boolean removed;
            AdvancedFuseSetting advancedFuseWord;
            AdvancedFuseSetting fuseToPopulate = null;
            ArraySetting advancedFusesArray = EfuseControllerUtils.getAdvancedFusesArray();
            if (advancedFusesArray != null && (advancedFuseWord = advancedFusesArray.getAdvancedFuseSettingByFuseWordId(selection)) != null && !(removed = advancedFusesArray.removeAdvancedFuseWordsWithCustomId())) {
                advancedFusesArray.removeAdvancedFuseWithFuseWordId(selection);
            }
            if (oldValue == null) {
                if (advancedFusesArray != null) {
                    for (AdvancedFuseSetting advancedFuse : advancedFusesArray.getSettings()) {
                        ABaseUIComponentSetting parent = enumSetting.getParent();
                        if (parent == null || !parent.getId().equals(advancedFuse.getFuseWordId())) continue;
                        fuseToPopulate = advancedFuse;
                        break;
                    }
                }
            } else if (advancedFusesArray != null) {
                fuseToPopulate = advancedFusesArray.getAdvancedFuseSettingByFuseWordId(oldValue);
                IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
                FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)oldValue);
                if (fuseWord != null) {
                    String[] valueExpressionParams;
                    String fieldId;
                    ABaseUIComponentSetting componentSetting;
                    ABaseUIComponentSetting fuseWordUIComponent = EfuseUtils.getComponentSettingByFuseWord((IEfuseMcu)mcu, (String)fuseWord.getXmlSetting().getId());
                    if (fuseWordUIComponent != null) {
                        fuseWordUIComponent.setCurrentValue("0x" + Long.toHexString(0L));
                    }
                    EfuseControllerUtils.resetFuseWordAndComponentsToDefault((FuseWord)fuseWord);
                    StorageEfuseUtils.updateStorageForAdvancedFuseWord((Object)((Object)enumSettingControl), (String)fuseWord.getXmlSetting().getId());
                    String valueExpr = fuseWord.getXmlSetting().getValueExpression();
                    if (!valueExpr.isEmpty() && (componentSetting = EfuseControllerUtils.getUIComponentSettingById((String)(fieldId = (valueExpressionParams = valueExpr.split("\\ "))[0]))) != null) {
                        String componentValueExpr = componentSetting.getValueExpression();
                        EfuseControllerUtils.setUIComponentValue((ABaseUIComponentSetting)componentSetting, (String)("0x" + Long.toHexString(EfuseExpressions.getLongValueFromExpression((String)componentValueExpr))));
                    }
                }
            }
            if (fuseToPopulate != null) {
                fuseToPopulate.setFuseWordId(selection);
                EfuseStructSetting uiStructSetting = fuseToPopulate.getUiComponent();
                String dependentNodesIdentifiers = updateDependentSettingsMatcher.group(2);
                IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
                if (dependentNodesIdentifiers != null) {
                    String[] dependentNodes = dependentNodesIdentifiers.split("\\,");
                    FuseWord selectedFuseWord = EfuseUtils.getFuseWordByID((List)selectedMcu.getAllFuseWords(), (String)selection);
                    if (dependentNodes.length == 2 && selectedFuseWord != null) {
                        EfuseIntegerSetting address = uiStructSetting.getIntegerSettingById(dependentNodes[0]);
                        EfuseIntegerSetting value = uiStructSetting.getIntegerSettingById(dependentNodes[1]);
                        if (address != null && value != null) {
                            long longAddress = EfuseControllerUtils.getDefaultFuseWordAddress((FuseWord)selectedFuseWord);
                            long longValue = selectedFuseWord.getValueToWrite();
                            address.setCurrentValue("0x" + Long.toHexString(longAddress));
                            value.setCurrentValue("0x" + Long.toHexString(longValue));
                        }
                    }
                }
            }
        }
    }

    public static void executeSyncAction(String action, String value) {
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        Matcher syncMatcher = SYNC_REGEX.matcher(action);
        if (syncMatcher.find() && syncMatcher.groupCount() == 2) {
            String settingIdToSync = syncMatcher.group(2);
            for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
                ABaseUIComponentSetting setting = efuseEntity.getUIComponentSetting();
                if (!setting.getId().equals(settingIdToSync) || !(setting instanceof EfuseBoolSetting)) continue;
                EfuseControllerUtils.setUIComponentValue((ABaseUIComponentSetting)setting, (String)(value.equals("true") ? "0x" + Long.toHexString(1L) : "0x" + Long.toHexString(0L)));
            }
        }
    }
}

