/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.gui;

import com.nxp.swtools.common.uct.validation.AUctProblem;
import com.nxp.swtools.common.uct.validation.AValidatedTextField;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.efuse.controls.IntegerSettingControl;
import com.nxp.swtools.efuse.gui.EfuseUIProblem;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import javafx.application.Platform;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class EfuseValidatedTextField
extends AValidatedTextField {
    private IntegerSettingControl parentControl;

    public EfuseValidatedTextField(IntegerSettingControl parentControl) {
        super("com.nxp.swtools.efuse.controller");
        this.parentControl = parentControl;
    }

    public void setTextFieldErrorStyle() {
        super.getStyleClass().add((Object)"errorField");
    }

    public void setTextFieldWarningStyle() {
        super.getStyleClass().add((Object)"warningField");
    }

    public String getValidationStatusMessage() {
        return UtilsText.safeString((String)this.validationStatus.getMessage());
    }

    public @Nullable String getInvalidFieldValue() {
        return (String)this.textProperty().get();
    }

    public IntegerSettingControl getParentControl() {
        return this.parentControl;
    }

    public void handleShowProblem(AUctProblem problem) {
        TabPane rootTabPane = EfuseUIProblem.findRootTabPane(this);
        if (rootTabPane != null) {
            EfuseUtils.Mode problemSourceTab = EfuseUIProblem.getProblemSourceTab(this);
            String currentSelectedTab = ((Tab)rootTabPane.getSelectionModel().getSelectedItem()).getId();
            if (problemSourceTab.getTabId().equals(currentSelectedTab)) {
                PerspectivesHelper.showView((String)"com.nxp.swtools.efuse.gui.EfuseView");
                Platform.runLater(() -> ((EfuseValidatedTextField)this).requestFocus());
            } else {
                Tab tabToSwitchTo = EfuseGuiUtils.getTabWithId(rootTabPane, problemSourceTab.getTabId());
                if (tabToSwitchTo != null) {
                    Platform.runLater(() -> {
                        PerspectivesHelper.showView((String)"com.nxp.swtools.efuse.gui.EfuseView");
                        rootTabPane.getSelectionModel().select((Object)tabToSwitchTo);
                        this.requestFocus();
                    });
                }
            }
        }
    }
}

