/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controls.ArraySettingControl;
import com.nxp.swtools.efuse.controls.BitsSettingControl;
import com.nxp.swtools.efuse.controls.BoolSettingControl;
import com.nxp.swtools.efuse.controls.ButtonSettingControl;
import com.nxp.swtools.efuse.controls.EnumSettingControl;
import com.nxp.swtools.efuse.controls.IntegerSettingControl;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.ComponentTypes;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBitsSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseButtonSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseEnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseStructSetting;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import org.eclipse.ui.services.IDisposable;

public class GridPaneStructNode
extends GridPane
implements IBaseControl,
IDisposable {
    private EfuseStructSetting structSetting;

    public GridPaneStructNode(EfuseStructSetting structSetting) {
        this.structSetting = structSetting;
        this.create();
    }

    public void create() {
        this.setHgap(20.0);
        this.setVgap(10.0);
        this.setMinWidth(500.0);
        ColumnConstraints cc = new ColumnConstraints();
        cc.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints();
        rc.setVgrow(Priority.ALWAYS);
        this.getRowConstraints().add((Object)rc);
        for (EfuseStructSetting childStructSetting : this.structSetting.getStructSettings()) {
            if (childStructSetting.getTypeComponentId().isEmpty()) {
                StructSettingNode childStructSettingNode = new StructSettingNode(childStructSetting);
                this.add((Node)childStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow());
                GridPane.setFillWidth((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
                GridPane.setValignment((Node)childStructSettingNode.getRegion(), (VPos)VPos.TOP);
                continue;
            }
            ComponentTypes componentTypes = EfuseControllerUtils.getComponentTypes();
            ABaseUIComponentSetting structSettingComponentType = componentTypes.getComponentTypeById(childStructSetting.getTypeComponentId());
            if (!(structSettingComponentType instanceof EfuseStructSetting)) continue;
            StructSettingNode newStructSettingNode = new StructSettingNode((EfuseStructSetting)structSettingComponentType);
            this.add((Node)newStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow());
            GridPane.setFillWidth((Node)newStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
        }
        for (EfuseBoolSetting boolSetting : this.structSetting.getBoolSettings()) {
            BoolSettingControl boolSettingControl = new BoolSettingControl(boolSetting, (Parent)this);
            this.add((Node)boolSettingControl, boolSetting.getColumn(), boolSetting.getRow());
        }
        for (EfuseEnumSetting enumSetting : this.structSetting.getEnumSettings()) {
            EnumSettingControl enumSettingControl = new EnumSettingControl(enumSetting, (Parent)this);
            this.add((Node)enumSettingControl, enumSetting.getColumn(), enumSetting.getRow());
        }
        for (EfuseIntegerSetting integerSetting : this.structSetting.getIntegerSettings()) {
            IntegerSettingControl integerSettingControl = new IntegerSettingControl(integerSetting, (Parent)this);
            this.add((Node)integerSettingControl, integerSetting.getColumn(), integerSetting.getRow());
        }
        for (EfuseBitsSetting bitsSetting : this.structSetting.getBitsSettings()) {
            BitsSettingControl bitsSettingControl = new BitsSettingControl(bitsSetting, (Parent)this);
            this.add((Node)bitsSettingControl, bitsSetting.getColumn(), bitsSetting.getRow());
        }
        for (EfuseButtonSetting buttonSetting : this.structSetting.getButtonSettings()) {
            ButtonSettingControl buttonSettingControl = new ButtonSettingControl(buttonSetting, (Parent)this);
            this.add((Node)buttonSettingControl, buttonSetting.getColumn(), buttonSetting.getRow());
        }
        for (ArraySetting arraySetting : this.structSetting.getArraySettings()) {
            ArraySettingControl arraySettingControl = new ArraySettingControl(arraySetting, (Parent)this);
            this.add((Node)arraySettingControl, arraySetting.getColumn(), arraySetting.getRow());
        }
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        EfuseSceneCreator.getNodes().add((Node)this);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node child : this.getChildren()) {
            if (!(child instanceof IBaseControl)) continue;
            ((IBaseControl)child).refresh();
        }
    }

    public void dispose() {
        for (Node child : this.getChildren()) {
            if (!(child instanceof IDisposable)) continue;
            ((IDisposable)child).dispose();
        }
        EfuseSceneCreator.getNodes().remove((Object)this);
        this.getChildren().clear();
    }
}

