/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseCustomComponentSetting;
import com.nxp.swtools.bootimage.settings.ConstraintsRefs;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.ExpressionComponents;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.settings.ValueLockedSetting;
import com.nxp.swtools.bootimage.utils.BootUtils;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="integer", strict=false)
public class IntegerSetting
extends ABaseCustomComponentSetting
implements IProblemSource {
    @Element(name="constraints_refs", required=false)
    @Nullable
    private @Element(name="constraints_refs", required=false) @Nullable ConstraintsRefs constraintsRefs;
    @Element(name="locked", required=false)
    @Nullable
    private @Element(name="locked", required=false) @Nullable ValueLockedSetting locked;
    @Attribute(name="read_only", required=false)
    @Nullable
    private @Attribute(name="read_only", required=false) @Nullable Boolean readOnly;
    @Attribute(name="zero_value_allowed", required=false)
    @Nullable
    private @Attribute(name="zero_value_allowed", required=false) @Nullable Boolean zeroValueAllowed;
    @Attribute(name="input_file_ref", required=false)
    @Nullable
    private @Attribute(name="input_file_ref", required=false) @Nullable String inputFileRef;
    @Attribute(name="input_file_offset", required=false)
    @Nullable
    private @Attribute(name="input_file_offset", required=false) @Nullable String inputFileOffset;
    @Attribute(name="input_file_size", required=false)
    @Nullable
    private @Attribute(name="input_file_size", required=false) @Nullable String inputFileSize;
    private Boolean addrHexFormat = Boolean.TRUE;
    private static final Logger LOGGER = LogManager.getLogger(IntegerSetting.class);

    public IntegerSetting(String id, String label, @Nullable Description description, String offset, String size, String initValue, @Nullable ConstraintsRefs constraintsRefs, String options, @Nullable ValueLockedSetting locked, String valueExpression, @Nullable MessagesSetting messages, @Nullable Boolean readOnly, @Nullable Boolean zeroValueAllowed, @Nullable String inputFileRef, @Nullable String inputFileOffset, @Nullable String inputFileSize) {
        super(id, label, description, offset, size, initValue, -1L, options, messages, null, valueExpression);
        this.constraintsRefs = constraintsRefs;
        this.locked = locked;
        this.readOnly = readOnly;
        this.zeroValueAllowed = zeroValueAllowed;
        this.addrHexFormat = Boolean.TRUE;
        this.inputFileOffset = inputFileOffset;
        this.inputFileRef = inputFileRef;
        this.inputFileSize = inputFileSize;
    }

    public IntegerSetting() {
        this.constraintsRefs = null;
        this.locked = null;
        this.readOnly = null;
        this.zeroValueAllowed = null;
        this.addrHexFormat = Boolean.TRUE;
    }

    public Boolean getAddrHexFormat() {
        return this.addrHexFormat;
    }

    public void setAddrHexFormat(Boolean addrHexFormat) {
        this.addrHexFormat = addrHexFormat;
    }

    public String getValueToWriteFormatted() {
        if (Boolean.TRUE.equals(this.addrHexFormat)) {
            return "0x" + Long.toHexString(this.getValueToWrite());
        }
        return Long.toString(this.getValueToWrite());
    }

    public @Nullable ConstraintsRefs getConstraintsRefs() {
        return this.constraintsRefs;
    }

    public List<ConstraintsRefs.AlignToValueRef> getAlignToValueRefs() {
        return this.constraintsRefs != null ? this.constraintsRefs.getAlignToValueRefList() : new ArrayList();
    }

    public List<ConstraintsRefs.LimitValuesRef> getLimitValuesRefs() {
        return this.constraintsRefs != null ? this.constraintsRefs.getLimitValuesRefList() : new ArrayList();
    }

    public List<ConstraintsRefs.ReservedValuesRef> getReservedValuesRefs() {
        return this.constraintsRefs != null ? this.constraintsRefs.getReservedValuesRefList() : new ArrayList();
    }

    public @Nullable Boolean getReadOnlyAttribute() {
        return this.readOnly;
    }

    public @Nullable Boolean getZeroValueAllowedAttribute() {
        return this.zeroValueAllowed;
    }

    public @Nullable ValueLockedSetting getLockedSetting() {
        return this.locked;
    }

    public boolean isValueLocked() {
        if (this.locked != null) {
            return this.locked.getInitialState();
        }
        return false;
    }

    public boolean hasValueExpression() {
        return !this.getValueExpression().equals("");
    }

    public long getValueExpressionResult(ExpressionComponents valueExpressionComponents) {
        return BootUtils.resolveComponentExpression(valueExpressionComponents, this.getValueExpression());
    }

    public @Nullable String getInputFileOffset() {
        return this.inputFileOffset;
    }

    public @Nullable String getInputFileSize() {
        return this.inputFileSize;
    }

    public int getInputSizeValueInBytes() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.inputFileSize);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                sizeVal = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.SEVERE, "Error parsing  ", err);
            }
        }
        return sizeVal;
    }

    public @Nullable String getInputFileRef() {
        return this.inputFileRef;
    }
}

