/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Root;

@Root(name="align_to_value", strict=false)
public class AlignToValueSetting
extends ABaseComponentSetting {
    private static final Logger LOGGER = LogManager.getLogger(AlignToValueSetting.class);

    public AlignToValueSetting(String id, String label, @Nullable Description description, String value, String options, @Nullable MessagesSetting messages) {
        super(id, label, description, value, options, messages, -1L, "");
    }

    public AlignToValueSetting() {
    }

    public int getValueInBytes() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.getInitValue());
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                sizeVal = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
            }
        }
        return sizeVal;
    }

    public int getValueInBits() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(this.getInitValue());
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                sizeVal = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
            }
        }
        return sizeVal;
    }
}

