/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.ABaseCustomComponentSetting;
import com.nxp.swtools.bootimage.settings.ConditionalValuesSetting;
import com.nxp.swtools.bootimage.settings.CustomComponents;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.InputSetting;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.settings.StructSetting;
import com.nxp.swtools.bootimage.utils.BootUtils;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public abstract class AValueTypeComponent
extends ABaseComponentSetting {
    @Attribute(name="value_type", required=false)
    private ValueType valueType;
    @Attribute(name="component_attribute", required=false)
    private ComponentAttribute componentAttribute;
    @Element(name="conditional_values", required=false)
    @Nullable
    private @Element(name="conditional_values", required=false) @Nullable ConditionalValuesSetting conditionalValuesSetting;
    @Nullable
    private CustomComponents parentStructComponents;

    public AValueTypeComponent(String id, String label, Description description, String initValue, String options, String valueType, String componentAttribute, @Nullable MessagesSetting messages) {
        super(id, label, description, initValue, options, messages, -1L, "");
        this.valueType = ValueType.valueOf(valueType);
        this.componentAttribute = ComponentAttribute.valueOf(componentAttribute);
    }

    public AValueTypeComponent() {
        this.valueType = ValueType.NONE;
        this.componentAttribute = ComponentAttribute.NONE;
        this.parentStructComponents = null;
        this.conditionalValuesSetting = null;
    }

    public @Nullable CustomComponents getParentStructComponents() {
        return this.parentStructComponents;
    }

    public @Nullable ConditionalValuesSetting getConditionalValuesSetting() {
        return this.conditionalValuesSetting;
    }

    public void setParentStructComponents(CustomComponents parentStructComponents) {
        this.parentStructComponents = parentStructComponents;
    }

    public long getValue() {
        long value = -1L;
        CustomComponents pointerModuleComponents = this.getParentStructComponents();
        block0 : switch (this.valueType) {
            case STATIC: {
                if (NumberFormatValidator.isValidXmlHexFormat((String)this.getInitValue())) {
                    value = NumberFormatValidator.getDecimalLongFromXmlHex((String)this.getInitValue());
                    break;
                }
                if (!NumberFormatValidator.isValidDecimal((String)this.getInitValue())) break;
                value = NumberFormatValidator.getLongFromStringDecimal((String)this.getInitValue());
                break;
            }
            case ID: {
                if (pointerModuleComponents == null) break;
                List<@NonNull StructSetting> structSettingsList = pointerModuleComponents.getStructSettingsList();
                for (StructSetting structSetting : structSettingsList) {
                    ABaseCustomComponentSetting referencedComponentSetting = BootUtils.getCustomComponentSettingById(structSetting, this.getInitValue());
                    if (referencedComponentSetting != null) {
                        value = this.getValueBasedOnComponentAttribute(referencedComponentSetting);
                        break block0;
                    }
                    InputSetting referencedInputSetting = BootUtils.getInputSettingById(structSetting, this.getInitValue());
                    if (referencedInputSetting == null || !this.componentAttribute.equals((Object)ComponentAttribute.OFFSET)) continue;
                    value = referencedInputSetting.getOffsetValue();
                    break block0;
                }
                break;
            }
            case CONDITIONAL: {
                ConditionalValuesSetting localConditionalValuesSetting = this.conditionalValuesSetting;
                if (localConditionalValuesSetting == null) break;
                switch (localConditionalValuesSetting.getValueCondition()) {
                    case MAX: {
                        ArrayList<Long> conditionalValues = new ArrayList<Long>();
                        for (AValueTypeComponent aValueTypeComponent : localConditionalValuesSetting.getConditionalValuesList()) {
                            if (aValueTypeComponent.getValue() == -1L) continue;
                            conditionalValues.add(new Long(aValueTypeComponent.getValue()));
                        }
                        if (conditionalValues.isEmpty()) break block0;
                        Collections.sort(conditionalValues);
                        value = (Long)conditionalValues.get(conditionalValues.size() - 1);
                        break block0;
                    }
                }
                break;
            }
        }
        return value;
    }

    private long getValueBasedOnComponentAttribute(ABaseCustomComponentSetting componentSetting) {
        long value = -1L;
        switch (this.componentAttribute) {
            case VALUE: {
                value = componentSetting.getValueToWrite();
                break;
            }
            case OFFSET: {
                value = componentSetting.getOffsetValue();
                break;
            }
            case SIZE: {
                value = componentSetting.getSizeValueInBytes();
                break;
            }
        }
        return value;
    }

    public static enum ComponentAttribute {
        VALUE,
        OFFSET,
        SIZE,
        NONE;

    }

    public static enum ValueType {
        STATIC,
        ID,
        CONDITIONAL,
        NONE;

    }
}

