/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resource.internal.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.RefactoringParticipant;
import com.nxp.s32ds.ext.ide.core.refactoring.RenameUtils;
import com.nxp.s32ds.ext.ide.core.searchengine.TextChangeFinder;
import com.nxp.s32ds.ext.ide.resource.internal.refactoring.ResourceRefactoringActivator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GdbResourcesRefactoringParticipant
implements RefactoringParticipant {
    private static final String[] GDB_FILES = new String[]{"*.gdbinit"};

    public IStatus apply(IProject target, IProject source, String search, String replace, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return GdbResourcesRefactoringParticipant.renameFiles((IResource)target, GDB_FILES, search, replace, monitor);
    }

    private static IStatus renameFiles(IResource projects, String[] filesExt, String search, String replace, IProgressMonitor monitor) {
        MultiStatus mtStatus = ResourceRefactoringActivator.getInstance().createMultiStatus();
        try {
            List fileForRenameNotMatcher = TextChangeFinder.findResourceOutofMatching((IResource)projects, (String[])filesExt, (String)search, (String)replace, (IProgressMonitor)monitor);
            for (IFile file : fileForRenameNotMatcher) {
                mtStatus.add(RenameUtils.renameFile((IFile)file, (String)search, (String)replace, (IProgressMonitor)monitor));
            }
        }
        catch (CoreException e) {
            mtStatus.add(e.getStatus());
        }
        return mtStatus;
    }
}

