/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.provider;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.view.provider.IPeripheralsProblemResolveHandler;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.text.MessageFormat;
import java.util.List;

public final class PeripheralEnableResolveHandler
implements IPeripheralsProblemResolveHandler {
    @NonNull
    public static final PeripheralEnableResolveHandler INSTANCE = new PeripheralEnableResolveHandler();
    @NonNull
    protected final IControllerWrapper controllerWrapper = PeriphControllerWrapper.getInstance();

    private PeripheralEnableResolveHandler() {
    }

    public @NonNull List<@NonNull IComponentInstanceConfig> getConfigInstancesOfProblem(@NonNull IValidationProblem problem) {
        String peripheralInstance = problem.getDependency().getResourceId();
        return this.controllerWrapper.getController().getComponentInstanceConfigs(problem.getConfiguration().getConfigurationName(), peripheralInstance);
    }

    @Override
    public boolean canHandle(@NonNull IBaseProblem problem) {
        IValidationProblem validationProblem;
        if (problem instanceof IValidationProblem && "Peripheral".equals((validationProblem = (IValidationProblem)problem).getDependency().getResourceType())) {
            boolean areInstancesOnPeripheral;
            boolean isInit = "initialized".equals(validationProblem.getFeature().getName());
            boolean bl = areInstancesOnPeripheral = !this.getConfigInstancesOfProblem(validationProblem).isEmpty();
            return isInit && areInstancesOnPeripheral;
        }
        return false;
    }

    public boolean resolveProblem(@NonNull IBaseProblem problem) {
        if (problem instanceof IValidationProblem) {
            IValidationProblem validationProblem = (IValidationProblem)problem;
            this.controllerWrapper.getController().setComponentInstancesEnabled(this.getConfigInstancesOfProblem(validationProblem), true, this.getClass());
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull String getResolveProblemLabel(@NonNull IBaseProblem problem) {
        if (problem instanceof IValidationProblem) {
            IValidationProblem validationProblem = (IValidationProblem)problem;
            @NonNull List instanceNames = (List)this.getConfigInstancesOfProblem(validationProblem).stream().map(x -> x.getName()).collect(CollectorsUtils.toList());
            return MessageFormat.format(Messages.get().PeripheralEnableResolveHandler_Enable, instanceNames);
        }
        return "";
    }
}

