/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlGroup;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenu;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenuContext;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ArrayControlMasterDetail
extends AArrayControlGroup {
    @Nullable
    static final Image IMAGE_CROSS = ToolsImages.getImage((String)"icons/remove_cross_circle.png");
    private static final int MIN_ITEMS_IN_TABLE = 5;
    private static final int MAX_ITEMS_IN_TABLE = 24;
    private static final int MIN_CHARS_IN_TABLE = 8;
    @Nullable
    private Composite detailComposite;
    @Nullable
    private Composite uiComposite;
    @Nullable
    TableViewer masterViewer;
    @Nullable
    private IChildControl displayedControl;

    protected ArrayControlMasterDetail(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(arrayConfig, controlOptions, controllerWrapper);
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        Composite contentComposite = this.createComposite(composite, 1);
        contentComposite.setLayoutData((Object)new GridDataComponents(4, 4, true, false, 3, 1));
        this.createLabelWithControls(contentComposite);
        Composite uiCompositeLoc = new Composite(contentComposite, 0);
        uiCompositeLoc.setLayoutData((Object)new GridDataComponents(4, 4, true, false, 3, 1));
        this.uiComposite = uiCompositeLoc;
        GridLayoutComponents layout = new GridLayoutComponents(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        uiCompositeLoc.setLayout((Layout)layout);
        this.createMasterPart(uiCompositeLoc);
        Label separator = new Label(uiCompositeLoc, 514);
        separator.setLayoutData((Object)new GridDataComponents(0x1000000, 4, false, false));
        this.createDetailPart(uiCompositeLoc);
        this.createInfoLabel(contentComposite, 3);
        this.restoreSelectionFromStorage();
        return contentComposite;
    }

    private void createDetailPart(@NonNull Composite composite) {
        Composite detailPart;
        this.detailComposite = detailPart = new Composite(composite, 0);
        detailPart.setLayoutData((Object)new GridDataComponents(4, 4, true, true));
        GridLayoutComponents detailPartLayout = new GridLayoutComponents(3, false);
        detailPartLayout.marginLeft = 3;
        detailPartLayout.horizontalSpacing = 8;
        detailPart.setLayout((Layout)detailPartLayout);
    }

    private @NonNull Composite createMasterPart(@NonNull Composite composite) {
        Composite masterPart = new Composite(composite, 0);
        masterPart.setLayoutData((Object)new GridDataComponents(4, 4, false, true));
        GridLayoutComponents layout = new GridLayoutComponents(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        masterPart.setLayout((Layout)layout);
        Table masterContentTable = new Table(masterPart, 68372);
        TableLayout tableLayout = new TableLayout();
        masterContentTable.setLayout((Layout)tableLayout);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)masterContentTable, "periphsMasterTable_" + this.arrayConfig.getId());
        masterContentTable.setLayoutData((Object)new GridDataComponents(4, 4, false, false));
        masterContentTable.setLinesVisible(true);
        TableViewer masterContent = new TableViewer(masterContentTable);
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)masterContent);
        this.masterViewer = masterContent;
        this.createChildColumn(masterContent);
        if (this.isUiArrayReorderSpecified() || !this.isUiArrayFixedSpecified()) {
            this.registerControl(new ArrayControlItemMenuContext(this, masterContent));
        }
        masterContent.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setViewerInput(masterContent);
        this.updateColumnWidth(masterContent);
        masterContent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && ((selectedElement = ((StructuredSelection)selection).getFirstElement()) instanceof IChildControl || selectedElement == null)) {
                    IChildControl newSelection = (IChildControl)selectedElement;
                    ArrayControlMasterDetail.this.setSelectedChild(newSelection);
                    ArrayControlMasterDetail.this.updateDetailContent();
                    ArrayControlMasterDetail.this.updateLabelWithControls(ArrayControlMasterDetail.this.getControlUpdateType());
                }
            }
        });
        this.addKeyboardListener(masterContentTable);
        ArrayControlMasterDetail.addScrollListener((Control)masterContentTable, masterPart);
        return masterPart;
    }

    @Override
    public void selectLastItem() {
        IChildControl childToSelect = null;
        if (!this.children.isEmpty()) {
            childToSelect = (IChildControl)this.children.get(this.children.size() - 1);
        }
        this.selectItem(childToSelect);
    }

    private void setViewerInput(@NonNull TableViewer viewer) {
        viewer.setInput(new ArrayList(this.children));
        int tableSize = Math.max(Math.min(viewer.getTable().getItemCount(), 24), 5);
        ((GridDataComponents)Objects.requireNonNull(viewer.getTable().getLayoutData())).heightHint = viewer.getTable().getItemHeight() * tableSize;
        Objects.requireNonNull(viewer.getTable().getParent()).requestLayout();
    }

    private void createChildColumn(@NonNull TableViewer tableViewer) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IChildControl) {
                    return ArrayControlMasterDetail.getStatusIcon(((IChildControl)element).getChild());
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IChildControl) {
                    ISettingConfig config = (ISettingConfig)((IChildControl)element).getChild();
                    String key = ArrayControlMasterDetail.this.arrayConfig.getSettingKey(config, ArrayControlMasterDetail.this.arrayConfig.getExpressionContext());
                    return key != null ? key : config.getUiName();
                }
                return null;
            }

            public Color getForeground(Object element) {
                if (element instanceof ISettingConfig && !((ISettingConfig)element).isEnabled()) {
                    return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_FG");
                }
                return super.getForeground(element);
            }

            public String getToolTipText(Object element) {
                if (element instanceof IChildControl) {
                    ISettingConfig config = (ISettingConfig)((IChildControl)element).getChild();
                    return ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)config));
                }
                return null;
            }
        });
    }

    @Override
    protected void updateSelectionOfExpandGroupContent() {
        this.expandGroupContent = this.children.isEmpty() ? null : this.uiComposite;
    }

    @Override
    public void updateMainContent(@NonNull Control contentControl, @NonNull IChildControl.UpdateType updateType) {
        TableViewer masterViewerLoc = this.masterViewer;
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            Iterator childrenIterator = this.children.iterator();
            Iterator arrayItemIterator = this.arrayConfig.getChildren().iterator();
            ISettingConfig arrayItem = arrayItemIterator.hasNext() ? (ISettingConfig)arrayItemIterator.next() : null;
            boolean itemRemoved = false;
            while (childrenIterator.hasNext()) {
                IChildControl childControl = (IChildControl)childrenIterator.next();
                this.updateControlOptions(childControl);
                if (!childControl.getChild().equals(arrayItem)) {
                    childrenIterator.remove();
                    childControl.dispose();
                    itemRemoved = true;
                    continue;
                }
                ISettingConfig iSettingConfig = arrayItem = arrayItemIterator.hasNext() ? (ISettingConfig)arrayItemIterator.next() : null;
            }
            Composite uiCompositeLoc = this.uiComposite;
            while (arrayItem != null) {
                this.addItem(arrayItem, updateType);
                ISettingConfig iSettingConfig = arrayItem = arrayItemIterator.hasNext() ? (ISettingConfig)arrayItemIterator.next() : null;
            }
            if (uiCompositeLoc != null) {
                boolean isChanged;
                Point size = uiCompositeLoc.getSize();
                boolean bl = isChanged = !size.equals((Object)new Point(0, 0));
                if (KEPreferences.isAnimationsEnabled() && isChanged && (updateType == IChildControl.UpdateType.NORMAL || updateType == IChildControl.UpdateType.NORMAL_CONFIGSET) && (this.children.isEmpty() || this.children.size() == 1 && !uiCompositeLoc.isVisible())) {
                    this.setControlVisibleAnimation((Control)uiCompositeLoc, null, !this.children.isEmpty());
                } else {
                    this.setControlVisible((Control)uiCompositeLoc, !this.children.isEmpty());
                }
            }
            IChildControl previouslySelectedChild = this.getChildToSelect();
            this.updateMasterContent();
            if (masterViewerLoc != null) {
                masterViewerLoc.getTable().setEnabled(this.arrayConfig.isEnabled());
            }
            if (updateType != IChildControl.UpdateType.NORMAL_CONFIGSET) {
                this.selectItem(this.getChildToSelect());
            }
            if (itemRemoved) {
                this.selectItem(previouslySelectedChild);
            }
        } else {
            if (masterViewerLoc != null) {
                Object input = masterViewerLoc.getInput();
                if (input instanceof List) {
                    masterViewerLoc.update(((List)input).toArray(), null);
                } else {
                    masterViewerLoc.refresh();
                }
            }
            this.updateDetailContent(IChildControl.UpdateType.PROBLEM_DECORATION);
            this.updateLabelWithControls(IChildControl.UpdateType.PROBLEM_DECORATION);
        }
    }

    void updateColumnWidth(@NonNull TableViewer tableViewer) {
        TableColumn column = tableViewer.getTable().getColumn(0);
        column.pack();
        column.setWidth(Math.max(tableViewer.getTable().computeSize((int)this.getTableWidthHint(), (int)tableViewer.getTable().getSize().y).x, column.getWidth()));
    }

    void updateMasterContent() {
        TableViewer masterViewerLoc = this.masterViewer;
        if (masterViewerLoc != null && !masterViewerLoc.getControl().isDisposed()) {
            this.setViewerInput(masterViewerLoc);
            this.updateColumnWidth(masterViewerLoc);
            Table table = masterViewerLoc.getTable();
            Object data = table.getLayoutData();
            if (this.getControlOptions().isTableRowsVisibleLimitSet() && data instanceof GridDataComponents) {
                GridDataComponents tableLayoutData = (GridDataComponents)data;
                int wantedMaxHeight = table.getItemHeight() * this.getControlOptions().getTableVisibleRows();
                Point size = table.computeSize(-1, -1);
                tableLayoutData.heightHint = Math.min(size.y, wantedMaxHeight);
            }
        }
    }

    @Override
    public void selectItem(@Nullable IChildControl control) {
        TableViewer masterViewerLoc = this.masterViewer;
        if (masterViewerLoc != null && !masterViewerLoc.getControl().isDisposed()) {
            StructuredSelection selection = control == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)control);
            masterViewerLoc.setSelection((ISelection)selection, true);
        }
    }

    void updateDetailContent() {
        this.updateDetailContent(this.getControlUpdateType());
    }

    void updateDetailContent(@NonNull IChildControl.UpdateType updateType) {
        Composite detailCompositeLoc = this.detailComposite;
        if ((detailCompositeLoc == null || detailCompositeLoc.isDisposed()) && this.uiComposite != null) {
            this.createDetailPart(this.uiComposite);
            detailCompositeLoc = this.detailComposite;
        }
        if (detailCompositeLoc != null && !detailCompositeLoc.isDisposed()) {
            detailCompositeLoc.setRedraw(false);
            IChildControl control = this.getSelectedChild();
            IChildControl displayedControlLoc = this.displayedControl;
            if (control == displayedControlLoc && displayedControlLoc != null) {
                if (displayedControlLoc.isDisposed()) {
                    displayedControlLoc.create(detailCompositeLoc, 3);
                }
                displayedControlLoc.update(updateType);
            } else {
                if (this.displayedControl != null) {
                    this.displayedControl.dispose();
                    this.displayedControl = null;
                }
                if (control != null) {
                    this.updateControlOptions(control);
                    control.create(detailCompositeLoc, 3);
                    control.update(updateType);
                    this.displayedControl = control;
                }
            }
            detailCompositeLoc.requestLayout();
            ScrolledCompositeHelper.updateScrollSize((Composite)detailCompositeLoc);
            Composite mainCompositeLoc = (Composite)this.mainControl;
            if (mainCompositeLoc != null && !mainCompositeLoc.isDisposed()) {
                mainCompositeLoc.requestLayout();
                mainCompositeLoc.redraw();
            }
            detailCompositeLoc.setRedraw(true);
        }
    }

    private boolean addItem(@NonNull ISettingConfig arrayItem, @NonNull IChildControl.UpdateType updateType) {
        IChildControl childControl = ChildControlFactory.create((IChild)arrayItem, null, this.controllerWrapper);
        if (childControl != null) {
            this.updateControlOptions(childControl);
            this.children.add(childControl);
            childControl.update(updateType);
            return true;
        }
        return false;
    }

    protected void updateControlOptions(IChildControl childControl) {
        ControlOptions childControlOptions = childControl.getControlOptions();
        childControlOptions.labelHidden(true);
        if (childControl.getChild() instanceof IChildProvidable) {
            childControlOptions.borderHidden(true);
        }
    }

    @Override
    public void setAllSettingsTo(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
    }

    private int getTableWidthHint() {
        double length = 8.0;
        List<@NonNull Double> columnWidths = this.getControlOptions().getTableColumnWidths();
        if (columnWidths != null && !columnWidths.isEmpty()) {
            length = columnWidths.get(0);
        }
        return (int)(length * (double)this.computeColumnWidthUnitSize(Objects.requireNonNull(this.uiComposite)));
    }

    @Override
    public @Nullable ISettingConfig getSelection() {
        TableViewer masterViewerLoc = this.masterViewer;
        if (masterViewerLoc != null) {
            ISelection selection = masterViewerLoc.getSelection();
            return super.getChildFromSelection(selection);
        }
        return null;
    }
}

