/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.PeripheralsToolTippableFormatter;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenu;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableDescriptionAppendDecorator;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public abstract class AArrayControlInternal
extends ChildProvidableControlBase {
    private static final int LABEL_CONTROL_COLUMNS_COUNT = 3;
    private static final int TITLEBAR_SPACE_AROUND = 0;
    private static final int TITLEBAR_OFFSET = 10;
    private static final int TITLEBAR_NUMBER_OF_BUTTONS = 4;
    @Nullable
    private Button buttonAdd;
    @Nullable
    private Button buttonRemove;
    @Nullable
    private Button buttonUp;
    @Nullable
    private Button buttonDown;
    @NonNull
    protected final ArrayConfig arrayConfig;
    @Nullable
    private Control label;
    @Nullable
    private Label infoLabel;
    private ArrayControl parentArrayControl;
    protected InstantSearchList representationCombo;
    protected Composite representationComposite;

    protected AArrayControlInternal(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super((IChildProvidable)arrayConfig, controlOptions, controllerWrapper);
        this.arrayConfig = arrayConfig;
    }

    public @NonNull IControllerWrapper getControllerWrapper() {
        return this.controllerWrapper;
    }

    @Override
    public void create(@NonNull Composite composite, int colSpan) {
        Control mainControlLoc;
        super.create(composite, colSpan);
        Control labelControlLoc = this.labelControl;
        if (labelControlLoc != null) {
            labelControlLoc.setLayoutData((Object)new GridDataComponents(4, 128, true, false, this.currentColSpan, 1));
        }
        if ((mainControlLoc = this.mainControl) != null) {
            mainControlLoc.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, this.currentColSpan, 1));
        }
    }

    protected void createInfoLabel(@NonNull Composite composite, int colSpan) {
        Label infoLabelLoc = new Label(composite, 0);
        infoLabelLoc.setText(Messages.get().AArrayControlInternal_AddItemInfoLabel);
        GridDataComponents layoutData = new GridDataComponents(16384, 128, true, false, colSpan, 1);
        layoutData.exclude = true;
        infoLabelLoc.setVisible(false);
        infoLabelLoc.setLayoutData((Object)layoutData);
        this.infoLabel = infoLabelLoc;
    }

    protected void setInfoLabelVisible(boolean visible) {
        Label infoLabelLoc = this.infoLabel;
        if (infoLabelLoc != null && !infoLabelLoc.isDisposed()) {
            this.setControlVisible((Control)infoLabelLoc, visible);
        }
    }

    @Override
    public abstract @Nullable Control createMainControl(@NonNull Composite var1);

    public @Nullable ISettingConfig getSelection() {
        return null;
    }

    public ISettingConfig getChildFromSelection(ISelection selection) {
        IChildControl childControl;
        IChild childControlChild;
        StructuredSelection structuredSelection;
        Object firstElement;
        if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof IChildControl && (childControlChild = (childControl = (IChildControl)firstElement).getChild()) instanceof ISettingConfig) {
            return (ISettingConfig)childControlChild;
        }
        return null;
    }

    public void selectLastItem() {
    }

    public void selectItem(IChildControl control) {
    }

    @Override
    public abstract void updateMainContent(@NonNull Control var1, @NonNull IChildControl.UpdateType var2);

    @Override
    public void update(@NonNull IChildControl.UpdateType updateType) {
        if (this.isDisposed()) {
            return;
        }
        super.update(updateType);
        this.updateLabelWithControls(this.getChild().isEnabled() ? updateType : IChildControl.UpdateType.FORCE_DISABLE);
        this.setInfoLabelVisible(updateType != IChildControl.UpdateType.FORCE_DISABLE && this.getChild().isEnabled() && !this.getControlOptions().isArrayFixed() && this.children.isEmpty());
        this.updateRepresentationComposite();
    }

    protected boolean shouldShowIndices() {
        return !this.getControlOptions().isArrayIndicesHidden();
    }

    public @Nullable Control createLabelWithControls(@NonNull Composite composite) {
        boolean showBar;
        boolean bl = showBar = !this.isUiLabelHiddenSpecified() || !this.isUiArrayFixedSpecified() || this.isUiArrayReorderSpecified();
        if (showBar) {
            Composite representationCompositeLoc;
            Composite contentComposite = new Composite(composite, 0);
            contentComposite.setLayoutData((Object)new GridDataComponents(4, 128, true, false));
            GridLayoutComponents contentCompositeLayout = new GridLayoutComponents(3, false);
            contentCompositeLayout.marginHeight = 0;
            contentCompositeLayout.marginWidth = 0;
            contentComposite.setLayout((Layout)contentCompositeLayout);
            if (!this.isUiLabelHiddenSpecified()) {
                Control labelLoc;
                this.label = labelLoc = super.createLabelControl(contentComposite);
                if (labelLoc != null) {
                    labelLoc.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
                    this.createErrorDecoration(labelLoc, 16512);
                    this.registerCopyPasteMenuOnLabel();
                }
            } else {
                --contentCompositeLayout.numColumns;
            }
            Composite buttonsComposite = new Composite(contentComposite, 0);
            buttonsComposite.setLayoutData((Object)new GridDataComponents(16384, 128, false, false));
            GridLayoutComponents buttonsCompositeLayout = new GridLayoutComponents(4, false);
            buttonsCompositeLayout.marginLeft = this.isUiLabelHiddenSpecified() ? 0 : 10;
            buttonsComposite.setLayout((Layout)buttonsCompositeLayout);
            this.createAddButton(buttonsComposite, 1, () -> this.selectLastItem());
            this.createRemoveButton(buttonsComposite, 1, () -> this.getSelection());
            this.createUpButton(buttonsComposite, 1, () -> {
                ISettingConfig selection = this.getSelection();
                if (selection != null) {
                    ProgressUtils.run((IRunnableWithProgress)this.getMoveUpAction(selection));
                }
            });
            this.createDownButton(buttonsComposite, 1, () -> {
                ISettingConfig selection = this.getSelection();
                if (selection != null) {
                    ProgressUtils.run((IRunnableWithProgress)this.getMoveDownAction(selection));
                }
            });
            this.representationComposite = representationCompositeLoc = new Composite(contentComposite, 0);
            representationCompositeLoc.setLayoutData((Object)new GridDataComponents(131072, 0x1000000, true, false));
            GridLayoutComponents layout = new GridLayoutComponents(2, false);
            representationCompositeLoc.setLayout((Layout)layout);
            Label representationLabelLoc = new Label(representationCompositeLoc, 0);
            representationLabelLoc.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
            representationLabelLoc.setText(Messages.get().AArrayControlInternal_RepresentationComboLabel);
            InstantSearchList representationComboLoc = this.createRepresentationSelectionCombo(representationCompositeLoc, 0);
            representationComboLoc.setLayoutData((Object)new GridDataComponents(131072, 0x1000000, false, false));
            this.representationCombo = representationComboLoc;
            this.updateLabelWithControls(IChildControl.UpdateType.NORMAL);
            return contentComposite;
        }
        return null;
    }

    protected @NonNull IRunnableWithProgress getMoveUpAction(@NonNull ISettingConfig selected) {
        return m -> {
            boolean bl = this.controllerWrapper.getController().moveItemFront(this.arrayConfig, selected, (Object)this);
        };
    }

    protected @NonNull IRunnableWithProgress getMoveDownAction(@NonNull ISettingConfig selected) {
        return m -> {
            boolean bl = this.controllerWrapper.getController().moveItemBack(this.arrayConfig, selected, (Object)this);
        };
    }

    public void updateLabelWithControls(@NonNull IChildControl.UpdateType updateType) {
        this.updateButtons(updateType);
        Control labelLoc = this.label;
        if (labelLoc != null && !labelLoc.isDisposed()) {
            this.updateLabelContent(labelLoc, updateType);
            this.setLabelInternalFontStyle(1);
            this.setControlEnabled(labelLoc, updateType != IChildControl.UpdateType.FORCE_DISABLE, true);
            String labelToolTip = PeripheralsToolTippableFormatter.getToolTipText((IToolTipable)new ToolTipableDescriptionAppendDecorator((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)this.getChild()), this.isExpandGroupVisible() ? "" : "<br/>" + UtilsText.htmlI((String)Messages.get().AArrayControlInternal_CollapsedArrayTooltipInfo)));
            this.updateLabelInternalTooltip(labelToolTip);
        }
    }

    private static @NonNull Button createButton(@NonNull Composite contentComposite, int colSpan, @NonNull SelectionListener listener, @NonNull String testId, @Nullable Image icon) {
        Button button = new Button(contentComposite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, testId);
        button.setImage(icon);
        button.setLayoutData((Object)new GridDataComponents(16384, 1024, false, false, colSpan, 1));
        button.addSelectionListener(listener);
        AArrayControlInternal.setStateOfButton(button, false);
        return button;
    }

    protected void createAddButton(@NonNull Composite contentComposite, int colSpan, final @Nullable Runnable afterAdd) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressUtils.run(m -> AArrayControlInternal.this.controllerWrapper.getController().addItem(AArrayControlInternal.this.arrayConfig, (Object)AArrayControlInternal.this));
                if (afterAdd != null) {
                    afterAdd.run();
                }
            }
        };
        String testId = "periphsArrayAddButton_" + this.arrayConfig.getId();
        Image icon = ToolsImages.getImage((String)"icons/plus_simple.png");
        Button button = AArrayControlInternal.createButton(contentComposite, colSpan, (SelectionListener)listener, testId, icon);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, Messages.get().ArrayControlMasterDetail_AddNewItem);
        this.buttonAdd = button;
    }

    protected void createAddButton(@NonNull Composite contentComposite, int colSpan) {
        this.createAddButton(contentComposite, colSpan, null);
    }

    protected void createRemoveButton(@NonNull Composite contentComposite, int colSpan, final @NonNull Supplier<@Nullable ISettingConfig> supplier) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISettingConfig childConfig = (ISettingConfig)supplier.get();
                if (childConfig != null) {
                    AArrayControlInternal.this.removeItem(childConfig);
                }
            }
        };
        String testId = "periphsArrayRemoveButton_" + this.arrayConfig.getId();
        Image icon = ToolsImages.getImage((String)"icons/remove_cross_simple.png");
        Button button = AArrayControlInternal.createButton(contentComposite, colSpan, (SelectionListener)listener, testId, icon);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, Messages.get().ArrayControl_ItemMenu_Remove);
        this.buttonRemove = button;
    }

    void removeItem(@NonNull ISettingConfig childConfig) {
        ProgressUtils.run(m -> this.controllerWrapper.getController().removeItem(this.arrayConfig, childConfig, (Object)this));
    }

    protected void createUpButton(@NonNull Composite contentComposite, int colSpan, final @NonNull Runnable runnable) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                runnable.run();
            }
        };
        String testId = "periphsArrayUpButton_" + this.arrayConfig.getId();
        Image icon = this.getMoveUpIcon();
        Button button = AArrayControlInternal.createButton(contentComposite, colSpan, (SelectionListener)listener, testId, icon);
        if (!this.isUiArrayReorderSpecified()) {
            button.setEnabled(false);
        }
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, this.getMoveUpButtonDescription());
        this.buttonUp = button;
    }

    protected @NonNull String getMoveUpButtonDescription() {
        return Messages.get().ArrayControl_ItemMenu_MoveUp;
    }

    protected @Nullable Image getMoveUpIcon() {
        return ToolsImages.getImage((String)"icons/up.png");
    }

    protected void createDownButton(@NonNull Composite contentComposite, int colSpan, final @NonNull Runnable runnable) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                runnable.run();
            }
        };
        String testId = "periphsArrayDownButton_" + this.arrayConfig.getId();
        Image icon = this.getMoveDownIcon();
        Button button = AArrayControlInternal.createButton(contentComposite, colSpan, (SelectionListener)listener, testId, icon);
        if (!this.isUiArrayReorderSpecified()) {
            button.setEnabled(false);
        }
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, this.getMoveDownDescription());
        this.buttonDown = button;
    }

    protected @NonNull String getMoveDownDescription() {
        return Messages.get().ArrayControl_ItemMenu_MoveDown;
    }

    protected @Nullable Image getMoveDownIcon() {
        return ToolsImages.getImage((String)"icons/down.png");
    }

    protected void destroyAddButton() {
        if (this.buttonAdd != null) {
            this.buttonAdd.dispose();
        }
    }

    protected boolean isUiArrayFixedSpecified() {
        return this.getControlOptions().isArrayFixed() || this.getChild().getModelData().getSizeExpr() != null;
    }

    protected boolean isUiArrayReorderSpecified() {
        return this.getControlOptions().isArrayReorder();
    }

    protected boolean isUiLabelHiddenSpecified() {
        return this.getControlOptions().isLabelHidden();
    }

    protected abstract void updateButtons(@Nullable IChildControl.UpdateType var1);

    protected void updateAddButton(@Nullable IChildControl.UpdateType updateType) {
        boolean allowed = updateType != IChildControl.UpdateType.FORCE_DISABLE && this.getChild().isEnabled();
        Button buttonLoc = this.buttonAdd;
        if (buttonLoc != null && !buttonLoc.isDisposed()) {
            buttonLoc.setEnabled(allowed && this.getChild().canAddItem());
            AArrayControlInternal.setStateOfButton(buttonLoc, !this.isUiArrayFixedSpecified());
        }
    }

    protected static void setStateOfButton(@NonNull Button button, boolean shouldBeVisible) {
        GridDataComponents layoutData = (GridDataComponents)button.getLayoutData();
        if (layoutData != null) {
            layoutData.exclude = false;
            button.setVisible(true);
            if (!shouldBeVisible) {
                layoutData.exclude = true;
                button.setVisible(false);
            }
        }
    }

    protected void updateRemoveButton(@Nullable IChildControl.UpdateType updateType) {
        boolean allowed = updateType != IChildControl.UpdateType.FORCE_DISABLE && this.getChild().isEnabled();
        Button buttonLoc = this.buttonRemove;
        if (buttonLoc != null && !buttonLoc.isDisposed()) {
            buttonLoc.setEnabled(allowed && this.getChild().canRemoveItem());
            AArrayControlInternal.setStateOfButton(buttonLoc, !this.isUiArrayFixedSpecified());
        }
    }

    protected void updateUpButton(@Nullable IChildControl.UpdateType updateType) {
        boolean allowed = updateType != IChildControl.UpdateType.FORCE_DISABLE && this.getChild().isEnabled();
        Button buttonLoc = this.buttonUp;
        if (buttonLoc != null && !buttonLoc.isDisposed()) {
            boolean selectedAny = this.selectedChildIdx > -1;
            boolean selectedFirst = this.selectedChildIdx == 0;
            buttonLoc.setEnabled(allowed && !selectedFirst && selectedAny);
            AArrayControlInternal.setStateOfButton(buttonLoc, this.isUiArrayReorderSpecified());
        }
    }

    protected void updateDownButton(@Nullable IChildControl.UpdateType updateType) {
        boolean allowed = updateType != IChildControl.UpdateType.FORCE_DISABLE && this.getChild().isEnabled();
        Button buttonLoc = this.buttonDown;
        if (buttonLoc != null && !buttonLoc.isDisposed()) {
            boolean selectedAny = this.selectedChildIdx > -1;
            boolean selectedLast = this.selectedChildIdx == this.children.size() - 1;
            buttonLoc.setEnabled(allowed && !selectedLast && selectedAny);
            AArrayControlInternal.setStateOfButton(buttonLoc, this.isUiArrayReorderSpecified());
        }
    }

    protected boolean isControlFirst(@Nullable IChildControl setting) {
        return this.children.isEmpty() ? false : ((IChildControl)this.children.get(0)).equals(setting);
    }

    protected boolean isControlLast(@Nullable IChildControl setting) {
        return this.children.isEmpty() ? false : ((IChildControl)this.children.get(this.children.size() - 1)).equals(setting);
    }

    public void moveItemFront(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
        IChildControl setting = control.getSelectedItemHint();
        assert (setting != null);
        ProgressUtils.run(m -> this.controllerWrapper.getController().moveItemFront(this.arrayConfig, (ISettingConfig)setting.getChild(), (Object)caller));
    }

    public void moveItemBack(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
        IChildControl setting = control.getSelectedItemHint();
        assert (setting != null);
        ProgressUtils.run(m -> this.controllerWrapper.getController().moveItemBack(this.arrayConfig, (ISettingConfig)setting.getChild(), (Object)caller));
    }

    public void moveItemBeginning(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
        IChildControl setting = control.getSelectedItemHint();
        assert (setting != null);
        ProgressUtils.run(m -> this.controllerWrapper.getController().moveItemBeginning(this.arrayConfig, (ISettingConfig)setting.getChild(), (Object)caller));
    }

    public void moveItemEnd(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
        IChildControl setting = control.getSelectedItemHint();
        assert (setting != null);
        ProgressUtils.run(m -> this.controllerWrapper.getController().moveItemEnd(this.arrayConfig, (ISettingConfig)setting.getChild(), (Object)caller));
    }

    public void removeItem(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
        IChildControl setting = control.getSelectedItemHint();
        assert (setting != null);
        ProgressUtils.run(m -> this.controllerWrapper.getController().removeItem(this.arrayConfig, (ISettingConfig)setting.getChild(), (Object)caller));
    }

    public @Nullable ISettingConfig getCurrentItemConfig(@NonNull IArrayControlItemMenuControl menuControl) {
        IChildControl control = menuControl.getSelectedItemHint();
        if (control == null) {
            return null;
        }
        IChild setting = control.getChild();
        if (setting instanceof ISettingConfig) {
            return (ISettingConfig)setting;
        }
        return null;
    }

    @Override
    public @NonNull Composite createComposite(@NonNull Composite parentComposite, int numColumns) {
        GridLayoutComponents layout = new GridLayoutComponents(numColumns, false);
        int style = this.getSwtStyle();
        layout.marginWidth = this.getControlOptions().isBorderHidden() ? 0 : 8;
        layout.horizontalSpacing = 8;
        Composite composite = new Composite(parentComposite, style);
        composite.setLayout((Layout)layout);
        return composite;
    }

    public abstract void setAllSettingsTo(@NonNull ArrayControlItemMenu var1, @NonNull IArrayControlItemMenuControl var2);

    protected void addKeyboardListener(final @NonNull Table table) {
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AArrayControlInternal.this.handleDeleteKey(table.getShell(), e);
            }
        });
    }

    protected void handleDeleteKey(@Nullable Shell shell, @NonNull KeyEvent event) {
        if (event.keyCode == 127) {
            ISettingConfig selection = this.getSelection();
            if (selection == null) {
                return;
            }
            boolean remove = MessageDialog.openQuestion((Shell)shell, (String)Messages.get().AArrayControlInternal_RemoveItemTitle, (String)Messages.get().AArrayControlInternal_RemoveItemConfirmationQuestion);
            if (remove) {
                this.removeItem(selection);
            }
        }
    }

    public @NonNull ArrayConfig getChild() {
        return (ArrayConfig)this.child;
    }

    protected void changeModelValue(@NonNull ScalarConfig config, @NonNull String newVal) {
        Control mainControlLoc = this.mainControl;
        assert (mainControlLoc != null);
        ProgressUtils.run(m -> this.controllerWrapper.getController().setValue(config, newVal, (Object)mainControlLoc));
    }

    protected InstantSearchList createRepresentationSelectionCombo(@NonNull Composite parentComposite, int style) {
        InstantSearchList combo = new InstantSearchList(parentComposite, 0x800 | style);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "periphsArraySwitchRepresentation_" + this.getChild().getId());
        this.representationCombo = combo;
        this.updateRepresentationComposite();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@NonNull SelectionEvent e) {
                ArrayConfig.Representation currentRepresentation = AArrayControlInternal.this.getChild().getRepresentation();
                ArrayConfig.Representation selectedRepresentation = ArrayConfig.Representation.getByLabel((String)UtilsText.safeString((String)e.text));
                if (selectedRepresentation != null && selectedRepresentation != currentRepresentation) {
                    AArrayControlInternal.this.getChild().setRepresentation(selectedRepresentation);
                    AArrayControlInternal.this.recreateGUI();
                }
            }
        });
        return combo;
    }

    protected void updateRepresentationComposite() {
        Composite representationCompositeLoc = this.representationComposite;
        InstantSearchList representationComboLoc = this.representationCombo;
        if (representationCompositeLoc != null && representationComboLoc != null && !representationCompositeLoc.isDisposed() && !representationComboLoc.isDisposed()) {
            List<ArrayConfig.Representation> availableRepresentations = this.getControlOptions().getAvailableRepresentations();
            if (availableRepresentations != null) {
                if (availableRepresentations.size() > 1) {
                    this.setControlVisible((Control)representationCompositeLoc, true);
                    @NonNull String[] labels = new String[availableRepresentations.size()];
                    int i = 0;
                    while (i < availableRepresentations.size()) {
                        labels[i] = availableRepresentations.get(i).getLabel();
                        ++i;
                    }
                    representationComboLoc.setItems(labels);
                } else {
                    this.setControlVisible((Control)representationCompositeLoc, false);
                }
                representationComboLoc.setSelection(this.getChild().getRepresentation().getLabel());
            } else {
                this.setControlVisible((Control)representationCompositeLoc, false);
            }
        }
    }

    protected void recreateGUI() {
        Composite parentLoc = this.parent;
        if (parentLoc != null) {
            @NonNull Control[] parentChildren = parentLoc.getChildren();
            int indexAfterMainControl = -1;
            int i = 0;
            while (i < parentChildren.length) {
                if (parentChildren[i].equals(this.mainControl)) {
                    indexAfterMainControl = i + 1;
                }
                ++i;
            }
            Control controlAfterMainControl = null;
            if (indexAfterMainControl >= 0 && indexAfterMainControl < parentChildren.length) {
                controlAfterMainControl = parentChildren[indexAfterMainControl];
            }
            this.dispose();
            this.parentArrayControl.recreateDelegate(controlAfterMainControl);
        }
    }

    public void moveBefore(Control controlBefore) {
        Control mainControlLoc;
        Control labelControlLoc = this.labelControl;
        if (labelControlLoc != null) {
            labelControlLoc.moveAbove(controlBefore);
        }
        if ((mainControlLoc = this.mainControl) != null) {
            mainControlLoc.moveAbove(controlBefore);
        }
    }

    public void setParentArrayControl(ArrayControl arrayControl) {
        this.parentArrayControl = arrayControl;
    }

    @Override
    protected @NonNull ControlOptions createControlOptionsForChild(@NonNull IChild subChild) {
        ControlOptions overrideOptions = new ControlOptions();
        ArrayConfig.Representation representation = this.getChild().getRepresentation();
        if (this.getControlOptions().isArrayIndicesHidden()) {
            overrideOptions.labelHidden(true);
        }
        if (representation == ArrayConfig.Representation.TABS && subChild instanceof IChildProvidable) {
            overrideOptions.borderHidden(true);
            overrideOptions.labelHidden(true);
        }
        if (representation == ArrayConfig.Representation.HORIZONTAL_TABLE || representation == ArrayConfig.Representation.VERTICAL_TABLE) {
            overrideOptions = overrideOptions.borderHidden(true);
        }
        if (representation == ArrayConfig.Representation.HORIZONTAL_RADIOS || representation == ArrayConfig.Representation.VERTICAL_RADIOS) {
            overrideOptions = overrideOptions.showContentAs(ControlOptions.ShowContentAs.RADIO_GROUP);
        }
        if (representation == ArrayConfig.Representation.MASTER_DETAIL) {
            overrideOptions = overrideOptions.labelHidden(true);
        }
        return overrideOptions;
    }

    @Override
    public void onExpandGroupVisibilityChange() {
        this.updateLabelWithControls(this.getChild().isEnabled() ? IChildControl.UpdateType.NORMAL : IChildControl.UpdateType.FORCE_DISABLE);
    }

    protected boolean areButtonsEnabled() {
        return this.isExpandGroupVisible();
    }

    public boolean isSetAllSettingsToSupported(@NonNull IArrayControlItemMenuControl control) {
        IChild selectedSetting = control.getSelectedSettingHint();
        if (selectedSetting == null) {
            return false;
        }
        String typeName = selectedSetting.getTypeName();
        return !ScalarConfig.Type.INFO.toString().equalsIgnoreCase(typeName) && !ScalarConfig.Type.VARIABLE.toString().equalsIgnoreCase(typeName);
    }
}

