/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.StructControl;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StructMultiColumnControl
extends StructControl {
    private Map<IChildControl, Composite> composites = new HashMap<IChildControl, Composite>();

    public StructMultiColumnControl(@NonNull StructConfig structConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(structConfig, controlOptions, controllerWrapper);
    }

    @Override
    public @Nullable Control createMainControl(@NonNull Composite composite) {
        Integer numOfColumns;
        int columns = 1;
        if (this.getControlOptions().isMultiColumn() && (numOfColumns = this.getControlOptions().getNumOfColumns()) != null) {
            columns = numOfColumns;
        }
        int swtStyle = StructMultiColumnControl.getSwtStyle(this);
        Composite contentComposite = new Composite(composite, swtStyle);
        GridLayoutComponents contentCompositeLayout = new GridLayoutComponents(columns, false);
        if ((swtStyle & 0x800) == 0) {
            contentCompositeLayout.marginHeight = 0;
            contentCompositeLayout.marginWidth = 0;
        }
        contentComposite.setLayout((Layout)contentCompositeLayout);
        for (IChildControl childControl : this.children) {
            Composite c = new Composite(contentComposite, 0);
            this.composites.put(childControl, c);
            GridLayoutComponents layout = new GridLayoutComponents(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)new GridDataComponents(4, 4, true, false));
            childControl.create(c, 3);
        }
        return contentComposite;
    }

    @Override
    protected void updateMainContent(@NonNull Control contentControl, @NonNull IChildControl.UpdateType updateType) {
        super.updateMainContent(contentControl, updateType);
        for (Map.Entry<IChildControl, Composite> entry : this.composites.entrySet()) {
            Composite composite = entry.getValue();
            GridDataComponents layoutData = (GridDataComponents)composite.getLayoutData();
            if (layoutData == null) continue;
            boolean visible = entry.getKey().getChild().isAvailable();
            layoutData.exclude = !visible;
            composite.setVisible(visible);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.composites.clear();
    }
}

