/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableImplementation;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownValueDescriptionDecorator;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class QuickSelectionControl {
    @NonNull
    protected IPresettable presettable;
    @Nullable
    private Composite quickSelectionComposite;
    @Nullable
    private Label label;
    @Nullable
    private InstantSearchList instantSearchList;
    @NonNull
    protected IControllerWrapper controllerWrapper;

    public QuickSelectionControl(@NonNull IPresettable presetable, @NonNull IControllerWrapper controllerWrapper) {
        this.presettable = presetable;
        this.controllerWrapper = controllerWrapper;
    }

    public void create(@NonNull Composite composite, int colSpan) {
        if (!this.isEmpty()) {
            Composite qsComposite = new Composite(composite, 0);
            qsComposite.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, colSpan, 1));
            GridLayoutComponents layout = new GridLayoutComponents(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            qsComposite.setLayout((Layout)layout);
            this.quickSelectionComposite = qsComposite;
            Label labelLoc = new Label(qsComposite, 0);
            labelLoc.setLayoutData((Object)new GridDataComponents(131072, 0x1000000, true, false));
            labelLoc.setText(Messages.get().ConfigSetControl_ConfigSetComboTitle);
            this.label = labelLoc;
            final InstantSearchList instantSearchListLoc = new InstantSearchList(qsComposite, 2048);
            instantSearchListLoc.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
            instantSearchListLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedQuickSelection = UtilsText.safeString((String)instantSearchListLoc.getText());
                    IQuickSelection currentQuickSelection = QuickSelectionControl.this.presettable.getQuickSelection();
                    if (currentQuickSelection == null || !selectedQuickSelection.equals(currentQuickSelection.getUIName(QuickSelectionControl.this.presettable.getExpressionContext()))) {
                        ProgressUtils.run(m -> QuickSelectionControl.this.controllerWrapper.getController().applyQuickSelection(selectedQuickSelection, QuickSelectionControl.this.presettable, (Object)instantSearchListLoc));
                    }
                }
            });
            SWTFactoryProxy.INSTANCE.setTestId((Widget)instantSearchListLoc, "periphsQuickSelCombo_" + this.presettable.getId());
            this.instantSearchList = instantSearchListLoc;
        }
    }

    public void dispose() {
        if (this.instantSearchList != null) {
            this.instantSearchList.dispose();
            this.instantSearchList = null;
        }
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        if (this.quickSelectionComposite != null) {
            this.quickSelectionComposite.dispose();
            this.quickSelectionComposite = null;
        }
    }

    public boolean isEmpty() {
        return QuickSelectionHelper.getAvailableQuickSelections((IPresettable)this.presettable).isEmpty();
    }

    public void update( @NonNull IChildControl.UpdateType updateType) {
        if (updateType == IChildControl.UpdateType.PROBLEM_DECORATION) {
            return;
        }
        Composite quickSelectionCompositeLoc = this.quickSelectionComposite;
        if (quickSelectionCompositeLoc != null) {
            Composite parent;
            boolean visible = this.presettable.isAvailable();
            boolean layoutChange = false;
            layoutChange = quickSelectionCompositeLoc.isVisible() ^ visible;
            quickSelectionCompositeLoc.setVisible(visible);
            boolean bl = ((GridDataComponents)Objects.requireNonNull(quickSelectionCompositeLoc.getLayoutData())).exclude = !visible;
            if (layoutChange && (parent = quickSelectionCompositeLoc.getParent()) != null) {
                parent.requestLayout();
            }
        }
        if (!this.isQuickSelAvailable(this.presettable)) {
            this.presettable.setQuickSelection(null);
        }
        InstantSearchList combo = this.instantSearchList;
        Label labelLoc = this.label;
        if (labelLoc != null || combo != null) {
            ToolTipableImplementation toolTipableImplementation = new ToolTipableImplementation();
            toolTipableImplementation.setUiName(Messages.get().ConfigSetControl_ConfigSetComboTitle);
            toolTipableImplementation.setDescription(MessageFormat.format(UtilsText.safeString((String)Messages.get().ConfigSetControl_ConfigSetComboDescription), this.presettable.getUiName()));
            IQuickSelection quickSelection = this.presettable.getQuickSelection();
            if (quickSelection != null) {
                toolTipableImplementation.setValueName(quickSelection.getUIName(this.presettable.getExpressionContext()));
                toolTipableImplementation.setValueDescription(quickSelection.getDescription());
            } else {
                toolTipableImplementation.setDescription(Messages.get().ConfigSetControl_QuickSelection_Custom);
            }
            String toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownValueDescriptionDecorator((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)toolTipableImplementation)));
            if (labelLoc != null) {
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)labelLoc, toolTipText);
                labelLoc.setEnabled(updateType != IChildControl.UpdateType.FORCE_DISABLE && this.presettable.isEnabled());
            }
            if (combo != null) {
                @NonNull String[] quickSelections = (String[])QuickSelectionHelper.getAvailableQuickSelections((IPresettable)this.presettable).stream().map(x -> x.getUIName(this.presettable.getExpressionContext())).toArray(String[]::new);
                SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "periphsQuickSelCombo_" + this.presettable.getId());
                combo.setItems(quickSelections);
                if (quickSelection != null) {
                    combo.select(quickSelection.getUIName(this.presettable.getExpressionContext()));
                } else {
                    combo.select(UtilsText.safeString((String)Messages.get().ConfigSetControl_QuickSelection_Custom));
                }
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)combo, toolTipText);
                combo.setEnabled(updateType != IChildControl.UpdateType.FORCE_DISABLE && this.presettable.isEnabled());
            }
        }
        if (quickSelectionCompositeLoc != null) {
            quickSelectionCompositeLoc.pack();
            quickSelectionCompositeLoc.requestLayout();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    boolean isQuickSelAvailable(IPresettable presettableInst) {
        @NonNull List availableQuickSels = QuickSelectionHelper.getAvailableQuickSelections((IPresettable)this.presettable);
        return availableQuickSels.contains(presettableInst.getQuickSelection());
    }
}

