/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.storage.StorageHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ProvidableSettingsSelectionStorageHelper {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ProvidableSettingsSelectionStorageHelper.class);
    private static final String SELECTIONS_ELEMENT_NAME = "selections";
    private static final String SELECTION_ELEMENT_NAME = "selection";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    @NonNull
    public static final String SETTING_SELECTIONS_KEY = "setting_selections_";
    @NonNull
    StorageHelper storageHelper = new StorageHelper(5);
    @NonNull
    private @NonNull Map<@NonNull String, @Nullable String> collapsibleSettingsState = new HashMap<String, String>();
    @NonNull
    private String mexFileLocation = "";

    public static @NonNull ProvidableSettingsSelectionStorageHelper getInstance() {
        try {
            ProvidableSettingsSelectionStorageHelper helper = (ProvidableSettingsSelectionStorageHelper)SWTFactoryProxy.INSTANCE.getSingletonInstance(ProvidableSettingsSelectionStorageHelper.class);
            return helper;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain instance of a providable setting selection helper", e);
        }
    }

    public ProvidableSettingsSelectionStorageHelper() {
        this.storageHelper.saveString(SETTING_SELECTIONS_KEY, "");
        SharedConfigurationFactory.getSharedConfigurationSingleton().addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfig, @NonNull ConfigChangeReason reason) {
                switch (reason) {
                    case LOAD_CONFIG: {
                        ProvidableSettingsSelectionStorageHelper.this.mexFileLocation = ProvidableSettingsSelectionStorageHelper.getMexFilePath();
                        ProvidableSettingsSelectionStorageHelper.this.loadSelections();
                        break;
                    }
                    case NEW_CONFIG: {
                        ProvidableSettingsSelectionStorageHelper.this.saveSelections();
                        ProvidableSettingsSelectionStorageHelper.this.mexFileLocation = ProvidableSettingsSelectionStorageHelper.getMexFilePath();
                        ProvidableSettingsSelectionStorageHelper.this.collapsibleSettingsState.clear();
                    }
                }
            }
        });
    }

    public boolean setSelectedChild(@NonNull IChildControl control, @Nullable String selectedChildId) {
        String fullSettingId = ProvidableSettingsSelectionStorageHelper.getFullId(control);
        if (fullSettingId == null) {
            return false;
        }
        this.collapsibleSettingsState.put(fullSettingId, selectedChildId);
        this.saveSelections();
        return true;
    }

    private static @Nullable String getFullId(@NonNull IChildControl control) {
        IChild child = control.getChild();
        ChildContext childContext = child.getChildContext();
        StringBuilder builder = new StringBuilder(100);
        IFunctionalGroup functionalGroup = childContext.getFunctionalGroup();
        if (functionalGroup == null) {
            return null;
        }
        builder.append(functionalGroup.getName()).append(".");
        IComponentInstanceConfig instance = childContext.getComponentInstanceConfig();
        if (instance == null) {
            return null;
        }
        builder.append(instance.getName()).append(".");
        builder.append(child.getId());
        String fullSettingId = builder.toString();
        return fullSettingId;
    }

    public @Nullable String getSelectedChild(@NonNull IChildControl control) {
        String fullId = ProvidableSettingsSelectionStorageHelper.getFullId(control);
        if (fullId == null) {
            return null;
        }
        return this.collapsibleSettingsState.get(fullId);
    }

    public boolean isStored(@NonNull IChildControl control) {
        String fullId = ProvidableSettingsSelectionStorageHelper.getFullId(control);
        if (fullId == null) {
            return false;
        }
        String selectedChildId = this.collapsibleSettingsState.get(fullId);
        return selectedChildId != null;
    }

    private void saveSelections() {
        StringWriter writer = new StringWriter();
        try {
            XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)SELECTIONS_ELEMENT_NAME);
            for (Map.Entry<String, String> entry : this.collapsibleSettingsState.entrySet()) {
                IMemento child = xmlMemento.createChild(SELECTION_ELEMENT_NAME);
                child.putString(ID_ATTRIBUTE_NAME, entry.getKey());
                String value = entry.getValue();
                if (value == null) continue;
                child.putString(VALUE_ATTRIBUTE_NAME, value);
            }
            xmlMemento.save((Writer)writer);
            this.storageHelper.saveString(SETTING_SELECTIONS_KEY + this.mexFileLocation, UtilsText.safeString((String)writer.toString()));
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "[TOOL] File exception occured. Detail: {0}", e.getMessage());
        }
    }

    private void loadSelections() {
        try {
            if (UtilsText.isEmpty((String)this.mexFileLocation)) {
                return;
            }
            String mementoStrContent = this.storageHelper.loadString(SETTING_SELECTIONS_KEY + this.mexFileLocation, "");
            if ("".equals(mementoStrContent)) {
                return;
            }
            StringReader reader = new StringReader(mementoStrContent);
            XMLMemento xmlMemento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] children = xmlMemento.getChildren();
            this.collapsibleSettingsState.clear();
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String id = UtilsText.safeString((String)child.getString(ID_ATTRIBUTE_NAME));
                String value = child.getString(VALUE_ATTRIBUTE_NAME);
                this.collapsibleSettingsState.put(id, value);
                ++n2;
            }
        }
        catch (WorkbenchException e) {
            LOGGER.log(Level.SEVERE, "[TOOL] XMLMemento exception occured. Detail: {0}", e.getMessage());
        }
    }

    private static String getMexFilePath() {
        @Nullable IPath locationPath = SharedConfigurationFactory.getSharedConfigurationSingleton().getLocationPath();
        String projectLocation = locationPath == null ? "" : locationPath.toOSString();
        return projectLocation;
    }

    public void onShutdown() {
        this.saveSelections();
    }

    public void removeSettingStateEntries(String infix) {
        this.collapsibleSettingsState.keySet().removeIf(fullId -> fullId.contains(infix));
        this.saveSelections();
    }
}

