/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.GcUtils;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.ui.utils.views.GenericSelectionProvider;
import com.nxp.swtools.common.ui.utils.views.PartListener2Adapter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.DelayedActionExecutorAdapter;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.common.utils.runtime.IDelayedActionExecutor;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ConfigSetControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.EditorViewBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.view.ToolView;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.IValidationProblemListener;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.engine.ValidationProblemListenerAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class GlobalComponentSettingView
extends EditorViewBase {
    private static final int DELAY_BEFORE_SCROLLING = 200;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(GlobalComponentSettingView.class);
    public static final int TITLE_ROW_COLS = 3;
    public static final int COMPONENT_COLS = 2;
    public static final int CONFIG_SET_COLS = 3;
    @NonNull
    public static final String ID = "com.nxp.swtools.periphs.gui.view.globalcomponentsettings";
    private static final int MIN_WIDTH_EMS = 45;
    protected ScrolledComposite scrolledComposite;
    protected final APeriphController controller = Controller.getInstance();
    @Nullable
    private IChildControl componentSettingControl = null;
    @NonNull
    protected final @NonNull Collection<@NonNull IEventListener> registeredListeners = new ArrayList<IEventListener>();
    @NonNull
    protected final @NonNull Map<@NonNull IConfigSetConfig, ConfigSetControl> configSetControls = new HashMap<IConfigSetConfig, ConfigSetControl>();
    @Nullable
    private Listener resizeListener;
    protected GenericSelectionProvider viewSelectionProvider = new GenericSelectionProvider();
    @NonNull
    private static final String TEST_ID_KEY = "test-id";
    @NonNull
    protected final IControllerWrapper controllerWrapper = PeriphControllerWrapper.getInstance();
    @NonNull
    protected EditorViewBase.ActionRequired requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
    @NonNull
    private ValidationProblemListenerAdapter validationsListener = new ValidationProblemListenerAdapter(){

        public void validationProblemsChanged(@NonNull Collection<@NonNull IValidationProblem> problems) {
            if (GlobalComponentSettingView.this.contentComposite != null && !GlobalComponentSettingView.this.contentComposite.isDisposed()) {
                GlobalComponentSettingView.this.refreshIfVisible(IChildControl.UpdateType.PROBLEM_DECORATION);
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        final String secondaryId = site.getSecondaryId();
        if (secondaryId == null) {
            return;
        }
        site.setSelectionProvider((ISelectionProvider)this.viewSelectionProvider);
        this.setPartName(Messages.get().GlobalComponentSettingView_GlobalSettings);
        this.setTitleImage(ToolView.getDecoratedImage((String)"views/component_global.png", (int)-1));
        this.getSiteSafe().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part.equals((Object)GlobalComponentSettingView.this)) {
                    DelayedExecution ex = new DelayedExecution(Messages.get().GlobalComponentSettingView_ScrollToConfigSet, (IDelayedActionExecutor)new DelayedActionExecutorAdapter(){

                        public void runAction() {
                            GlobalComponentSettingView.this.scrollTo(secondaryId, null);
                        }
                    }, 200);
                    ex.requestExecution();
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                GlobalComponentSettingView.this.getSiteSafe().getPage().removePartListener((IPartListener)this);
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    @Override
    public void dispose() {
        ValidationEngineFactory.removeListener((IValidationProblemListener)this.validationsListener);
        for (IEventListener listener : this.registeredListeners) {
            this.controller.removeListener(listener);
        }
        super.dispose();
    }

    protected @NonNull Composite getDefaultCompositeSpecificImplementation(Composite basic) {
        return new ScrolledComposite(basic, 768);
    }

    public void createPartControl(Composite parent) {
        Composite compositeLoc;
        ScrolledComposite scrolledCompositeLoc;
        this.scrolledComposite = scrolledCompositeLoc = (ScrolledComposite)this.createDefaultComposite(parent);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)scrolledCompositeLoc, "periphsGlobalComponentSettingViewContent");
        this.contentComposite = compositeLoc = new Composite((Composite)scrolledCompositeLoc, 0);
        GridLayoutComponents layout = new GridLayoutComponents(2, false);
        layout.marginWidth = 8;
        layout.horizontalSpacing = 8;
        compositeLoc.setLayout((Layout)layout);
        scrolledCompositeLoc.setContent((Control)compositeLoc);
        scrolledCompositeLoc.setExpandHorizontal(true);
        scrolledCompositeLoc.setExpandVertical(true);
        this.getSiteSafe().getPage().addPartListener((IPartListener2)new PartListener2Adapter(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (GlobalComponentSettingView.this.getViewSiteNonNull().getPart() == partRef.getPart(false)) {
                    if (GlobalComponentSettingView.this.state == EditorViewBase.State.CREATED_HIDDEN) {
                        GlobalComponentSettingView.this.state = EditorViewBase.State.CREATED_VISIBLE;
                        if (GlobalComponentSettingView.this.requiredAction == EditorViewBase.ActionRequired.RECREATE) {
                            GlobalComponentSettingView.this.recreate();
                        } else if (GlobalComponentSettingView.this.requiredAction == EditorViewBase.ActionRequired.REFRESH) {
                            GlobalComponentSettingView.this.refreshSettings(IChildControl.UpdateType.NORMAL);
                        }
                        GlobalComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                    } else if (GlobalComponentSettingView.this.state == EditorViewBase.State.READY_TO_CREATE) {
                        GlobalComponentSettingView.this.state = EditorViewBase.State.CREATED_VISIBLE;
                        GlobalComponentSettingView.this.recreate();
                        GlobalComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                    }
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (GlobalComponentSettingView.this.getViewSiteNonNull().getPart() == partRef.getPart(false) && GlobalComponentSettingView.this.state == EditorViewBase.State.CREATED_VISIBLE) {
                    GlobalComponentSettingView.this.state = EditorViewBase.State.CREATED_HIDDEN;
                    GlobalComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (GlobalComponentSettingView.this.getViewSiteNonNull().getPart() == partRef.getPart(false)) {
                    GlobalComponentSettingView.this.getSiteSafe().getPage().removePartListener((IPartListener2)this);
                    GlobalComponentSettingView.this.state = EditorViewBase.State.UNINITIALIZED;
                    GlobalComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                }
            }
        });
        parent.getDisplay().asyncExec(() -> {
            if (this.state == EditorViewBase.State.UNINITIALIZED) {
                this.state = EditorViewBase.State.READY_TO_CREATE;
                IWorkbenchPage page = this.getSiteSafe().getPage();
                IWorkbenchPart part = this.getSiteSafe().getPart();
                if (page == null || part == null) {
                    LOGGER.fine("[TOOL] GUI: page or part is set to null");
                    return;
                }
                if (page.isPartVisible(part)) {
                    this.recreate();
                    this.contentComposite.forceFocus();
                    this.state = EditorViewBase.State.CREATED_VISIBLE;
                }
            }
        });
        this.registerEventListener();
        ValidationEngineFactory.addListener((IValidationProblemListener)this.validationsListener);
    }

    protected @NonNull IViewSite getViewSiteNonNull() {
        IViewSite site = this.getViewSite();
        assert (site != null);
        return site;
    }

    private void registerEventListener() {
        IEventListener changesListener = new IEventListener(){

            public void handle(ToolEvent event) {
                if (event.originator != GlobalComponentSettingView.this) {
                    if (GlobalComponentSettingView.this.state == EditorViewBase.State.CREATED_VISIBLE) {
                        Display display = Display.getCurrent();
                        if (display != null) {
                            display.asyncExec(() -> GlobalComponentSettingView.this.recreate());
                        }
                    } else if (GlobalComponentSettingView.this.state == EditorViewBase.State.CREATED_HIDDEN) {
                        GlobalComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.RECREATE;
                    }
                }
            }
        };
        this.controller.addListener(1, changesListener);
        this.registeredListeners.add(changesListener);
        IEventListener settingListener = new IEventListener(){

            public void handle(ToolEvent event) {
                GlobalComponentSettingView.this.refreshIfVisible(IChildControl.UpdateType.NORMAL);
            }
        };
        this.controller.addListener(2, settingListener);
        this.registeredListeners.add(settingListener);
        IEventListener initializationListener = new IEventListener(){

            public void handle(ToolEvent event) {
                GlobalComponentSettingView.this.refreshIfVisible(IChildControl.UpdateType.INITIALIZATION);
            }
        };
        this.controller.addListener(4, initializationListener);
        this.registeredListeners.add(initializationListener);
    }

    protected void refreshIfVisible(@NonNull IChildControl.UpdateType updateType) {
        if (this.state == EditorViewBase.State.CREATED_HIDDEN) {
            if (this.requiredAction != EditorViewBase.ActionRequired.RECREATE) {
                this.requiredAction = EditorViewBase.ActionRequired.REFRESH;
            }
        } else {
            this.refreshSettings(updateType);
        }
    }

    void createTitleRow(@NonNull Composite parent) {
        Composite titleRow = new Composite(parent, 0);
        titleRow.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, 2, 1));
        titleRow.setBackgroundMode(2);
        GridLayoutComponents titleRowLayout = new GridLayoutComponents(3, false);
        titleRowLayout.marginHeight = 0;
        titleRowLayout.marginWidth = 0;
        titleRow.setLayout((Layout)titleRowLayout);
        Label title = new Label(titleRow, 64);
        FontFactory.changeStyle((Control)title, (int)1);
        FontFactory.scaleFontSize((Control)title, (double)1.5);
        title.setText(Messages.get().GlobalComponentSettingView_GlobalSettings);
        title.setLayoutData((Object)new GridDataComponents(4, 4, true, false));
    }

    void createContent() {
        String secondaryId;
        Composite contentCompositeLoc = this.contentComposite;
        if (contentCompositeLoc != null) {
            this.createTitleRow(contentCompositeLoc);
            this.updateAllConfigSets(contentCompositeLoc);
        }
        if ((secondaryId = this.getViewSiteNonNull().getSecondaryId()) != null) {
            this.scrollTo(secondaryId, null);
        }
        this.scrolledComposite.setMinWidth(GcUtils.getEmWidth((Control)this.scrolledComposite, (boolean)true) * 45);
        this.scrolledComposite.setMinHeight(this.contentComposite.computeSize((int)this.scrolledComposite.getClientArea().width, (int)-1).y);
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                if (!GlobalComponentSettingView.this.getSiteSafe().getPage().isPartVisible((IWorkbenchPart)GlobalComponentSettingView.this)) {
                    return;
                }
                GlobalComponentSettingView.this.scrolledComposite.setMinHeight(GlobalComponentSettingView.this.contentComposite.computeSize((int)GlobalComponentSettingView.this.scrolledComposite.getClientArea().width, (int)-1).y);
            }
        };
        this.contentComposite.addListener(11, this.resizeListener);
    }

    void updateAllConfigSets(@NonNull Composite composite) {
        List configSets = (List)this.controller.getProfile().getConfiguredComponents().entrySet().stream().map(x -> ((IComponentConfig)x.getValue()).getGlobalConfigSet()).filter(Objects::nonNull).collect(CollectorsUtils.toList());
        this.updateConfigSetsContent(configSets, composite);
    }

    private void updateConfigSetsContent(@NonNull List<@NonNull IConfigSetConfig> configSets, @NonNull Composite composite) {
        this.configSetControls.keySet().retainAll(configSets);
        for (IConfigSetConfig configSet : configSets) {
            ConfigSetControl configSetControl = this.configSetControls.get(configSet);
            if (configSetControl == null || configSetControl.isDisposed()) {
                configSetControl = (ConfigSetControl)ChildControlFactory.create((IChild)configSet, PeriphControllerWrapper.getInstance(), null);
                if (configSetControl == null) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Attempt to create control failed for config set: {0}", configSet);
                    continue;
                }
                configSetControl.create(composite, 3);
            }
            configSetControl.update(IChildControl.UpdateType.NORMAL);
            this.configSetControls.put(configSet, configSetControl);
        }
    }

    void recreate() {
        block10: {
            if (this.contentComposite.isDisposed()) {
                return;
            }
            this.contentComposite.setRedraw(false);
            try {
                try {
                    if (this.resizeListener != null) {
                        this.contentComposite.removeListener(11, this.resizeListener);
                    }
                    if (this.componentSettingControl != null) {
                        this.componentSettingControl.dispose();
                    }
                    for (ConfigSetControl configSetControl : this.configSetControls.values()) {
                        configSetControl.dispose();
                    }
                    Control[] controlArray = this.contentComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control ctrl = controlArray[n2];
                        ctrl.dispose();
                        ++n2;
                    }
                    this.createContent();
                }
                catch (ExpressionException e) {
                    e.log();
                    this.contentComposite.setRedraw(true);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.contentComposite.setRedraw(true);
                throw throwable;
            }
            this.contentComposite.setRedraw(true);
        }
        this.contentComposite.layout();
    }

    public static boolean open(@NonNull IViewSite viewSite, @NonNull String componentType, boolean activate) {
        IWorkbenchPage iWorkbenchPage = viewSite.getPage();
        if (iWorkbenchPage != null) {
            return GlobalComponentSettingView.open(iWorkbenchPage, componentType, null);
        }
        return false;
    }

    public static boolean open(@Nullable IWorkbenchPage workbenchPage, @NonNull String componentType, @Nullable IChild problematicChild) {
        if (workbenchPage != null) {
            try {
                GlobalComponentSettingView openedView = (GlobalComponentSettingView)workbenchPage.showView(ID);
                workbenchPage.activate((IWorkbenchPart)openedView);
                openedView.scrollTo(componentType, problematicChild);
                return true;
            }
            catch (PartInitException partInitException) {
                return false;
            }
        }
        return false;
    }

    void scrollTo(@NonNull String componentType, @Nullable IChild problematicChild) {
        Composite contentCompositeLoc = this.contentComposite;
        if (contentCompositeLoc != null) {
            Runnable runnable = () -> {
                IComponentConfig configuredComponent = this.controller.getConfiguredComponent(componentType);
                if (configuredComponent == null) {
                    return;
                }
                IConfigSetConfig globalConfigSet = configuredComponent.getGlobalConfigSet();
                ConfigSetControl configSetControl = this.configSetControls.get(globalConfigSet);
                if (configSetControl != null) {
                    String testId = "";
                    Control mainControlLoc = configSetControl.mainControl;
                    Control labelControlLoc = configSetControl.labelControl;
                    if (labelControlLoc != null) {
                        testId = UtilsText.safeString((String)((String)labelControlLoc.getData(TEST_ID_KEY)));
                    }
                    if (mainControlLoc != null) {
                        testId = UtilsText.safeString((String)((String)mainControlLoc.getData(TEST_ID_KEY)));
                    }
                    ScrolledCompositeHelper.scrollToControlWithId((Composite)contentCompositeLoc, (String)testId);
                    if (problematicChild != null) {
                        if (SwToolsProduct.isUctProduct()) {
                            ComponentSettingViewHelper.selectChildrenOnPath(configSetControl, problematicChild.getId(), null, IChildControl.UpdateType.NORMAL);
                        } else {
                            ComponentSettingViewHelper.selectChildrenOnPath(configSetControl, problematicChild.getId(), IChildControl.UpdateType.NORMAL);
                        }
                        String childTestID = "periphsSettCtrl_" + problematicChild.getId();
                        Control control = ScrolledCompositeHelper.getControlWithTestId((Composite)contentCompositeLoc, (String)childTestID);
                        if (control != null) {
                            control.setFocus();
                        }
                    }
                }
            };
            UIJobHelper.runUIJob((Runnable)runnable, (String)Messages.get().GlobalComponentSettingView_ScrollToConfigSet, (boolean)false, (Display)contentCompositeLoc.getDisplay(), (long)200L);
        }
    }

    protected void refreshStatus() {
        this.refreshStatusBar();
    }

    void refreshSettings(@NonNull IChildControl.UpdateType updateType) {
        this.updateControls(updateType);
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            this.scrolledComposite.setMinHeight(this.contentComposite.computeSize((int)this.scrolledComposite.getClientArea().width, (int)-1).y);
        }
    }

    void updateControls(@NonNull IChildControl.UpdateType updateType) {
        this.contentComposite.setRedraw(false);
        try {
            if (this.componentSettingControl != null) {
                this.componentSettingControl.update(updateType);
            }
            this.configSetControls.values().forEach(x -> x.update(updateType));
        }
        finally {
            this.contentComposite.setRedraw(true);
        }
    }
}

