/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ConfigSetControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ComponentInstanceControl
extends ChildProvidableControlBase {
    @NonNull
    private final @NonNull Map<@NonNull IConfigSetConfig, @Nullable ConfigSetControl> configSetControls = new HashMap<IConfigSetConfig, ConfigSetControl>();
    private Composite contentComposite;

    public ComponentInstanceControl(@NonNull IComponentInstanceConfig instanceConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super((IChildProvidable)instanceConfig, controlOptions, controllerWrapper);
        this.onCreateConfigSetsContent();
    }

    private @NonNull Composite getMainComposite() {
        Control mainControlLoc = this.mainControl;
        if (mainControlLoc != null) {
            return (Composite)mainControlLoc;
        }
        Composite contentCompositeLoc = this.contentComposite;
        assert (contentCompositeLoc != null);
        return contentCompositeLoc;
    }

    @Override
    public void create(@NonNull Composite composite, int colSpan) {
        Control mainControlLoc;
        this.contentComposite = composite;
        if (!Objects.equals((Object)ControlOptions.ShowContentAs.TABS, (Object)this.getControlOptions().getShowContentAs())) {
            Label label = new Label(composite, 258);
            label.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, 3, 1));
        }
        super.create(composite, colSpan);
        Control labelControlLoc = this.labelControl;
        if (labelControlLoc != null) {
            labelControlLoc.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, colSpan, 1));
        }
        if ((mainControlLoc = this.mainControl) != null) {
            mainControlLoc.setLayoutData((Object)new GridDataComponents(4, 128, true, false, colSpan, 1));
        }
    }

    @Override
    public void update(@NonNull IChildControl.UpdateType updateType) {
        if (this.isDisposed()) {
            return;
        }
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            this.onUpdateConfigSetsContent();
        }
        super.update(updateType);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void onUpdateConfigSetsContent() {
        boolean sameContent;
        @NonNull List newChildren = ((IComponentInstanceConfig)this.child).getChildren();
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull CollectionsUtils.IdentitySet newChildrenIdentitySet = new CollectionsUtils.IdentitySet((Collection)newChildren);
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull CollectionsUtils.IdentitySet currentConfigSets = new CollectionsUtils.IdentitySet(this.configSetControls.keySet());
        boolean bl = sameContent = currentConfigSets.containsAll((Collection<?>)newChildrenIdentitySet) && newChildrenIdentitySet.containsAll((Collection<?>)currentConfigSets);
        if (!sameContent) {
            for (Map.Entry<IConfigSetConfig, ConfigSetControl> entry : this.configSetControls.entrySet()) {
                ConfigSetControl value = entry.getValue();
                if (value == null) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Config set with ID \"{0}\" does not have control", entry.getKey());
                    continue;
                }
                if (value.isDisposed()) continue;
                value.dispose();
            }
            this.configSetControls.clear();
        }
        ArrayList<@NonNull IChildControl> newControls = new ArrayList<IChildControl>();
        for (IConfigSetConfig key : newChildren) {
            IChildControl control = this.configSetControls.get(key);
            if (control == null) {
                ControlOptions overrideOptions = this.createControlOptionsForChild((IChild)key);
                control = ChildControlFactory.create((IChild)key, overrideOptions, this.controllerWrapper);
                if (control != null) {
                    control.create(this.getMainComposite(), 3);
                    this.configSetControls.put(key, (ConfigSetControl)control);
                }
            } else if (control.isDisposed()) {
                control.create(this.getMainComposite(), 3);
            }
            if (control == null) continue;
            newControls.add(control);
        }
        this.children.clear();
        this.children.addAll(newControls);
    }

    private void onCreateConfigSetsContent() {
        for (IChildControl control : this.children) {
            IChild controlChild = control.getChild();
            if (!(controlChild instanceof IConfigSetConfig)) continue;
            this.configSetControls.put((IConfigSetConfig)((ConfigSetConfig)controlChild), (ConfigSetControl)control);
        }
    }
}

