/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import animations.swt.EaseSelector;
import animations.swt.SizeChanger;
import com.nxp.swtools.common.ui.utils.GcUtils;
import com.nxp.swtools.common.ui.utils.swt.ControlDecorationUtils;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.ui.utils.swt.widgets.ReadOnlyText;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.PeripheralsToolTippableFormatter;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.DocumentationView;
import com.nxp.swtools.periphs.gui.view.DocumentationViewHelper;
import com.nxp.swtools.periphs.gui.view.SubSettingsDialog;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.CollapsibleSettingsStorageHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.StructControl;
import com.nxp.swtools.provider.analytics.ActionAnalyticsBuilder;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.ChildValidationHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.profiler.Profiler;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableAmpersandDescriptionDecorator;
import com.nxp.swtools.utils.tooltip.ToolTipableHtmlErrorWarningInfoDecorator;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownValueDescriptionDecorator;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.utils.ValidationProblemsMenuHelper;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ChildControlBase
implements IChildControl {
    protected static final int LABEL_COMPOSITE_BASE_COLUMN_COUNT = 5;
    protected static final Logger LOGGER = LogManager.getLogger(ChildControlBase.class);
    private static final String COLLAPSE_SETTING_TARGET_ERROR_MESSAGE = "[DATA] The value of the COLLAPSE_SETTING option in the setting: \"{0}\" in the component \"{1}\" is not a full ID or reference to a structured setting. Currently only structure setting is supported.";
    private final int MIN_ANIMATION_DURATION = 500;
    private final int MAX_ANIMATION_DURATION = 1000;
    @Deprecated
    @NonNull
    public static final String KEY_ERROR_DECORATION = "error_decoration";
    @NonNull
    public final IControllerWrapper controllerWrapper;
    @NonNull
    protected final IChild child;
    @Nullable
    protected Composite parent;
    @Nullable
    protected Control labelControl;
    @Nullable
    protected Label labelControlInternal;
    protected Label quickSolverButton;
    private Label documentationLinkButton;
    @Nullable
    protected Label expandGroupButton;
    @Nullable
    protected Control expandGroupContent;
    protected boolean expandGroupVisible = true;
    @Nullable
    protected Control mainControl;
    @Nullable
    protected Control mainControlInternal;
    @NonNull
    protected ControlOptions controlOptions;
    protected boolean disposed;
    protected int currentColSpan = 0;
    @NonNull
    private static final String AMPERSAND = "&";
    @NonNull
    private static final String AMPERSAND_REPLACEMENT = "&&";
    @Nullable
    protected SubSettingsDialog activeSubSettingDialog;
    @Nullable
    protected Label subSettingsButton;
    @Nullable
    private IChildControl parentChildControl;
    @NonNull
    protected IChildControl.UpdateType controlUpdateType = IChildControl.UpdateType.NORMAL;

    public ChildControlBase(@NonNull IChild child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        this.child = child;
        this.controllerWrapper = controllerWrapper;
        this.controlOptions = controlOptions;
        this.disposed = true;
    }

    @Override
    public void create(@NonNull Composite composite, int colSpan) {
        int controlColSpan;
        Control labelControlLoc;
        this.parent = composite;
        this.currentColSpan = colSpan;
        this.labelControl = labelControlLoc = this.getControlOptions().isLabelHidden() ? null : this.createLabelControl(composite);
        Control mainControlLoc = this.createMainControl(composite);
        if (this.getControlOptions().isLabelHidden() && mainControlLoc != null && !this.getControlOptions().isBorderHidden()) {
            this.createErrorDecoration(mainControlLoc, 16512);
        }
        this.mainControl = mainControlLoc;
        int labelSpan = mainControlLoc == null ? colSpan : 1;
        int n = controlColSpan = labelControlLoc == null ? colSpan : colSpan - 1;
        if (labelControlLoc != null && labelControlLoc.getLayoutData() == null) {
            GridDataComponents labelControlLayoutData = new GridDataComponents(16384, 0x1000000, false, false, labelSpan, 1);
            labelControlLayoutData.maxWidth = GcUtils.getEmWidth((Control)labelControlLoc, (boolean)true) * 25;
            labelControlLoc.setLayoutData((Object)labelControlLayoutData);
        }
        if (mainControlLoc != null && mainControlLoc.getLayoutData() == null) {
            GridDataComponents mainControlLayoutData = new GridDataComponents(4, 0x1000000, true, false, controlColSpan, 1);
            mainControlLoc.setLayoutData((Object)mainControlLayoutData);
        }
        this.expandGroupContent = this.getExpandGroupContent();
        this.disposed = false;
    }

    @Override
    public void update(@NonNull IChildControl.UpdateType updateType) {
        boolean visible;
        Profiler profiler;
        IChildControl childControl;
        if (this.isDisposed()) {
            return;
        }
        Control labelControlLoc = this.labelControl;
        Control mainControlLoc = this.mainControl;
        if ((labelControlLoc == null || labelControlLoc.isDisposed()) && (mainControlLoc == null || mainControlLoc.isDisposed())) {
            return;
        }
        SubSettingsDialog subSettingDialogLoc = this.activeSubSettingDialog;
        if (subSettingDialogLoc != null && (childControl = subSettingDialogLoc.getChildControl()) != null) {
            childControl.update(IChildControl.UpdateType.SUB_SETTINGS_DIALOG);
        }
        Label labelControlInternalLoc = this.labelControlInternal;
        Control mainControlInternalLoc = this.mainControlInternal;
        BigInteger index = profiler.start(ChildControlBase.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("GUI update of \"{0}\"", this.getChild().getId())));
        this.getControlOptions().refresh();
        boolean bl = visible = this.child.isAvailable() && !this.child.isControlHidden();
        if (updateType == IChildControl.UpdateType.SUB_SETTINGS_DIALOG) {
            visible = this.child.isAvailable();
        }
        boolean enabled = updateType != IChildControl.UpdateType.FORCE_DISABLE && this.child.isEnabled();
        IChildControl.UpdateType updateChildrenType = this.child.isEnabled() ? updateType : IChildControl.UpdateType.FORCE_DISABLE;
        this.updateStoredUpdateType(updateChildrenType);
        boolean layoutChange = false;
        String toolTipText = visible ? PeripheralsToolTippableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownValueDescriptionDecorator((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)new ToolTipableAmpersandDescriptionDecorator((IToolTipable)new ToolTipableHtmlErrorWarningInfoDecorator((IToolTipable)this.child))))) : "";
        toolTipText = this.updateToolTipWithSyncDetail(toolTipText);
        if (labelControlLoc != null && !labelControlLoc.isDisposed()) {
            layoutChange = labelControlLoc.isVisible() ^ visible;
            this.updateLabelEnableAndVisibleState(enabled, visible);
            this.updateSubSettingsButton(enabled);
            SWTFactoryProxy.INSTANCE.setTestId((Widget)labelControlLoc, "periphsSettLabel_" + this.child.getId());
            if (labelControlInternalLoc != null) {
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)labelControlInternalLoc, toolTipText);
                if (labelControlInternalLoc.getParent() != null) {
                    this.setParentControlEnabled(labelControlInternalLoc.getParent(), true);
                }
            }
            SWTFactoryProxy.INSTANCE.setHtmlTooltip(labelControlLoc, toolTipText);
            if (visible) {
                this.updateLabelContent(labelControlLoc, updateChildrenType);
            }
        }
        if (mainControlLoc != null && !mainControlLoc.isDisposed()) {
            SWTFactoryProxy.INSTANCE.setHtmlTooltip(mainControlLoc, toolTipText);
            layoutChange = layoutChange || mainControlLoc.isVisible() != visible;
            this.setEnabledStateToMainControl(enabled);
            if (mainControlInternalLoc != null) {
                SWTFactoryProxy.INSTANCE.setHtmlTooltip(mainControlInternalLoc, toolTipText);
            }
            mainControlLoc.setVisible(visible);
            ((GridDataComponents)Objects.requireNonNull(mainControlLoc.getLayoutData())).exclude = !visible;
            SWTFactoryProxy.INSTANCE.setTestId((Widget)mainControlLoc, "periphsSettCtrl_" + this.child.getId());
            if (mainControlInternalLoc != null) {
                SWTFactoryProxy.INSTANCE.setTestId((Widget)mainControlInternalLoc, "periphsSettCtrl_" + this.child.getId());
            }
            if (visible) {
                this.updateMainContent(mainControlLoc, updateChildrenType);
            }
            this.updateSelectionOfExpandGroupContent();
            Control expandGroupContentLoc = this.expandGroupContent;
            if (expandGroupContentLoc != null && !this.getControlOptions().isExpandGroupHidden() && !this.isExpandGroupVisible()) {
                this.setControlVisible(expandGroupContentLoc, this.isExpandGroupVisible());
                layoutChange = true;
            }
        }
        if (layoutChange && this.parent != null) {
            this.parent.requestLayout();
        }
        profiler.stop(index, ChildControlBase.class, null);
    }

    protected void updateStoredUpdateType(IChildControl.UpdateType type) {
        if (type == IChildControl.UpdateType.NORMAL || type == IChildControl.UpdateType.FORCE_DISABLE) {
            this.controlUpdateType = type;
        }
    }

    protected void updateSelectionOfExpandGroupContent() {
    }

    protected void setEnabledStateToMainControl(boolean enabled) {
        Control mainControlLoc = this.mainControl;
        Control mainControlInternalLoc = this.mainControlInternal;
        if (mainControlLoc != null) {
            if (mainControlInternalLoc != null) {
                if (mainControlInternalLoc.getEnabled() != enabled) {
                    mainControlInternalLoc.setEnabled(enabled);
                }
                this.setParentControlEnabled(mainControlInternalLoc.getParent(), true);
            } else {
                if (mainControlLoc.getEnabled() != enabled) {
                    mainControlLoc.setEnabled(enabled);
                }
                this.setParentControlEnabled(mainControlLoc.getParent(), true);
            }
        }
    }

    protected void updateErrorDecoration(@NonNull Control controlWithDecoration) {
        if (!this.isDisposed()) {
            StringBuilder result = new StringBuilder();
            int statusLevel = this.getStatusLevel();
            String status = this.getDecoratorStatus(statusLevel);
            if (statusLevel >= 2) {
                result.append(com.nxp.swtools.utils.Messages.get().ToolTipableFormater_Errors);
            } else if (statusLevel == 1) {
                result.append(com.nxp.swtools.utils.Messages.get().ToolTipableFormater_Warnings);
            } else if (statusLevel == 0) {
                result.append(com.nxp.swtools.utils.Messages.get().ToolTipableFormater_Infos);
            }
            String dependenciesMessageInTree = ValidationHelper.getDependenciesMessageInTree((IChild)this.child, (int)statusLevel);
            String statusAndDependencyMessage = ChildValidationHelper.mergeProblems((String[])new String[]{status, dependenciesMessageInTree});
            if (!UtilsText.isEmpty((String)statusAndDependencyMessage)) {
                result.append("\n");
                result.append(statusAndDependencyMessage);
            }
            String decoratorDescription = null;
            String quickFixDescription = null;
            if (result.length() > 0) {
                decoratorDescription = result.toString();
                result.insert(0, String.valueOf(Messages.get().QuickFixButton_Description) + "\n");
                quickFixDescription = result.toString();
            }
            if (decoratorDescription != null) {
                ControlDecorationUtils.setImage((Control)controlWithDecoration, (Image)ToolsImages.getStatusDecoratorImg((int)statusLevel));
            }
            this.updateQuickSolver(quickFixDescription);
            ControlDecorationUtils.updateControlDecoration((Control)controlWithDecoration, (String)decoratorDescription);
        }
    }

    protected String getDecoratorStatus(int statusLevel) {
        String status = null;
        if (statusLevel == 2) {
            status = this.child.getError();
        } else if (statusLevel == 1) {
            status = this.child.getWarning();
        } else if (statusLevel == 0) {
            status = this.child.getInfo();
        }
        return status;
    }

    protected int getStatusLevel() {
        int problemLevelOfChild = ValidationHelper.getHighestSeveritySettingValidationProblemLevelInTree((IChild)this.child);
        int statusLevel = -1;
        if (this.child.getError() != null || problemLevelOfChild >= 2) {
            statusLevel = 2;
        } else if (this.child.getWarning() != null || problemLevelOfChild == 1) {
            statusLevel = 1;
        } else if (this.child.getInfo() != null || problemLevelOfChild == 0) {
            statusLevel = 0;
        }
        return statusLevel;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void updateQuickSolver(@Nullable String description) {
        Label quickSolverLoc = this.quickSolverButton;
        if (quickSolverLoc != null && !quickSolverLoc.isDisposed()) {
            int statusLevel = ValidationHelper.getHighestSeveritySettingValidationProblemLevel((IChild)this.getChild());
            ArrayList<@NonNull E> problems = new ArrayList();
            problems.addAll(ValidationHelper.getSettingValidationProblems((IChild)this.getChild(), (int)3));
            problems.addAll(ValidationHelper.getSettingValidationProblems((IChild)this.getChild(), (int)2));
            problems.addAll(ValidationHelper.getSettingValidationProblems((IChild)this.getChild(), (int)1));
            ArrayList<@NonNull E> mergedProblems = new ArrayList(problems.size());
            ValidationProblemsMenuHelper.mergeProblems(problems, mergedProblems);
            boolean visible = false;
            if (!problems.isEmpty()) {
                MenuManager menuMgr = new MenuManager("#PopupMenu");
                menuMgr.setRemoveAllWhenShown(true);
                menuMgr.addMenuListener(manager -> {
                    for (IBaseProblem problem : mergedProblems) {
                        if (!(problem instanceof IValidationProblem)) continue;
                        @NonNull IValidationProblem validationProblem = (IValidationProblem)problem;
                        MenuManager problemMenuManager = new MenuManager(validationProblem.getDependency().getDescription());
                        ValidationProblemsMenuHelper.createPopupMenu((IBaseProblem)validationProblem, (MenuManager)problemMenuManager, (boolean)false);
                        manager.add((IContributionItem)problemMenuManager);
                    }
                });
                Menu oldMenu = quickSolverLoc.getMenu();
                if (oldMenu != null) {
                    oldMenu.dispose();
                }
                Menu menu = menuMgr.createContextMenu((Control)quickSolverLoc);
                quickSolverLoc.setMenu(menu);
                visible = true;
            }
            quickSolverLoc.setVisible(visible);
            Object layoutData = quickSolverLoc.getLayoutData();
            if (layoutData instanceof GridDataComponents) {
                GridDataComponents data = (GridDataComponents)layoutData;
                data.exclude = !visible;
            }
            switch (statusLevel) {
                case 1: 
                case 2: 
                case 3: {
                    quickSolverLoc.setImage(ToolsImages.getImage((String)"icons/autoResolveProblem.png"));
                    break;
                }
                default: {
                    quickSolverLoc.setImage(null);
                }
            }
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)quickSolverLoc, description);
            quickSolverLoc.requestLayout();
        }
    }

    protected void updateSubSettingsButton(boolean enabled) {
        Label subSettingsButtonLoc = this.subSettingsButton;
        if (subSettingsButtonLoc != null && !subSettingsButtonLoc.isDisposed()) {
            final List<@NonNull ISettingConfig> relatedSettings = this.getSubSettingsChildren();
            boolean visible = false;
            if (!relatedSettings.isEmpty()) {
                visible = true;
                MenuManager menuMgr = new MenuManager();
                menuMgr.setRemoveAllWhenShown(true);
                menuMgr.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        int i = 0;
                        while (i < relatedSettings.size()) {
                            ISettingConfig subSetting = (ISettingConfig)relatedSettings.get(i);
                            manager.add(ActionAnalyticsBuilder.action(() -> ChildControlBase.this.openSubSettingsDialog((IChild)subSetting)).id(subSetting.getId()).text(subSetting.getUiName()).enabled(ChildControlBase.this.child.isEnabled()).build());
                            ++i;
                        }
                    }
                });
                subSettingsButtonLoc.setMenu(menuMgr.createContextMenu((Control)subSettingsButtonLoc));
            }
            subSettingsButtonLoc.setVisible(visible);
            subSettingsButtonLoc.setEnabled(enabled);
            Object layoutData = subSettingsButtonLoc.getLayoutData();
            if (layoutData instanceof GridDataComponents) {
                GridDataComponents data = (GridDataComponents)layoutData;
                data.exclude = !visible;
            }
            subSettingsButtonLoc.requestLayout();
        }
    }

    protected void createErrorDecoration(@NonNull Control controlToDecorate, int position) {
        ControlDecorationUtils.createErrorDecoration((Control)controlToDecorate, (int)position);
    }

    protected void updateLabelContent(@NonNull Control label, @NonNull IChildControl.UpdateType updateType) {
        boolean enable;
        Label labelControlLoc;
        if (label instanceof Composite && (labelControlLoc = this.labelControlInternal) != null) {
            String settingName = this.getChild().getUiName().replace(AMPERSAND, AMPERSAND_REPLACEMENT);
            if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
                labelControlLoc.setText(settingName);
                if (this.getControlOptions().isLabelBold()) {
                    this.setLabelInternalFontStyle(1);
                }
                Object compositeLayoutData = label.getLayoutData();
                Object labelLayoutData = labelControlLoc.getLayoutData();
                if (compositeLayoutData != null && labelLayoutData != null) {
                    ((GridDataComponents)labelLayoutData).maxWidth = ((GridDataComponents)compositeLayoutData).maxWidth;
                }
            }
            this.updateErrorDecoration((Control)labelControlLoc);
            this.updateDocumentationButton();
        }
        boolean bl = enable = !IChildControl.UpdateType.FORCE_DISABLE.equals((Object)updateType);
        if (this.expandGroupButton != null) {
            this.expandGroupButton.setEnabled(enable);
        }
    }

    protected void updateLabelInternalTooltip(@Nullable String tooltip) {
        Label labelControlInternalLoc = this.labelControlInternal;
        if (labelControlInternalLoc != null && !labelControlInternalLoc.isDisposed()) {
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)labelControlInternalLoc, tooltip);
        }
    }

    protected void setLabelInternalFontStyle(int style) {
        Label labelControlInternalLoc = this.labelControlInternal;
        if (labelControlInternalLoc != null && !labelControlInternalLoc.isDisposed()) {
            FontFactory.changeStyle((Control)labelControlInternalLoc, (int)style);
        }
    }

    protected void updateLabelEnableAndVisibleState(boolean enabled, boolean visible) {
        Label labelControlInternalLoc;
        Control labelControlLoc = this.labelControl;
        if (labelControlLoc != null && !labelControlLoc.isDisposed()) {
            labelControlLoc.setVisible(visible);
            boolean bl = ((GridDataComponents)Objects.requireNonNull(labelControlLoc.getLayoutData())).exclude = !visible;
        }
        if ((labelControlInternalLoc = this.labelControlInternal) != null && !labelControlInternalLoc.isDisposed()) {
            if (labelControlInternalLoc.getEnabled() != enabled) {
                labelControlInternalLoc.setEnabled(enabled);
            }
            labelControlInternalLoc.setVisible(visible);
        }
    }

    protected void updateMainContent(@NonNull Control contentControl, @NonNull IChildControl.UpdateType updateType) {
        if (contentControl instanceof Text && updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            ((ReadOnlyText)contentControl).setText(this.child.getUiName());
        }
        this.updateErrorDecoration(contentControl);
    }

    @Override
    public void dispose() {
        Control mainControlLoc;
        Control labelControlLoc = this.labelControl;
        if (labelControlLoc != null) {
            labelControlLoc.dispose();
        }
        if ((mainControlLoc = this.mainControl) != null) {
            mainControlLoc.dispose();
        }
        this.labelControl = null;
        this.mainControl = null;
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public @NonNull IChild getChild() {
        return this.child;
    }

    @Override
    public @Nullable Composite getContent() {
        return this.parent;
    }

    public @Nullable Control createLabelControl(@NonNull Composite composite) {
        Composite labelComposite = new Composite(composite, 0);
        GridLayoutComponents layout = new GridLayoutComponents(this.getLabelCompositeColumnCount(), false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        labelComposite.setLayout((Layout)layout);
        if (this.isCollapsible() && !this.getControlOptions().isExpandGroupHidden()) {
            this.createCollapseButton(labelComposite);
        }
        this.createSubSettingsButton(labelComposite);
        this.createLabelControlInternal(labelComposite);
        this.createQuickSolverButton(labelComposite);
        this.createDocumentationLinkButton(labelComposite);
        this.createLabelControlAdditionalControls(labelComposite);
        return labelComposite;
    }

    @Override
    public boolean isCollapsible() {
        if (!this.getControlOptions().isCollapseSettingSpecified()) {
            return IChildControl.super.isCollapsible();
        }
        Object optionValue = this.getControlOptions().getCollapseSettingTarget();
        if (optionValue instanceof String) {
            if (this.collapseSettingOptionIsAllowed((String)optionValue)) {
                return true;
            }
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format(COLLAPSE_SETTING_TARGET_ERROR_MESSAGE, this.getChild().getId(), this.getChild().getComponentId()));
            return false;
        }
        if (optionValue instanceof StructConfig || optionValue instanceof SetConfig) {
            return true;
        }
        return IChildControl.super.isCollapsible();
    }

    private boolean collapseSettingOptionIsAllowed(String siblingControlId) {
        ChildControlBase siblingWithId = this.getSiblingWithId(siblingControlId);
        return siblingWithId instanceof StructControl;
    }

    private Control getExpandGroupContent() {
        if (!this.getControlOptions().isCollapseSettingSpecified()) {
            return this.mainControl;
        }
        return this.getCollapseSettingTargetControl();
    }

    private Control getCollapseSettingTargetControl() {
        Object optionValue = this.getControlOptions().getCollapseSettingTarget();
        String fullId = null;
        if (optionValue instanceof String) {
            fullId = (String)optionValue;
        } else if (optionValue instanceof StructConfig) {
            fullId = ((StructConfig)optionValue).getId();
        } else {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format(COLLAPSE_SETTING_TARGET_ERROR_MESSAGE, this.getChild().getId(), this.getChild().getComponentId()));
            return null;
        }
        ChildControlBase sibling = this.getSiblingWithId(fullId);
        if (sibling == null) {
            return null;
        }
        return sibling.getMainControl();
    }

    protected int getLabelCompositeColumnCount() {
        return 5;
    }

    protected void createLabelControlAdditionalControls(@NonNull Composite composite) {
    }

    protected void createLabelControlInternal(Composite composite) {
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)new GridDataComponents(4, 0x1000000, false, false, 1, 1));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)label, "periphsSettLabel_" + this.child.getId());
        label.setText(this.child.getUiName().replaceAll(AMPERSAND, AMPERSAND_REPLACEMENT));
        ControlDecorationUtils.createErrorDecoration((Control)label, (int)16512);
        this.labelControlInternal = label;
    }

    protected void createQuickSolverButton(Composite composite) {
        Label quickSolverButtonLoc = new Label(composite, 0);
        GridDataComponents quickSolverLayoutData = new GridDataComponents();
        quickSolverLayoutData.exclude = true;
        quickSolverButtonLoc.setVisible(false);
        quickSolverButtonLoc.setLayoutData((Object)quickSolverLayoutData);
        this.quickSolverButton = quickSolverButtonLoc;
    }

    protected void createDocumentationLinkButton(Composite composite) {
        Label button = new Label(composite, 0);
        GridDataComponents layoutData = new GridDataComponents();
        button.setLayoutData((Object)layoutData);
        button.setImage(ToolsImages.getImage((String)"icons/question_mark.png"));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "periphsOpenDocumentationLinkFromSetting_" + this.getChild().getId());
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ConfigurationComponentTypeId targetTypeId;
                String page = ChildControlBase.this.getControlOptions().getDocumentationPageToOpen();
                if (page == null) {
                    return;
                }
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow == null) {
                    return;
                }
                IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
                IComponentInstanceConfig instance = ChildControlBase.this.getChild().getChildContext().getComponentInstanceConfig();
                if (instance == null) {
                    return;
                }
                String componentType = instance.getComponentTypeId();
                String pageInComponent = page;
                int separatorPosition = page.indexOf("::");
                if (separatorPosition != -1 && (targetTypeId = DocumentationView.getTargetTypeId(page, ChildControlBase.this.controllerWrapper)) != null) {
                    componentType = targetTypeId.getTypeId();
                    pageInComponent = page.substring(separatorPosition + 2);
                }
                DocumentationView.open(workbenchPage, componentType, true);
                DocumentationView.openPage(pageInComponent);
            }
        });
        this.documentationLinkButton = button;
    }

    protected void updateDocumentationButton() {
        Label button = this.documentationLinkButton;
        if (button != null) {
            Object data;
            String pageName;
            String page;
            boolean documentationPageToOpenSpecified = this.getControlOptions().isDocumentationPageToOpenSpecified();
            button.setVisible(documentationPageToOpenSpecified);
            if (documentationPageToOpenSpecified && (page = this.getControlOptions().getDocumentationPageToOpen()) != null && (pageName = DocumentationViewHelper.getNameOfPage(this.getChild(), page)) != null) {
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, MessageFormat.format(Messages.get().ComponentSettingView_DocumentationViewPage, pageName));
            }
            if ((data = button.getLayoutData()) instanceof GridDataComponents) {
                GridDataComponents layoutData = (GridDataComponents)data;
                layoutData.exclude = !documentationPageToOpenSpecified;
            }
        }
    }

    protected void createCollapseButton(Composite composite) {
        boolean visible;
        boolean bl = visible = !this.getControlOptions().isGroupCollapsed();
        if (CollapsibleSettingsStorageHelper.getInstance().isStored(this)) {
            visible = CollapsibleSettingsStorageHelper.getInstance().isExpanded(this);
        }
        final Label expandGroupButtonLoc = new Label(composite, 0);
        expandGroupButtonLoc.setVisible(true);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)expandGroupButtonLoc, Messages.get().ComponentSettingView_ExpandCollapseButton);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)expandGroupButtonLoc, "periphsCollapseSettLabel_" + this.getChild().getId());
        GridDataComponents gd = new GridDataComponents(16384, 0x1000000, false, false);
        expandGroupButtonLoc.setLayoutData((Object)gd);
        if (!visible) {
            expandGroupButtonLoc.setImage(ToolsImages.getImage((String)"icons/right.png"));
        } else {
            expandGroupButtonLoc.setImage(ToolsImages.getImage((String)"icons/down.png"));
        }
        this.expandGroupVisible = visible;
        this.saveExpandedState();
        expandGroupButtonLoc.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Control expandGroupLocal;
                super.mouseUp(e);
                if (ChildControlBase.this.getControlOptions().isCollapseSettingSpecified() && ChildControlBase.this.expandGroupContent == null) {
                    ChildControlBase.this.expandGroupContent = ChildControlBase.this.getExpandGroupContent();
                }
                if ((expandGroupLocal = ChildControlBase.this.expandGroupContent) != null && !expandGroupLocal.isDisposed()) {
                    boolean bl = ChildControlBase.this.expandGroupVisible = !ChildControlBase.this.expandGroupVisible;
                    if (KEPreferences.isAnimationsEnabled()) {
                        ChildControlBase.this.setControlVisibleAnimation(expandGroupLocal, expandGroupButtonLoc, ChildControlBase.this.expandGroupVisible);
                    } else {
                        ChildControlBase.this.setControlVisible(expandGroupLocal, ChildControlBase.this.expandGroupVisible);
                        ChildControlBase.this.updateLayout();
                        ChildControlBase.this.onExpandGroupVisibilityChange();
                        ChildControlBase.this.saveExpandedState();
                    }
                    if (ChildControlBase.this.expandGroupVisible) {
                        expandGroupButtonLoc.setImage(ToolsImages.getImage((String)"icons/down.png"));
                    } else {
                        expandGroupButtonLoc.setImage(ToolsImages.getImage((String)"icons/right.png"));
                    }
                }
            }
        });
        this.expandGroupButton = expandGroupButtonLoc;
    }

    private @Nullable Control getMainControl() {
        return this.mainControl;
    }

    private @Nullable ChildControlBase getSiblingWithId(String siblingId) {
        IChildControl parentChildControlLoc = this.parentChildControl;
        if (!(parentChildControlLoc instanceof ChildProvidableControlBase)) {
            LOGGER.log(Level.SEVERE, String.format("The parent of setting: %1s was not structured setting. The parent setting must be ConfigSet, Set or Struct.", this.getChild()));
            return null;
        }
        for (IChildControl childControl : ((ChildProvidableControlBase)parentChildControlLoc).getChildren()) {
            if (!(childControl instanceof ChildControlBase) || !Objects.equals(childControl.getChild().getId(), siblingId)) continue;
            return (ChildControlBase)childControl;
        }
        LOGGER.log(Level.SEVERE, String.format("The provided setting id value in COLLAPSE_OPTION option of setting: %1s was not found among siblings of the setting. Please use valid Full ID.", this.getChild()));
        return null;
    }

    private void saveExpandedState() {
        if (this.isExpandGroupVisible()) {
            CollapsibleSettingsStorageHelper.getInstance().expandControl(this);
        } else {
            CollapsibleSettingsStorageHelper.getInstance().collapseControl(this);
        }
    }

    protected boolean isExpandGroupVisible() {
        return this.expandGroupVisible;
    }

    protected void onExpandGroupVisibilityChange() {
    }

    protected void createSubSettingsButton(Composite composite) {
        Label subSettingsButtonLoc = new Label(composite, 0);
        GridDataComponents buttonGridData = new GridDataComponents(16384, 1024, false, false);
        buttonGridData.exclude = true;
        subSettingsButtonLoc.setVisible(false);
        subSettingsButtonLoc.setLayoutData((Object)buttonGridData);
        subSettingsButtonLoc.setImage(ToolsImages.getImage((String)"icons/settings.png"));
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)subSettingsButtonLoc, Messages.get().ToolTip_SubSettingsButton);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)subSettingsButtonLoc, "periphsSubSettingsIcon" + this.child.getId());
        this.subSettingsButton = subSettingsButtonLoc;
    }

    public @Nullable Control createMainControl(@NonNull Composite composite) {
        Text text = new Text(composite, this.getSwtStyle() | 8 | 0x40);
        text.setText(this.child.getUiName());
        return text;
    }

    protected @NonNull List<@NonNull ISettingConfig> getSubSettingsChildren() {
        List relatedSettings;
        List<@NonNull Object> childSubSettings = new ArrayList<ISettingConfig>();
        Object optionValue = this.child.getOptionValue("RELATED_SETTINGS");
        if (optionValue != null) {
            if (optionValue instanceof List) {
                List settings = (List)optionValue;
                for (Object obj : settings) {
                    if (obj instanceof ISettingConfig) {
                        childSubSettings.add((ISettingConfig)obj);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, MessageFormat.format("The received item is not an instance of \"{0}\"", ISettingConfig.class.getName()));
                }
            } else {
                LOGGER.log(Level.SEVERE, String.format("The current type is not supported for RELATED_SETTINGS option of setting: %1s. Only the array setting instances are supported.", this.getChild()));
            }
        } else if (this.child.isOptionSet("RELATED_SETTINGS_AUTO") && this.child instanceof ISettingConfig && (relatedSettings = ((ISettingConfig)this.child).getAllRelatedSettings()) != null) {
            childSubSettings = relatedSettings;
        }
        return childSubSettings;
    }

    protected void openSubSettingsDialog(@NonNull IChild subSetting) {
        Shell activeShell;
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null && (activeShell = currentDisplay.getActiveShell()) != null) {
            SubSettingsDialog diag;
            this.activeSubSettingDialog = diag = new SubSettingsDialog(activeShell, subSetting, this.controllerWrapper, new ControlOptions(subSetting));
            diag.open();
        }
    }

    public int getSwtStyle() {
        return ChildControlBase.getSwtStyle(this);
    }

    public static int getSwtStyle(@NonNull IChildControl childControl) {
        if (childControl.getControlOptions().isBorderHidden()) {
            return 0;
        }
        return 2048;
    }

    public static @Nullable Image getStatusIcon(@NonNull IChild element) {
        if (element.getError() != null) {
            return ToolsImages.getStatusIcon((int)2);
        }
        if (element.getWarning() != null) {
            return ToolsImages.getStatusIcon((int)1);
        }
        if (element.getInfo() != null) {
            return ToolsImages.getStatusIcon((int)0);
        }
        return null;
    }

    @Override
    public @NonNull ControlOptions getControlOptions() {
        return this.controlOptions;
    }

    public static void addScrollListener(@NonNull Control control, final @NonNull Composite childOfScrolledComposite) {
        control.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                ScrolledCompositeHelper.scrollByNumberOfLines((Composite)childOfScrolledComposite, (int)(-event.count), (int)-1);
            }
        });
    }

    protected void registerCopyPasteMenuOnLabel() {
        Label labelControlLoc = this.labelControlInternal;
        if (labelControlLoc != null) {
            this.registerCopyPasteMenu((Control)labelControlLoc);
        }
    }

    protected void registerCopyPasteMenu(@NonNull Control control) {
        ISettingConfig setting = null;
        if (this.getChild() instanceof ISettingConfig) {
            ISettingConfig finalSetting = setting = (ISettingConfig)this.getChild();
            control.setMenu(this.createCopyPasteMenu(control, finalSetting));
        }
    }

    protected Menu createCopyPasteMenu(@NonNull Control control, @NonNull ISettingConfig setting) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menu -> {
            Clipboard clipBoard = new Clipboard(control.getDisplay());
            menu.add(this.copyAction(setting, clipBoard));
            menu.add(this.pasteAction(setting, clipBoard));
            if (setting instanceof ArrayConfig) {
                ArrayConfig finalArray = (ArrayConfig)setting;
                menu.add(this.pasteAsNewItemAction(finalArray, clipBoard));
            }
        });
        return menuMgr.createContextMenu(control);
    }

    private @NonNull IAction pasteAsNewItemAction(ArrayConfig finalArray, Clipboard clipBoard) {
        Object clipboardContent = clipBoard.getContents((Transfer)TextTransfer.getInstance());
        String clipboardString = clipboardContent instanceof String ? (String)clipboardContent : "";
        return ActionAnalyticsBuilder.action(() -> {
            this.controllerWrapper.getController().pasteAsNewItem(finalArray, clipboardString);
            clipBoard.setContents(new Object[]{" "}, new Transfer[]{TextTransfer.getInstance()});
        }).id("periphsChildControlPasteAsNewItem").text(Messages.get().ChildControl_Paste_AsNewItem).image(ToolsImages.getImageDescriptor((String)"icons/copy.png")).enabled(this.controllerWrapper.getController().canPasteAsNewItem(finalArray, clipboardString)).build();
    }

    private @NonNull IAction pasteAction(ISettingConfig setting, Clipboard clipBoard) {
        Object clipboardContent = clipBoard.getContents((Transfer)TextTransfer.getInstance());
        String clipboardString = clipboardContent instanceof String ? (String)clipboardContent : "";
        return ActionAnalyticsBuilder.action(() -> {
            this.controllerWrapper.getController().paste(setting, clipboardString);
            clipBoard.setContents(new Object[]{" "}, new Transfer[]{TextTransfer.getInstance()});
        }).id("periphsChildControlPaste").text(Messages.get().ChildControl_Paste).image(ToolsImages.getImageDescriptor((String)"icons/copy.png")).enabled(this.controllerWrapper.getController().canPaste(setting, clipboardString)).build();
    }

    private @NonNull IAction copyAction(ISettingConfig setting, Clipboard clipBoard) {
        return ActionAnalyticsBuilder.action(() -> {
            String stringCopyResult = this.controllerWrapper.getController().copy(setting);
            if (UtilsText.isEmpty((String)stringCopyResult)) {
                LOGGER.log(Level.SEVERE, "Copy did not produce String for the clipboard");
                return;
            }
            clipBoard.setContents(new Object[]{stringCopyResult}, new Transfer[]{TextTransfer.getInstance()});
        }).id("periphsChildControlCopy").text(Messages.get().ChildControl_Copy).image(ToolsImages.getImageDescriptor((String)"icons/copy.png")).enabled(this.controllerWrapper.getController().canCopy(setting)).build();
    }

    protected void setControlVisible(@NonNull Control control, boolean visible) {
        Object data = control.getLayoutData();
        if (data instanceof GridDataComponents) {
            GridDataComponents layoutData = (GridDataComponents)data;
            layoutData.exclude = !visible;
            control.setVisible(visible);
        }
    }

    protected void setControlVisibleAnimation(@NonNull Control control, final @Nullable Label button, final boolean visible) {
        int height;
        Point optimalSize = control.computeSize(-1, -1);
        int duration = this.countDuration(optimalSize.y);
        if (!visible) {
            height = 0;
        } else {
            Object data = control.getLayoutData();
            if (data instanceof GridDataComponents) {
                GridDataComponents layoutData = (GridDataComponents)data;
                layoutData.exclude = !visible;
            }
            this.updateLayout();
            height = optimalSize.y;
        }
        control.getDisplay().asyncExec(() -> {
            if (!control.isDisposed()) {
                if (visible) {
                    control.setSize(control.getSize().x, 0);
                }
                SizeChanger sizeChanger = new SizeChanger(control, control.getSize().x, height, false, EaseSelector.SINE){

                    public void animationStartCallback() {
                        if (button != null) {
                            button.setEnabled(false);
                        }
                        if (visible) {
                            this.control.getDisplay().asyncExec(() -> {
                                this.control.setVisible(visible);
                                ChildControlBase.this.onExpandGroupVisibilityChange();
                                ChildControlBase.this.saveExpandedState();
                            });
                        }
                    }

                    public void animationDoneCallback() {
                        if (button != null) {
                            button.setEnabled(true);
                        }
                        if (!visible) {
                            ChildControlBase.this.setControlVisible(this.control, visible);
                            ChildControlBase.this.updateLayout();
                        }
                        ChildControlBase.this.onExpandGroupVisibilityChange();
                        ChildControlBase.this.saveExpandedState();
                    }
                };
                sizeChanger.play(duration);
            }
        });
    }

    private int countDuration(int height) {
        Display display = Display.getCurrent();
        if (display != null) {
            height = height * 100 / display.getDPI().y;
        }
        if (height > 1) {
            int duration = (int)Math.log(height) * 140;
            if (duration < 500) {
                return 500;
            }
            if (duration > 1000) {
                return 1000;
            }
            return duration;
        }
        return 500;
    }

    protected void updateLayout() {
        Composite parentLoc = this.parent;
        if (parentLoc != null) {
            ScrolledCompositeHelper.updateScrollSize((Composite)parentLoc);
            parentLoc.requestLayout();
            Composite parentComposite = parentLoc.getParent();
            if (parentComposite != null) {
                parentComposite.layout();
            }
        }
    }

    protected void setControlEnabled(@NonNull Control control, boolean enabled, boolean recursive) {
        if (recursive && control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                this.setControlEnabled(childControl, enabled, recursive);
                ++n2;
            }
        }
        if (control.getEnabled() != enabled) {
            control.setEnabled(enabled);
        }
    }

    protected void setParentControlEnabled(@Nullable Composite composite, boolean enabled) {
        if (composite != null) {
            Composite compositeParent;
            if (composite.getEnabled() != enabled) {
                composite.setEnabled(enabled);
            }
            if ((compositeParent = composite.getParent()) != null && compositeParent.isEnabled() != enabled) {
                this.setParentControlEnabled(compositeParent, enabled);
            }
        }
    }

    @Override
    public void setParentControl(IChildControl parentChildControl) {
        this.parentChildControl = parentChildControl;
    }

    public @Nullable IChildControl getParentChildControl() {
        return this.parentChildControl;
    }

    public @NonNull IChildControl.UpdateType getControlUpdateType() {
        return this.controlUpdateType;
    }

    protected void handleLinkToSetting(IChild linkedChild, @NonNull Object caller) {
        IComponentConfig componentConfig = linkedChild.getChildContext().getComponentConfig();
        if (componentConfig != null) {
            IConfigSetConfig globalConfigSet = componentConfig.getGlobalConfigSet();
            IConfigSetConfig configSetConfig = linkedChild.getChildContext().getConfigSetConfig();
            if (globalConfigSet != null && configSetConfig == globalConfigSet) {
                this.controllerWrapper.getGUIController().openGlobalViewOfChild(linkedChild);
            } else {
                IFunctionalGroup functionalGroup = linkedChild.getChildContext().getFunctionalGroup();
                if (functionalGroup == null) {
                    return;
                }
                this.controllerWrapper.getController().setFunctionalGroup(functionalGroup, true, caller);
                this.controllerWrapper.getGUIController().openViewOfChild(linkedChild);
            }
        }
    }

    private String updateToolTipWithSyncDetail(@NonNull String tooltip) {
        StringBuilder result = new StringBuilder(tooltip);
        if (this.getChild().isSynchronizationEnabled()) {
            if (result.length() > 0) {
                result.append("<br/>");
                result.append("<br/>");
            }
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipableFormater_SyncValue));
        }
        return result.toString();
    }
}

