/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.ConfigurationComponentUtils;
import com.nxp.swtools.periphs.controller.MigrationHelper;
import com.nxp.swtools.periphs.controller.MigrationMessage;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.periphs.model.data.ComputeScoreWrapper;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Version;

@NonNullByDefault
public class MigrationOfferDialog
extends Dialog {
    private static final int OFFERED_MIGRATION_LABELS_OFFSET = 1;
    public static final String DO_NOT_MIGRATE_ITEM_LABEL = "Do not migrate";
    public static final List<String> DEFAULT_MIGRATION_COMBO_ITEMS = Arrays.asList("Do not migrate");
    private static final Logger LOGGER = LogManager.getLogger(MigrationOfferDialog.class);
    final Shell shell;
    final IControllerWrapper controllerWrapper;
    @Nullable
    private Button migrateButton;
    private List<IChildProvidable> result = Collections.emptyList();
    Map<ConfigurationComponentTypeId, InstantSearchList> replacementComboboxes = new HashMap<ConfigurationComponentTypeId, InstantSearchList>();
    Map<ConfigurationComponentTypeId, Button> rejectionCheckBoxes = new HashMap<ConfigurationComponentTypeId, Button>();
    private Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> offeredComponents = new LinkedHashMap<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>>();
    private boolean showAllComponents = false;

    private MigrationOfferDialog(Shell shell, IControllerWrapper controllerWrapper) {
        super(shell);
        this.shell = shell;
        this.controllerWrapper = controllerWrapper;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        dialogComposite.setLayout((Layout)new GridLayout());
        this.createComponentsList(dialogComposite, this.getOfferedComponents());
        return dialogComposite;
    }

    private void createComponentsList(Composite parent, Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> components) {
        Composite rowComposite = new Composite(parent, 0);
        rowComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        rowComposite.setLayout((Layout)new GridLayout(5, false));
        if (!MigrationOfferDialog.isToolchainProjectDetected()) {
            Label warningImage = new Label(rowComposite, 0);
            warningImage.setImage(ToolsImages.getStatusIcon((int)1));
            warningImage.setLayoutData((Object)new GridData(16384, 128, false, true, 1, 1));
            Label warningLabel = new Label(rowComposite, 64);
            GridData layoutData = new GridData(0x1000000, 128, false, true, 4, 1);
            layoutData.widthHint = 300;
            warningLabel.setLayoutData((Object)layoutData);
            warningLabel.setText(Messages.get().OpenMigrationOfferDialogHandler_Warning);
        }
        Label permanentIgnoreLabel = new Label(rowComposite, 0);
        permanentIgnoreLabel.setLayoutData((Object)new GridData(131072, 128, true, true, 5, 1));
        permanentIgnoreLabel.setText(Messages.get().MigrationOfferDialog_IgnoreColumnLabel);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)permanentIgnoreLabel, Messages.get().MigrationOfferDialog_IgnoreColumnTooltip);
        Set rejectedComponents = MigrationHelper.getIgnoredComponents((APeriphController)this.controllerWrapper.getController());
        for (Map.Entry<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> pair : components.entrySet()) {
            ConfigurationComponentTypeId currentComponentTypeId = pair.getKey();
            IConfigurationComponent currentComponent = currentComponentTypeId.getConfigurationComponent();
            boolean isRejected = rejectedComponents.contains(currentComponent.getId());
            List<ConfigurationComponentTypeId> newComponents = pair.getValue();
            List sdkComponents = currentComponent.getComponents();
            String currentVersionLabelString = sdkComponents.isEmpty() ? "" : ((SWComponent)sdkComponents.get(0)).getVersionStr();
            String currentComponentName = UtilsText.safeString((String)currentComponent.getUINameString());
            List<String> items = MigrationOfferDialog.getMigrationComboItems(newComponents);
            int defaultItemIndex = this.getDefaultSelectionIndex(newComponents);
            String selectedItem = items.get(defaultItemIndex);
            boolean isEnabled = true;
            if (isRejected) {
                selectedItem = DO_NOT_MIGRATE_ITEM_LABEL;
                isEnabled = false;
            }
            String comboTestId = "periphsMigrationCombo_" + currentComponentName;
            String checkBoxTestId = "periphsMigrationPermanentIgnoreCheckbox_" + currentComponentName;
            MigrationOfferDialog.createLabelOfCurrentRow(rowComposite, currentVersionLabelString, currentComponentName);
            MigrationOfferDialog.createRightArrowWidget(rowComposite);
            InstantSearchList combo = this.createMigrationCombo(rowComposite, newComponents);
            MigrationOfferDialog.updateMigrationCombo(combo, selectedItem, isEnabled, comboTestId);
            this.replacementComboboxes.put(currentComponentTypeId, combo);
            Button permanentIgnoreCheckbox = MigrationOfferDialog.createIgnoreCheckbox(rowComposite, MigrationOfferDialog.getIgnoreCheckboxSelectionListener(combo));
            MigrationOfferDialog.updateIgnoreCheckbox(permanentIgnoreCheckbox, isRejected, checkBoxTestId);
            this.rejectionCheckBoxes.put(currentComponentTypeId, permanentIgnoreCheckbox);
        }
    }

    private int getDefaultSelectionIndex(List<ConfigurationComponentTypeId> componentsInCombobox) {
        if (!MigrationOfferDialog.isToolchainProjectDetected()) {
            return 0;
        }
        int defaultItemIndex = 0;
        int i = 0;
        while (i < componentsInCombobox.size()) {
            boolean componentFitsToolchainProject;
            boolean bl = componentFitsToolchainProject = this.getWarning(componentsInCombobox.get(i)) == null;
            if (componentFitsToolchainProject) {
                defaultItemIndex = i + DEFAULT_MIGRATION_COMBO_ITEMS.size();
                break;
            }
            ++i;
        }
        return defaultItemIndex;
    }

    private static List<String> getMigrationComboItems(List<ConfigurationComponentTypeId> components) {
        ArrayList<String> items = new ArrayList<String>(DEFAULT_MIGRATION_COMBO_ITEMS.size() + components.size());
        items.addAll(DEFAULT_MIGRATION_COMBO_ITEMS);
        for (ConfigurationComponentTypeId component : components) {
            items.add(MigrationOfferDialog.formatMigrationComboItem(component));
        }
        return items;
    }

    private static String formatMigrationComboItem(ConfigurationComponentTypeId component) {
        StringBuilder builder = new StringBuilder();
        builder.append(component.getConfigurationComponent().getUINameString());
        String info = ConfigurationComponentUtils.buildDriverDependencyInfo((ConfigurationComponentTypeId)component, (boolean)true);
        if (!info.isEmpty()) {
            builder.append("<");
            builder.append(info);
            builder.append(">");
        }
        return builder.toString();
    }

    private static SelectionAdapter getIgnoreCheckboxSelectionListener(final InstantSearchList combo) {
        return new SelectionAdapter(){

            public void widgetSelected(@NonNull SelectionEvent e) {
                Widget widget = e.widget;
                if (!(widget instanceof Button)) {
                    return;
                }
                Button checkbox = (Button)widget;
                boolean ignore = checkbox.getSelection();
                if (ignore) {
                    combo.setEnabled(false);
                    combo.setText(MigrationOfferDialog.DO_NOT_MIGRATE_ITEM_LABEL);
                } else {
                    combo.setEnabled(true);
                }
            }
        };
    }

    private static void updateIgnoreCheckbox(Button checkbox, boolean isSelected, String testId) {
        SWTFactoryProxy.INSTANCE.setTestId((Widget)checkbox, testId);
        checkbox.setSelection(isSelected);
    }

    private static Button createIgnoreCheckbox(Composite composite, SelectionAdapter selectionListener) {
        Button permanentIgnoreCheckbox = new Button(composite, 32);
        permanentIgnoreCheckbox.addSelectionListener((SelectionListener)selectionListener);
        permanentIgnoreCheckbox.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        return permanentIgnoreCheckbox;
    }

    private static void updateMigrationCombo(InstantSearchList combo, String selectedItem, boolean isEnabled, String testId) {
        combo.setText(selectedItem);
        combo.setEnabled(isEnabled);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, testId);
    }

    private InstantSearchList createMigrationCombo(Composite composite, List<ConfigurationComponentTypeId> items) {
        InstantSearchList combo = new InstantSearchList(composite, 2048);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        final LinkedHashMap<String, ConfigurationComponentTypeId> itemNamesPair = new LinkedHashMap<String, ConfigurationComponentTypeId>();
        for (ConfigurationComponentTypeId item : items) {
            itemNamesPair.put(MigrationOfferDialog.formatMigrationComboItem(item), item);
        }
        ArrayList<String> itemNames = new ArrayList<String>();
        itemNames.add(DO_NOT_MIGRATE_ITEM_LABEL);
        itemNames.addAll(itemNamesPair.keySet());
        combo.setItems(itemNames.toArray(new String[itemNames.size()]));
        for (Map.Entry key : itemNamesPair.entrySet()) {
            combo.addItemToolTip((String)key.getKey(), this.getWarning((ConfigurationComponentTypeId)key.getValue()));
        }
        combo.setStatusItemProvider(new InstantSearchList.IStatusProvider(){

            public @Nullable Image getItemImage(String itemValue) {
                if (MigrationOfferDialog.DO_NOT_MIGRATE_ITEM_LABEL.equals(itemValue)) {
                    return null;
                }
                if (itemNamesPair.containsKey(itemValue) && MigrationOfferDialog.this.showWarning((ConfigurationComponentTypeId)itemNamesPair.get(itemValue))) {
                    return ToolsImages.getStatusDecoratorImg((int)1);
                }
                return null;
            }
        });
        return combo;
    }

    private boolean showWarning(@Nullable ConfigurationComponentTypeId conf) {
        if (conf == null) {
            return false;
        }
        return this.getWarning(conf) != null;
    }

    private @Nullable String getWarning(ConfigurationComponentTypeId configComp) {
        APeriphController controller = this.controllerWrapper.getController();
        IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        if (toolchainProject == null || !toolchainProject.wasProjectDetected()) {
            return null;
        }
        for (SWComponent swComponent : configComp.getConfigurationComponent().getComponents()) {
            ISdkComponentInProject sdkComponent = toolchainProject.getSdkComponent(swComponent.getName());
            if (sdkComponent == null) {
                return com.nxp.swtools.periphs.controller.Messages.get().Controller_VersionNotSupported;
            }
            Version sdkComponentVersion = sdkComponent.getVersion();
            if (sdkComponentVersion == null) {
                return MessageFormat.format(com.nxp.swtools.periphs.controller.Messages.get().Controller_ProblemComponentWithUnknownVersions, controller.getMcu().getAvailableComponents().getSdkComponentName(swComponent.getName()));
            }
            if (Components.computeMatchScore((ComputeScoreWrapper)ComputeScoreWrapper.from((SWComponent)swComponent), (ComputeScoreWrapper)ComputeScoreWrapper.from((ISdkComponentInProject)sdkComponent), (String)swComponent.getMatchString(), (Version)swComponent.getUntilVersion()) != null) continue;
            return com.nxp.swtools.periphs.controller.Messages.get().Controller_VersionNotSupported;
        }
        return null;
    }

    private static void createRightArrowWidget(Composite composite) {
        Label arrowLabel = new Label(composite, 0);
        arrowLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        arrowLabel.setImage(ToolsImages.getImage((String)"icons/right.png"));
    }

    private static void createLabelOfCurrentRow(Composite composite, String currentVersionLabelString, String currentComponentName) {
        Label currentComponentNameLabel = new Label(composite, 1);
        currentComponentNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        currentComponentNameLabel.setText(currentComponentName);
        FontFactory.changeStyle((Control)currentComponentNameLabel, (int)1);
        Label currentVersionLabel = new Label(composite, 0);
        currentVersionLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        currentVersionLabel.setText(currentVersionLabelString);
    }

    private static boolean isToolchainProjectDetected() {
        IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
        return toolchainProject != null && toolchainProject.wasProjectDetected();
    }

    protected void okPressed() {
        ArrayList<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>> migratedComponents = new ArrayList<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>>();
        boolean migratingToOlderVersion = false;
        for (Map.Entry<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> entry : this.getOfferedComponents().entrySet()) {
            ConfigurationComponentTypeId oldComponentTypeId = entry.getKey();
            ConfigurationComponentTypeId newComponentTypeId = this.getNewConfigurationComponentTypeId(entry.getKey());
            if (newComponentTypeId == null) continue;
            List oldComponents = oldComponentTypeId.getConfigurationComponent().getComponents();
            List newComponents = newComponentTypeId.getConfigurationComponent().getComponents();
            if (oldComponents.isEmpty() || newComponents.isEmpty()) continue;
            Version oldVersion = ((SWComponent)oldComponents.get(0)).getVersion();
            Version newVersion = ((SWComponent)newComponents.get(0)).getVersion();
            if (oldVersion == null || newVersion == null || newVersion.compareTo(oldVersion) >= 0) continue;
            migratingToOlderVersion = true;
            break;
        }
        if (migratingToOlderVersion && !MessageDialog.openQuestion((Shell)this.shell, (String)Messages.get().MigrationOfferDialog_LoweringComponentVersion_Title, (String)Messages.get().MigrationOfferDialog_LoweringComponentVersion_Message)) {
            return;
        }
        boolean savedAnyRejection = this.saveRejectionsOfMigrationOffer(!this.showAllComponents);
        this.controllerWrapper.getController().runTransaction(() -> {
            for (Map.Entry<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> entry : this.getOfferedComponents().entrySet()) {
                List<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>> replacements = this.performMigration(entry.getKey());
                migratedComponents.addAll(replacements);
            }
        });
        if (migratedComponents.isEmpty() && savedAnyRejection) {
            this.controllerWrapper.getController().handleSettingChange(1, MigrationOfferDialog.class, Messages.get().MigrationOfferDialog_SavingRejections_Action, true, null, false);
        }
        Shell shellLoc = this.getShell();
        if (!migratedComponents.isEmpty() && shellLoc != null) {
            this.controllerWrapper.getGUIController().openMigrationReportDialog(shellLoc, MigrationMessage.ShowMode.MANUAL, migratedComponents);
        }
        super.okPressed();
    }

    private @Nullable ConfigurationComponentTypeId getNewConfigurationComponentTypeId(ConfigurationComponentTypeId componentTypeId) {
        InstantSearchList combobox = this.replacementComboboxes.get(componentTypeId);
        if (combobox == null) {
            return null;
        }
        String comboBoxText = combobox.getText();
        if (DO_NOT_MIGRATE_ITEM_LABEL.equals(comboBoxText)) {
            return null;
        }
        int selectedReplacementComponentIndex = combobox.getItems().indexOf(comboBoxText);
        if (selectedReplacementComponentIndex == -1) {
            LOGGER.log(Level.SEVERE, "[TOOL][{0}] Replacement component combobox does not contain the selected value. The component cannot be chosen", componentTypeId.getTypeId());
            return null;
        }
        List<ConfigurationComponentTypeId> replacements = this.getOfferedComponents().get(componentTypeId);
        if (replacements == null) {
            LOGGER.log(Level.SEVERE, "[TOOL][{0}] Cannot find list of replacements for component with typeId:", componentTypeId.getTypeId());
            return null;
        }
        int indexOfNewComponentTypeId = selectedReplacementComponentIndex - 1;
        if (indexOfNewComponentTypeId >= replacements.size()) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL][{0}] Cannot migrate to component typeId with selected index {1} since such index does not exist in the migration offer map", componentTypeId.getTypeId(), String.valueOf(indexOfNewComponentTypeId)));
            return null;
        }
        return replacements.get(indexOfNewComponentTypeId);
    }

    private List<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>> performMigration(ConfigurationComponentTypeId componentTypeId) {
        ConfigurationComponentTypeId newTypeId = this.getNewConfigurationComponentTypeId(componentTypeId);
        if (newTypeId == null) {
            return Collections.emptyList();
        }
        List instances = this.controllerWrapper.getController().getProfile().getAllInstances(componentTypeId.getType());
        ArrayList<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>> migratedPairs = new ArrayList<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>>();
        for (IComponentInstanceConfig instance : instances) {
            IComponentInstanceConfig newInstance = MigrationHelper.migrate((IComponentInstanceConfig)instance, (ConfigurationComponentTypeId)newTypeId, (APeriphController)this.controllerWrapper.getController(), MigrationOfferDialog.class);
            if (newInstance == null) continue;
            migratedPairs.add((CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>)new CollectionsUtils.Pair((Object)newInstance, (Object)instance));
        }
        return migratedPairs;
    }

    private boolean saveRejectionsOfMigrationOffer(boolean includePrevious) {
        Set previouslyIgnoredComponents = MigrationHelper.getIgnoredComponents((APeriphController)this.controllerWrapper.getController());
        HashSet<String> newIgnoredComponents = new HashSet<String>();
        for (Map.Entry<ConfigurationComponentTypeId, Button> entry : this.rejectionCheckBoxes.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            newIgnoredComponents.add(entry.getKey().getType());
        }
        if (includePrevious) {
            newIgnoredComponents.addAll(previouslyIgnoredComponents);
        }
        MigrationHelper.addIgnoredComponents((APeriphController)this.controllerWrapper.getController(), newIgnoredComponents);
        return !CollectionsUtils.difference((Collection)previouslyIgnoredComponents, newIgnoredComponents, new ArrayList(), new ArrayList());
    }

    private static boolean shouldMigrationsBeOffered(IControllerWrapper wrapper) {
        if (!KEPreferences.areComponentMigrationsAllowed()) {
            return false;
        }
        return !MigrationHelper.getListOfComponentUpgrades((APeriphController)wrapper.getController(), (boolean)false).isEmpty();
    }

    public static boolean canDialogBeOpened(IControllerWrapper wrapper) {
        if (!KEPreferences.areComponentMigrationsAllowed()) {
            return false;
        }
        return !MigrationHelper.getListOfComponentUpgrades((APeriphController)wrapper.getController(), (boolean)true).isEmpty();
    }

    public static boolean shouldMigrationOfferDialogopenAutomatically(IControllerWrapper wrapper) {
        if (!MigrationOfferDialog.isToolchainProjectDetected()) {
            return false;
        }
        return MigrationOfferDialog.shouldMigrationsBeOffered(wrapper);
    }

    private void fillWithAllComponentsUpgrades() {
        this.fillOfferedComponentsList(MigrationHelper.getListOfComponentUpgrades((APeriphController)this.controllerWrapper.getController(), (boolean)this.showAllComponents));
    }

    private void fillOfferedComponentsList(Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> componentsToBeOffered) {
        this.offeredComponents.clear();
        this.offeredComponents.putAll(componentsToBeOffered);
    }

    private Map<ConfigurationComponentTypeId, List<ConfigurationComponentTypeId>> getOfferedComponents() {
        return this.offeredComponents;
    }

    public static MigrationOfferDialog open(Shell shell, IControllerWrapper controllerWrapper) {
        return MigrationOfferDialog.open(shell, controllerWrapper, false);
    }

    public static MigrationOfferDialog open(Shell shell, IControllerWrapper controllerWrapper, boolean showAllComponents) {
        MigrationOfferDialog dialog = new MigrationOfferDialog(shell, controllerWrapper);
        dialog.setBlockOnOpen(true);
        dialog.setShowAllComponents(showAllComponents);
        dialog.fillWithAllComponentsUpgrades();
        dialog.open();
        return dialog;
    }

    private void setShowAllComponents(boolean showAllComponents) {
        this.showAllComponents = showAllComponents;
    }

    protected void cancelPressed() {
        this.close();
    }

    public List<IChildProvidable> getResult() {
        return this.result;
    }

    void setResult(List<IChildProvidable> result) {
        this.result = result;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().MigrationOfferDialog_DialogTitle);
        this.setShellStyle(32);
    }

    protected boolean isResizable() {
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.migrateButton = this.createButton(parent, 0, Messages.get().ComponentsView_MigrateComponentDialog_OK, true);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.migrateButton, "periphsMigrateCompInstShellOkBtn");
        this.createButton(parent, 1, com.nxp.swtools.common.ui.utils.Messages.get().MessageBoxDialog_Cancel, false);
    }
}

