/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.APeriphsViewBase;
import com.nxp.swtools.periphs.gui.view.DocumentationViewHelper;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.documentation.Contents;
import com.nxp.swtools.resourcetables.model.data.documentation.ISectionsProvider;
import com.nxp.swtools.resourcetables.model.data.documentation.Section;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.support.markdown.MarkDownSupport;
import java.io.File;
import java.io.IOError;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.json.JSONException;
import org.json.JSONObject;

public class DocumentationView
extends APeriphsViewBase {
    private static final String BROWSER_TYPE_IE = "ie";
    private static final String BROWSER_TYPE_WEBKIT = "webkit";
    private static final String MENU_SCRIPT_DEBUG_LOGGER = "debugLogger";
    private static final String MENU_SCRIPT_CURRENT_COMPONENT_DIRECTORY = "currentComponentDirectory";
    private static final String MENU_SCRIPT_CURRENT_PAGE = "currentPage";
    private static final String MENU_SCRIPT_CONTENTS = "contents";
    private static final String MENU_SCRIPT_DOC_LINK_PREFIX = "DOC_LINK_PREFIX";
    @NonNull
    private static final String ABOUT_COLON = "about:";
    private static final int ITEMS_IN_HEADER_COUNT = 10;
    @NonNull
    public static final String OTHER_COMPONENT_SEPARATOR = "::";
    @NonNull
    private static final String ABOUT_BLANK = "about:blank";
    @NonNull
    static final String FILE_PREFIX = OSDetect.isWindows() ? "file:///" : "file://";
    @NonNull
    static final String HTTP_PREFIX = "http://";
    @NonNull
    static final String HTTPS_PREFIX = "https://";
    private static final String DOCUMENTATION_PREFIX = "mcuxdoc://";
    @NonNull
    private static final String MARKDOWN_EXTENSION = "md";
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(DocumentationView.class);
    @NonNull
    public static final String ID = "com.nxp.swtools.periphs.gui.view.documentationView";
    @NonNull
    private static final String RAW_DATA_PREFIX = "data:";
    @NonNull
    private static final String FILE_SCHEME = "file";
    @NonNull
    transient SWTFactoryProxy swtFactory = SWTFactoryProxy.INSTANCE;
    @Nullable
    Composite viewer = null;
    @NonNull
    String contentLocation = "";
    @NonNull
    private static final String HTML_DOC_TAG = "component-doc-link";
    @Nullable
    ConfigurationComponentTypeId componentTypeId;
    LinkedList<@NonNull String> visitedPages = new LinkedList();
    int currentPageIndex = 0;
    @Nullable
    Contents menuContent = null;

    public void init(IViewSite site) throws PartInitException {
        ConfigurationComponentTypeId componentTypeIdLoc;
        super.init(site);
        this.hideOthers();
        String typeId = UtilsText.safeString((String)site.getSecondaryId());
        AvailableComponents availComps = Controller.getInstance().getMcu().getAvailableComponents();
        this.componentTypeId = componentTypeIdLoc = availComps.getConfigCompTypeId(typeId);
        boolean willBeClosed = this.updateCurrentView(typeId, availComps, this.componentTypeId);
        if (willBeClosed) {
            return;
        }
        if (componentTypeIdLoc == null) {
            return;
        }
        this.contentLocation = UtilsText.safeString((String)componentTypeIdLoc.getDocumentationLocation()).replace("\\", "/");
        this.menuContent = componentTypeIdLoc.getDocumentationMenuContent();
    }

    boolean updateCurrentView(@Nullable String type, @NonNull AvailableComponents availComps, @Nullable ConfigurationComponentTypeId typeId) {
        if (type == null) {
            this.hideSelf();
            return true;
        }
        if (availComps.getConfigComps().isEmpty()) {
            this.hideSelf();
            return true;
        }
        if (typeId == null) {
            LOGGER.severe(String.format("[TOOL] A '%1s' with typeId '%2s' is missing among available components", ConfigurationComponentTypeId.class.getName(), type));
            this.hideSelf();
            return true;
        }
        if (!typeId.isDocumentationPresent()) {
            LOGGER.severe(String.format("[TOOL] No documentation found for '%1s' with typeId '%2s'", ConfigurationComponentTypeId.class.getName(), type));
            this.hideSelf();
            return true;
        }
        return false;
    }

    void hideSelf() {
        Display display = Display.getCurrent();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IViewSite site = DocumentationView.this.getViewSite();
                    if (!$assertionsDisabled && site == null) {
                        throw new AssertionError();
                    }
                    IWorkbenchWindow workbenchWindow = site.getWorkbenchWindow();
                    if (workbenchWindow == null) {
                        return;
                    }
                    IWorkbenchPage activePage = workbenchWindow.getActivePage();
                    if (activePage == null) {
                        return;
                    }
                    activePage.hideView((IViewPart)DocumentationView.this);
                }
            });
        }
    }

    void hideOthers() {
        Display display = Display.getCurrent();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IViewSite site = DocumentationView.this.getViewSite();
                    if (!$assertionsDisabled && site == null) {
                        throw new AssertionError();
                    }
                    IWorkbenchPage page = Objects.requireNonNull(Objects.requireNonNull(site.getWorkbenchWindow()).getActivePage());
                    IViewReference[] views = page.getViewReferences();
                    List otherDocumentationViews = (List)Arrays.asList(views).stream().filter(x -> x.getId().equals(DocumentationView.ID)).filter(x -> !Objects.equals(x.getView(false), (Object)DocumentationView.this)).collect(CollectorsUtils.toList());
                    otherDocumentationViews.forEach(x -> page.hideView(x));
                }
            });
        }
    }

    private @NonNull List<@NonNull String> getPagesLabels(@Nullable ISectionsProvider sectionsProvider, int indent) {
        if (sectionsProvider == null) {
            return Collections.emptyList();
        }
        ArrayList<@NonNull String> result = new ArrayList<String>();
        for (Section section : sectionsProvider.getSections()) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < indent) {
                builder.append(" ");
                builder.append(" ");
                builder.append(" ");
                ++i;
            }
            if (indent != 0) {
                builder.append("-");
            }
            builder.append(section.getName());
            result.add(builder.toString());
            if (!section.hasSubSections()) continue;
            result.addAll(this.getPagesLabels((ISectionsProvider)section, indent + 1));
        }
        return result;
    }

    public void createPartControl(Composite parent) {
        assert (parent != null);
        Composite contentComposite = this.createDefaultComposite(parent);
        contentComposite.setLayout((Layout)new GridLayout(10, true));
        final Button backButton = new Button(contentComposite, 8);
        backButton.setImage(ToolsImages.getImage((String)"icons/left.png"));
        backButton.setToolTipText(Messages.get().DocumentationView_Back);
        backButton.setLayoutData((Object)new GridData(4, 4, false, false));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)backButton, "periphsDocumentationViewBackButton");
        final Button forwardButton = new Button(contentComposite, 8);
        forwardButton.setImage(ToolsImages.getImage((String)"icons/right.png"));
        forwardButton.setToolTipText(Messages.get().DocumentationView_Forward);
        forwardButton.setLayoutData((Object)new GridData(4, 4, false, false));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)forwardButton, "periphsDocumentationViewForwardButton");
        Button indexButton = new Button(contentComposite, 8);
        indexButton.setImage(ToolsImages.getImage((String)"icons/overview.png"));
        indexButton.setToolTipText(Messages.get().DocumentationView_Home);
        indexButton.setLayoutData((Object)new GridData(4, 4, false, false));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)indexButton, "periphsDocumentationViewHomeButton");
        final InstantSearchList pageSelector = new InstantSearchList(contentComposite, 2048);
        GridData layoutData = new GridData(4, 4, true, false, 5, 1);
        pageSelector.setLayoutData((Object)layoutData);
        if (this.menuContent == null) {
            layoutData.exclude = true;
            pageSelector.setVisible(false);
        }
        List<@NonNull String> pagesLabels = this.getPagesLabels((ISectionsProvider)this.menuContent, 0);
        pageSelector.setItems(pagesLabels.toArray(new String[0]));
        pageSelector.setSelection(!pagesLabels.isEmpty() ? pagesLabels.get(0) : "");
        SWTFactoryProxy.INSTANCE.setTestId((Widget)pageSelector, "periphsDocumentationViewCombobox");
        Composite viewerLoc = this.swtFactory.createHtmlViewer(contentComposite, 0);
        if (viewerLoc != null) {
            viewerLoc.setLayoutData((Object)new GridData(4, 4, true, true, 10, 1));
            this.viewer = viewerLoc;
            if (viewerLoc instanceof Browser) {
                final Browser browser = (Browser)viewerLoc;
                pageSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(@NonNull SelectionEvent e) {
                        String selectionName = e.text;
                        Section section = DocumentationViewHelper.findSectionByPredicate((ISectionsProvider)DocumentationView.this.menuContent, x -> selectionName.endsWith(x.getName()));
                        if (section == null) {
                            return;
                        }
                        String sectionFile = section.getFile();
                        ConfigurationComponentTypeId componentTypeIdLoc = DocumentationView.this.componentTypeId;
                        if (componentTypeIdLoc == null) {
                            return;
                        }
                        browser.setUrl(this.getPathToPage(sectionFile, componentTypeIdLoc));
                    }

                    private String getPathToPage(String sectionFile, ConfigurationComponentTypeId componentTypeIdLoc) {
                        return String.valueOf(DocumentationView.this.getProtocol()) + componentTypeIdLoc.getFileLocation().resolve("doc").resolve(sectionFile).toString();
                    }
                });
                browser.addLocationListener((LocationListener)new LocationAdapter(){

                    public void changing(LocationEvent event) {
                        String location = UtilsText.safeString((String)event.location);
                        if (location.endsWith(".md")) {
                            if (location.startsWith(FILE_PREFIX)) {
                                location = location.substring(FILE_PREFIX.length());
                            }
                            if (location.startsWith(DocumentationView.DOCUMENTATION_PREFIX)) {
                                location = location.substring(DocumentationView.DOCUMENTATION_PREFIX.length());
                            }
                            if (location.startsWith(DocumentationView.ABOUT_COLON)) {
                                location = location.substring(DocumentationView.ABOUT_COLON.length());
                            }
                            this.handleContent(location);
                            event.doit = false;
                        }
                        if (location.startsWith(DocumentationView.HTTP_PREFIX) || location.startsWith(DocumentationView.HTTPS_PREFIX)) {
                            try {
                                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(location));
                                event.doit = false;
                                return;
                            }
                            catch (MalformedURLException | PartInitException throwable) {
                                LOGGER.log(Level.WARNING, "[TOOL] External browser cannot be initializated");
                            }
                        }
                        this.handleHistoryStack(location);
                    }

                    private void handleContent(@NonNull String location) {
                        ConfigurationComponentTypeId componentTypeIdLoc = DocumentationView.this.componentTypeId;
                        if (componentTypeIdLoc != null) {
                            File pageFile = new File(location);
                            String pageName = pageFile.getName();
                            DocumentationView.this.updatePageSelector(pageSelector, pageName);
                            String fileContent = UtilsFile.readFileToString((String)pageFile.getAbsolutePath(), (Charset)StandardCharsets.UTF_8);
                            String componentDescription = "";
                            if (fileContent != null) {
                                Description description;
                                if (fileContent.contains(DocumentationView.HTML_DOC_TAG)) {
                                    DocumentationView.this.openDocInBrowser(fileContent, componentTypeIdLoc.getFileLocation().toAbsolutePath().toString());
                                }
                                if ((description = componentTypeIdLoc.getConfigurationComponent().getDescription()) != null) {
                                    componentDescription = UtilsText.safeString((String)description.getDescription(DocumentationView.this.controllerWrapper.getController().getProfile().getExpressionContext()));
                                }
                                browser.setText(DocumentationView.this.getHtmlContentForBrowser(DocumentationView.this.getMenuHtmlContent(pageName), fileContent, componentDescription));
                            } else {
                                browser.setText("<p>404 File not found</p>");
                            }
                        }
                    }

                    private void handleHistoryStack(@NonNull String location) {
                        String previousPage;
                        if (location.equals(DocumentationView.ABOUT_BLANK)) {
                            return;
                        }
                        if (location.startsWith(DocumentationView.RAW_DATA_PREFIX)) {
                            return;
                        }
                        if (DocumentationView.this.visitedPages.size() > DocumentationView.this.currentPageIndex && (previousPage = DocumentationView.this.visitedPages.get(DocumentationView.this.currentPageIndex)).equals(location)) {
                            return;
                        }
                        if (DocumentationView.this.visitedPages.size() - 1 > DocumentationView.this.currentPageIndex) {
                            String nextPage = DocumentationView.this.visitedPages.get(DocumentationView.this.currentPageIndex + 1);
                            if (!nextPage.equals(location)) {
                                ListIterator<@NonNull String> listIterator = DocumentationView.this.visitedPages.listIterator(DocumentationView.this.currentPageIndex + 1);
                                while (listIterator.hasNext()) {
                                    listIterator.next();
                                    listIterator.remove();
                                }
                            } else {
                                ++DocumentationView.this.currentPageIndex;
                                return;
                            }
                        }
                        DocumentationView.this.visitedPages.add(location);
                        ++DocumentationView.this.currentPageIndex;
                    }

                    public void changed(LocationEvent event) {
                        super.changed(event);
                        backButton.setEnabled(DocumentationView.this.currentPageIndex > 1);
                        forwardButton.setEnabled(DocumentationView.this.visitedPages.size() > DocumentationView.this.currentPageIndex + 1);
                    }
                });
                if (!UtilsText.isEmpty((String)this.contentLocation)) {
                    browser.setUrl(String.valueOf(this.getProtocol()) + this.contentLocation);
                }
                backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(@NonNull SelectionEvent e) {
                        if (DocumentationView.this.currentPageIndex >= 1) {
                            --DocumentationView.this.currentPageIndex;
                            String page = DocumentationView.this.visitedPages.get(DocumentationView.this.currentPageIndex);
                            browser.setUrl(String.valueOf(DocumentationView.this.getProtocol()) + page);
                        }
                    }
                });
                forwardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(@NonNull SelectionEvent e) {
                        if (DocumentationView.this.visitedPages.size() > DocumentationView.this.currentPageIndex + 1) {
                            ++DocumentationView.this.currentPageIndex;
                            String page = DocumentationView.this.visitedPages.get(DocumentationView.this.currentPageIndex);
                            browser.setUrl(String.valueOf(DocumentationView.this.getProtocol()) + page);
                        }
                    }
                });
                indexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(@NonNull SelectionEvent e) {
                        browser.setUrl(String.valueOf(DocumentationView.this.getProtocol()) + DocumentationView.this.contentLocation);
                    }
                });
            }
        }
        SharedConfigurationFactory.getSharedConfigurationSingleton().addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(ISharedConfiguration sharedConfig, ConfigChangeReason reason) {
                DocumentationView.this.updateCurrentView(DocumentationView.this.componentTypeId != null ? DocumentationView.this.componentTypeId.getTypeId() : "", Controller.getInstance().getMcu().getAvailableComponents(), DocumentationView.this.componentTypeId);
                switch (reason) {
                    case NEW_CONFIG: {
                        DocumentationView.this.hideSelf();
                    }
                }
            }
        });
    }

    @NonNull String markdownToHTML(@Nullable String markdown) {
        final ConfigurationComponentTypeId componentTypeIdLoc = this.componentTypeId;
        if (componentTypeIdLoc == null) {
            return "";
        }
        return MarkDownSupport.markDownToHtml((String)UtilsText.safeString((String)markdown), (Function)new Function<String, String>(){

            @Override
            public String apply(String address) {
                URI uri;
                if (address.startsWith(DocumentationView.RAW_DATA_PREFIX)) {
                    return address;
                }
                ConfigurationComponentTypeId componentTypeIdForDocumentation = DocumentationView.getTargetTypeId(address, DocumentationView.this.controllerWrapper);
                if (componentTypeIdForDocumentation == null) {
                    componentTypeIdForDocumentation = componentTypeIdLoc;
                } else {
                    int indexOfDoubleColon = address.indexOf(DocumentationView.OTHER_COMPONENT_SEPARATOR);
                    address = address.substring(indexOfDoubleColon + DocumentationView.OTHER_COMPONENT_SEPARATOR.length());
                }
                String typeId = componentTypeIdForDocumentation.getTypeId();
                try {
                    uri = new URI(address);
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, String.format("[TOOL] Invalid URI in '%1s' with typeId '%2s': %3s", ConfigurationComponentTypeId.class.getName(), typeId, address), e);
                    return address;
                }
                String scheme = UtilsText.safeString((String)uri.getScheme());
                if (!scheme.isEmpty() && !scheme.equals(DocumentationView.FILE_SCHEME)) {
                    return address;
                }
                Path filePath = Paths.get(uri.getSchemeSpecificPart(), new String[0]);
                if (!filePath.isAbsolute()) {
                    try {
                        filePath = componentTypeIdForDocumentation.resolveDocumentationPath(filePath).toAbsolutePath();
                    }
                    catch (IOError e) {
                        LOGGER.log(Level.SEVERE, String.format("[TOOL] Failed to resolve URI in '%1s' with typeId '%2s': %3s", ConfigurationComponentTypeId.class.getName(), typeId, address), e);
                    }
                }
                return String.valueOf(DocumentationView.this.getProtocol()) + filePath.toString().replace("\\", "/");
            }
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @Nullable ConfigurationComponentTypeId getTargetTypeId(@NonNull String address, @NonNull IControllerWrapper wrapper) {
        ConfigurationComponentTypeId componentTypeIdForDocumentation = null;
        int indexOfDoubleColon = address.indexOf(OTHER_COMPONENT_SEPARATOR);
        if (indexOfDoubleColon != -1) {
            String type = address.substring(0, indexOfDoubleColon);
            componentTypeIdForDocumentation = wrapper.getController().getProfile().getActiveComponents().getComponentTypeIdByType(type);
            if (componentTypeIdForDocumentation == null) {
                AvailableComponents availableComponents = wrapper.getController().getMcu().getAvailableComponents();
                @NonNull List componentTypeIdsByType = availableComponents.getComponentTypeIdsByType(type);
                if (componentTypeIdsByType == null) {
                    LOGGER.log(Level.SEVERE, String.format("[TOOL] Component with type %s is not available on current mcu or does not exist", type));
                    return null;
                }
                componentTypeIdForDocumentation = availableComponents.getBestMatchingConfigCompType(componentTypeIdsByType);
                if (componentTypeIdForDocumentation == null) {
                    LOGGER.log(Level.WARNING, String.format("[TOOL] No available component with type %s should be used. Using random version for documentation only!", type));
                    return (ConfigurationComponentTypeId)componentTypeIdsByType.get(0);
                }
            }
        }
        return componentTypeIdForDocumentation;
    }

    public void setFocus() {
        Composite viewerLoc = this.viewer;
        if (viewerLoc != null) {
            viewerLoc.setFocus();
        }
    }

    public void reload() {
        ConfigurationComponentTypeId componentTypeIdLoc = this.componentTypeId;
        if (componentTypeIdLoc != null) {
            this.menuContent = componentTypeIdLoc.getDocumentationMenuContent();
        }
        if (this.viewer instanceof Browser) {
            Browser browser = (Browser)this.viewer;
            try {
                browser.setUrl(this.visitedPages.get(this.currentPageIndex));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                LOGGER.log(Level.WARNING, "[TOOL] Problem in Documentation View occured when reload was issued due to IndexOutOfBoundException");
            }
        }
    }

    public void goToPage(@NonNull String page) {
        ConfigurationComponentTypeId componentTypeIdLoc = this.componentTypeId;
        if (componentTypeIdLoc == null) {
            return;
        }
        ConfigurationComponentTypeId targetTypeId = DocumentationView.getTargetTypeId(page, this.controllerWrapper);
        if (targetTypeId == null) {
            targetTypeId = componentTypeIdLoc;
        } else {
            int indexOfDoubleColon = page.indexOf(OTHER_COMPONENT_SEPARATOR);
            page = page.substring(indexOfDoubleColon + OTHER_COMPONENT_SEPARATOR.length());
        }
        Composite viewerLoc = this.viewer;
        if (viewerLoc instanceof Browser) {
            Browser browser = (Browser)viewerLoc;
            browser.setUrl(targetTypeId.getFileLocation().resolve("doc").resolve(page).toString());
        }
    }

    public static boolean open(@NonNull IViewSite viewSite, @NonNull String typeId, boolean activate) {
        return DocumentationView.open(viewSite.getPage(), typeId, activate);
    }

    public static boolean open(@Nullable IWorkbenchPage workbenchPage, @NonNull String typeId, boolean activate) {
        if (workbenchPage != null) {
            try {
                workbenchPage.showView(ID, typeId, activate ? 1 : 2);
                return true;
            }
            catch (PartInitException partInitException) {
                return false;
            }
        }
        return false;
    }

    public static void refresh() {
        DocumentationView instance = DocumentationView.getInstance();
        if (instance != null) {
            instance.reload();
        }
    }

    public static void openPage(String page) {
        DocumentationView instance = DocumentationView.getInstance();
        if (instance != null) {
            instance.goToPage(page);
        } else {
            LOGGER.log(Level.SEVERE, "[TOOL] The Documentation view is not open now");
        }
    }

    private static @Nullable DocumentationView getInstance() {
        IViewReference[] viewReferences;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = viewReferences = activePage.getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart view;
            IViewReference reference = iViewReferenceArray[n2];
            if (ID.equals(reference.getId()) && (view = reference.getView(false)) instanceof DocumentationView) {
                return (DocumentationView)view;
            }
            ++n2;
        }
        return null;
    }

    void openDocInBrowser(@NonNull String docContent, @NonNull String componentLocation) {
        try {
            JSONObject jsonOb = new JSONObject(docContent);
            String link = jsonOb.get(HTML_DOC_TAG).toString();
            link = link.replace("${CPU}", Controller.getInstance().getMcu().getMcuIdentification().getMcu());
            link = link.replace("${CPU_FAMILY}", Controller.getInstance().getMcu().getFamily());
            link = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(link, true);
            if (!Paths.get(link, new String[0]).isAbsolute()) {
                link = Paths.get(componentLocation, link).normalize().toString();
            }
            SWTFactoryProxy.INSTANCE.openUrlInExternalBrowser(UtilsText.safeString((String)link));
            this.hideSelf();
        }
        catch (CoreException | JSONException e) {
            LOGGER.info(e.getMessage());
        }
    }

    @NonNull String getMenuHtmlContent(String currentPageFileName) {
        String menu = "";
        Contents menuContentLoc = this.menuContent;
        ConfigurationComponentTypeId componentTypeIdLoc = this.componentTypeId;
        if (menuContentLoc != null && componentTypeIdLoc != null) {
            File generatorFile;
            Object result = null;
            SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
            simpleScriptContext.setAttribute(MENU_SCRIPT_DEBUG_LOGGER, LOGGER, 100);
            simpleScriptContext.setAttribute(MENU_SCRIPT_DOC_LINK_PREFIX, this.getProtocol(), 100);
            simpleScriptContext.setAttribute(MENU_SCRIPT_CONTENTS, menuContentLoc, 100);
            simpleScriptContext.setAttribute(MENU_SCRIPT_CURRENT_PAGE, currentPageFileName, 100);
            simpleScriptContext.setAttribute(MENU_SCRIPT_CURRENT_COMPONENT_DIRECTORY, componentTypeIdLoc.getFileLocation().toString().replace('\\', '/'), 100);
            ConfigurationComponentTypeId systemComponent = this.controllerWrapper.getController().getSystemComponent();
            if (systemComponent != null && (generatorFile = systemComponent.getDocumentationMenuGeneratorScript()) != null) {
                try {
                    result = JavaScriptHelper.eval((File)generatorFile, (ScriptContext)simpleScriptContext, (ScriptEngine)JavaScriptHelper.createJavascriptEngine());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "[TOOL] Generation of menu content failed. ", e);
                }
            }
            if (result instanceof String) {
                menu = (String)result;
            } else {
                LOGGER.log(Level.SEVERE, "[DATA] Result of menu generator is not a string, but : {0}", result);
            }
        }
        return menu;
    }

    void updatePageSelector(InstantSearchList pageSelector, String fileName) {
        String selection;
        Section currentSection = DocumentationViewHelper.findSectionByPredicate((ISectionsProvider)this.menuContent, x -> x.getFile().equals(fileName));
        if (currentSection != null && (selection = (String)CollectionsUtils.nullableOptionalGet(pageSelector.getItems().stream().filter(x -> x.endsWith(currentSection.getName())).findAny())) != null) {
            pageSelector.select(selection);
        }
    }

    @NonNull String getHtmlContentForBrowser(@NonNull String menuHtmlContent, @NonNull String fileMdContent, @NonNull String title) {
        StringBuilder builder = new StringBuilder("<html>");
        builder.append("<head>");
        builder.append("</head>");
        builder.append("<body>");
        if (this.menuContent != null) {
            builder.append("<h1>").append(title).append("</h1>");
        }
        builder.append(menuHtmlContent).append(this.markdownToHTML(fileMdContent)).append(menuHtmlContent);
        builder.append("</body>").append("</html>");
        return builder.toString();
    }

    private String getProtocol() {
        Composite viewerLoc = this.viewer;
        String browserType = null;
        if (viewerLoc instanceof Browser) {
            browserType = ((Browser)viewerLoc).getBrowserType();
        }
        if (BROWSER_TYPE_IE.equals(browserType) || BROWSER_TYPE_WEBKIT.equals(browserType) && OSDetect.isUnix()) {
            return FILE_PREFIX;
        }
        return DOCUMENTATION_PREFIX;
    }
}

