/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.tileviewer.ITileFilter;
import com.nxp.swtools.common.ui.utils.tileviewer.ITileLabelProvider;
import com.nxp.swtools.common.ui.utils.tileviewer.ITileSelectionListenerData;
import com.nxp.swtools.common.ui.utils.tileviewer.TileCategoryData;
import com.nxp.swtools.common.ui.utils.tileviewer.TileItemData;
import com.nxp.swtools.common.ui.utils.tileviewer.TileViewer;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.runtime.DelayedActionExecutorAdapter;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.common.utils.runtime.IDelayedActionExecutor;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderDialog;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderDialogProperties;
import com.nxp.swtools.periphs.gui.view.APeriphsViewBase;
import com.nxp.swtools.periphs.gui.view.AddComponentDialog;
import com.nxp.swtools.periphs.gui.view.AddComponentDialogProperties;
import com.nxp.swtools.periphs.gui.view.ComponentMenuCreator;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.resourcetables.model.config.ChildValidationHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.data.Category;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.IValidationProblemListener;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.engine.ValidationProblemListenerAdapter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ComponentsView
extends APeriphsViewBase {
    @NonNull
    private static final String CATEGORY_OTHER_ID = "other";
    @NonNull
    private static final String CATEGORY_OTHER_UI_NAME = UtilsText.safeString((String)Messages.get().ComponentsView_CategoryOther_UiName);
    @NonNull
    private static final String CATEGORY_OTHER_DESCRIPTION = UtilsText.safeString((String)Messages.get().ComponentsView_CategoryOther_Description);
    @NonNull
    public static final String ID = "com.nxp.swtools.periphs.gui.view.componentsView";
    @Nullable
    Composite mainComposite;
    @NonNull
    String filterString = "";
    @Nullable
    TileViewer tileViewer;
    @Nullable
    private Text filterText;
    public static final int DELAYED_EXECUTION_TIMEOUT = 1000;
    public static final String SUFFIX_COPY = "_copy";
    @NonNull
    private ValidationProblemListenerAdapter validationsListener = new ValidationProblemListenerAdapter(){

        public void validationProblemsChanged(Collection<@NonNull IValidationProblem> problems) {
            TileViewer tileViewerLoc = ComponentsView.this.tileViewer;
            if (tileViewerLoc != null && !tileViewerLoc.getControl().isDisposed()) {
                tileViewerLoc.refresh();
            }
        }
    };

    public void createPartControl(Composite parentComposite) {
        final Composite mainCompositeLoc = this.mainComposite = this.createDefaultComposite(parentComposite);
        mainCompositeLoc.setLayout((Layout)new GridLayout(3, false));
        Text text = new Text(mainCompositeLoc, 2048);
        text.setMessage(UtilsText.safeString((String)com.nxp.swtools.utils.Messages.get().RegistersView_TypeFilterText));
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)text, "periphsFilterCompsTxt");
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)text, Messages.get().ComponentsView_FilterTooltip);
        this.filterText = text;
        DelayedActionExecutorAdapter actionExecutor = new DelayedActionExecutorAdapter(){

            public void runAction() {
                mainCompositeLoc.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ComponentsView.this.refresh(false);
                    }
                });
            }
        };
        final DelayedExecution delayedExecution = new DelayedExecution("FilteringComponents", (IDelayedActionExecutor)actionExecutor, 1000);
        ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newFilterText = UtilsText.safeString((String)((Text)e.widget).getText());
                if (newFilterText.equals(ComponentsView.this.filterString)) {
                    return;
                }
                ComponentsView.this.filterString = newFilterText;
                if (Rap.isActive()) {
                    ComponentsView.this.refresh(false);
                } else {
                    delayedExecution.requestExecution();
                }
            }
        };
        text.addModifyListener(textModifyListener);
        Button button = new Button(mainCompositeLoc, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "periphsAddCompInstBtn");
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, Messages.get().ComponentsView_AddButtonTooltip);
        button.setImage(ToolsImages.getImage((String)"icons/add_circle.png"));
        button.setLayoutData((Object)new GridData(131072, 4, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddComponentDialog.open(ComponentsView.this.getViewSite(), null, ComponentsView.this.controllerWrapper);
            }
        });
        button = new Button(mainCompositeLoc, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "periphsOpenReorderDialog");
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, Messages.get().InitializationOrderDialog_OpenDialogButtonTooltip);
        button.setImage(ToolsImages.getImage((String)"icons/reorder.png"));
        button.setLayoutData((Object)new GridData(131072, 4, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = ComponentsView.this.getSiteNonNull().getShell();
                if (shell != null) {
                    InitializationOrderDialog.open(new InitializationOrderDialogProperties(shell, ComponentsView.this.controllerWrapper));
                }
            }
        });
        ArrayList<@NonNull TileCategoryData> tileCategoriesData = this.createTilesData();
        final TileViewer tileViewerLoc = new TileViewer(mainCompositeLoc);
        tileViewerLoc.setLayoutData(GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(3, 1).create());
        this.tileViewer = tileViewerLoc;
        tileViewerLoc.setSelectionListener(new ITileSelectionListenerData(){

            public void itemSelected(TileItemData selectedItem) {
                Object data = selectedItem.getData();
                if (data instanceof IComponentInstanceConfig) {
                    String type = ((IComponentInstanceConfig)data).getType();
                    String uiName = ((IComponentInstanceConfig)data).getUiName();
                    IComponentInstanceConfig instance = Controller.getInstance().getComponentInstance(type, uiName);
                    if (instance != null) {
                        ComponentsView.this.openView(instance);
                    } else {
                        ComponentsView.this.openView(type, uiName, true);
                    }
                }
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             * Enabled aggressive block sorting
             */
            public void categorySelected(TileCategoryData selectedCategory) {
                Object data = selectedCategory.getData();
                if (data instanceof Category) {
                    List componentsForCategory;
                    Category category = (Category)data;
                    if (category.getId().equals(ComponentsView.CATEGORY_OTHER_ID)) {
                        Categories categories = ComponentsView.this.controllerWrapper.getController().getCategories();
                        if (categories == null) {
                            AddComponentDialog.open(ComponentsView.this.getViewSite(), null, ComponentsView.this.controllerWrapper);
                            return;
                        }
                        @NonNull List categoriesList = categories.getCategories();
                        componentsForCategory = ComponentsView.this.controllerWrapper.getController().getMcu().getAvailableComponents().getConfigCompsTypeIdsWithoutMatchingCategory((Collection)categoriesList);
                    } else {
                        componentsForCategory = ComponentsView.this.controllerWrapper.getController().getMcu().getAvailableComponents().getConfigCompsTypeIdsForCategory(category.getId());
                    }
                    AddComponentDialogProperties properties = new AddComponentDialogProperties(ComponentsView.this.getViewSite(), Controller.getInstance().getFunctionalGroup().getId(), ComponentsView.this.controllerWrapper, true, true);
                    properties.setConfigCompsTypeIds(componentsForCategory);
                    AddComponentDialog.open(properties);
                }
            }

            public void itemMenuSelected(final TileItemData tileItemData, List<@NonNull Control> controls) {
                ComponentMenuCreator.IComponentSelectionProvider selectionProvider = new ComponentMenuCreator.IComponentSelectionProvider(){

                    @Override
                    public Collection<? extends @NonNull IChild> getSelection() {
                        ArrayList<@NonNull IChild> result = new ArrayList<IChild>();
                        Object data = tileItemData.getData();
                        if (data instanceof IChild) {
                            result.add((IChild)data);
                        }
                        return result;
                    }
                };
                new ComponentMenuCreator(selectionProvider, new ComponentMenuCreator.ComponentMenuOptions(false), ComponentsView.this.controllerWrapper).createMenu(controls, ComponentsView.this.getViewSite(), null);
            }
        });
        final Font categoryFont = FontFactory.changeStyle((Font)parentComposite.getFont(), (int)1);
        parentComposite.addDisposeListener(e -> categoryFont.dispose());
        tileViewerLoc.setLabelProvider(new ITileLabelProvider(){

            public String getText(TileItemData itemData) {
                Object data = itemData.getData();
                if (data instanceof IComponentInstanceConfig) {
                    return ((IComponentInstanceConfig)data).getUiName();
                }
                return "";
            }

            public @Nullable Font getFont(@NonNull TileItemData tileItemData) {
                return null;
            }

            public String getText(TileCategoryData categoryData) {
                Object data = categoryData.getData();
                if (data instanceof Category) {
                    return UtilsText.safeString((String)((Category)data).getUINameString());
                }
                return "";
            }

            public @Nullable Font getFont(@NonNull TileCategoryData tileCategoryData) {
                return categoryFont;
            }

            public Color getBackground(TileItemData itemData) {
                Object data = itemData.getData();
                if (data instanceof IComponentInstanceConfig) {
                    IComponentInstanceConfig instanceConfig = (IComponentInstanceConfig)data;
                    if (!instanceConfig.isEnabled()) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.tile_viewer_item_BG_disabled");
                    }
                    int problemLevel = ValidationHelper.getHighestSeverityComponentValidationProblemLevel((IChild)instanceConfig);
                    if (instanceConfig.getError() != null || problemLevel >= 2) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
                    }
                }
                return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.tile_viewer_item_BG");
            }

            public Color getForeground(TileItemData itemData) {
                Object data = itemData.getData();
                Display display = tileViewerLoc.getControl().getDisplay();
                if (data instanceof IComponentInstanceConfig) {
                    IComponentInstanceConfig instanceConfig = (IComponentInstanceConfig)data;
                    if (!instanceConfig.isEnabled()) {
                        return display.getSystemColor(18);
                    }
                    int problemLevel = ValidationHelper.getHighestSeverityComponentValidationProblemLevel((IChild)instanceConfig);
                    if (instanceConfig.getError() != null || problemLevel >= 2) {
                        return ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG");
                    }
                }
                return display.getSystemColor(21);
            }

            public Image getImage(TileItemData itemData) {
                Object data = itemData.getData();
                if (data instanceof IComponentInstanceConfig) {
                    IComponentInstanceConfig instanceConfig = (IComponentInstanceConfig)data;
                    if (!ValidationHelper.getDriverValidationProblems((IChild)instanceConfig, (int)2).isEmpty()) {
                        return ToolsImages.getStatusIcon((int)2);
                    }
                    int problemLevel = ValidationHelper.getHighestSeverityComponentValidationProblemLevel((IChild)instanceConfig);
                    if (instanceConfig.getError() != null || problemLevel >= 2) {
                        return ToolsImages.getStatusIcon((int)2);
                    }
                    if (instanceConfig.getWarning() != null || problemLevel == 1) {
                        return ToolsImages.getStatusIcon((int)1);
                    }
                    if (instanceConfig.getInfo() != null || problemLevel == 0) {
                        return ToolsImages.getStatusIcon((int)0);
                    }
                    if (!instanceConfig.getComment().isEmpty()) {
                        return ToolsImages.getImage((String)"icons/legend.png");
                    }
                }
                return null;
            }

            public String getTooltipText(TileItemData itemData) {
                StringBuilder result = new StringBuilder();
                Object data = itemData.getData();
                if (data instanceof IComponentInstanceConfig) {
                    IComponentInstanceConfig instanceConfig = (IComponentInstanceConfig)data;
                    IComponentConfig componentConfig = instanceConfig.getChildContext().getComponentConfig();
                    result.append(ComponentsView.getTooltipText((IChild)instanceConfig, ComponentsView.this.controllerWrapper.getController().getCategories()));
                    if (componentConfig != null) {
                        result.append("<br/>");
                        result.append("<br/>");
                        result.append(ComponentsView.getTooltipText((IChild)componentConfig, ComponentsView.this.controllerWrapper.getController().getCategories()));
                    }
                }
                return result.length() == 0 ? null : result.toString();
            }

            public String getAddButtonTooltipText(@NonNull TileCategoryData tileCategoryData) {
                Object data = tileCategoryData.getData();
                if (data instanceof Category) {
                    String categoryName = UtilsText.safeString((String)((Category)data).getUINameString());
                    return MessageFormat.format(Messages.get().ComponentsView_CategoryAddButtonTooltip, categoryName);
                }
                return "";
            }

            public String getTooltipText(TileCategoryData tileCategoryData) {
                Object data = tileCategoryData.getData();
                if (data instanceof Category) {
                    return ((Category)data).getDescription();
                }
                return "";
            }
        });
        tileViewerLoc.setFilter(new ITileFilter(){

            public boolean select(TileItemData tileItemData) {
                Object data = tileItemData.getData();
                if (data instanceof IComponentInstanceConfig) {
                    return UtilsText.containsIgnoreCase((String)((IComponentInstanceConfig)data).getUiName(), (String)ComponentsView.this.filterString);
                }
                return false;
            }
        });
        tileViewerLoc.setInput(tileCategoriesData);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)tileViewerLoc.getControl(), "periphsCompsTree");
        this.registerListener(7, new IEventListener(){

            public void handle(@NonNull Collection<@NonNull ToolEvent> events) {
                boolean hasChangeEvent = events.stream().anyMatch(e -> e.isType(1));
                ComponentsView.this.refresh(hasChangeEvent);
            }

            public void handle(@NonNull ToolEvent event) {
                if (event.isType(1)) {
                    ComponentsView.this.refresh(true);
                } else {
                    ComponentsView.this.refresh(false);
                }
            }
        });
        ValidationEngineFactory.addListener((IValidationProblemListener)this.validationsListener);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull ArrayList<@NonNull TileCategoryData> createTilesData() {
        TileCategoryData tileCategoryData;
        ArrayList<@NonNull TileCategoryData> tileCategoriesData = new ArrayList<TileCategoryData>();
        Categories categories = this.controllerWrapper.getController().getCategories();
        List<@NonNull E> categoriesList = new ArrayList();
        if (categories != null) {
            categoriesList = categories.getCategories();
            for (Category category : categoriesList) {
                @NonNull List configCompsForCategory = this.controllerWrapper.getController().getMcu().getAvailableComponents().getConfigCompsTypeIdsForCategory(category.getId());
                if (configCompsForCategory.isEmpty()) continue;
                @NonNull Collection instancesOfCategory = this.controllerWrapper.getController().getFunctionalGroup().getInstancesOfCategory(category.getId());
                tileCategoryData = ComponentsView.createTileCategoryData(category, instancesOfCategory);
                tileCategoriesData.add(tileCategoryData);
            }
        }
        @NonNull List configCompsTypeIdsWithoutMatchingCategory = this.controllerWrapper.getController().getMcu().getAvailableComponents().getConfigCompsTypeIdsWithoutMatchingCategory(categoriesList);
        AddComponentDialog.filterNonDisplayableComponents(configCompsTypeIdsWithoutMatchingCategory, this.controllerWrapper.getController().getProfile());
        if (!configCompsTypeIdsWithoutMatchingCategory.isEmpty()) {
            Category otherCategory = ComponentsView.createOtherCategory();
            @NonNull Collection instancesWithoutMatchingCategory = this.controllerWrapper.getController().getFunctionalGroup().getInstancesWithoutMatchingCategory(categoriesList);
            tileCategoryData = ComponentsView.createTileCategoryData(otherCategory, instancesWithoutMatchingCategory);
            tileCategoriesData.add(tileCategoryData);
        }
        return tileCategoriesData;
    }

    private static @NonNull TileCategoryData createTileCategoryData(@NonNull Category category, @NonNull Collection<@NonNull IComponentInstanceConfig> componentInstanceConfigs) {
        TileCategoryData tileCategoryData = new TileCategoryData((Object)category);
        for (IComponentInstanceConfig componentInstanceConfig : componentInstanceConfigs) {
            TileItemData tileItemData = new TileItemData((Object)componentInstanceConfig);
            tileCategoryData.addChild(tileItemData);
        }
        return tileCategoryData;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static @Nullable String getTooltipText(@NonNull IChild child, Categories categories) {
        int problemLevel = ValidationHelper.getHighestSeverityComponentValidationProblemLevel((IChild)child);
        HashSet<@NonNull E> depDescs = new HashSet();
        @NonNull List driverProblems = ValidationHelper.getDriverValidationProblems((IChild)child, (int)2);
        if (!driverProblems.isEmpty()) {
            problemLevel = 2;
            @NonNull Set depDescsDrivers = (Set)driverProblems.stream().map(x -> x.getDependency().getDescription()).collect(CollectorsUtils.toSet());
            depDescs.addAll(depDescsDrivers);
        }
        @NonNull Set depDescsComponent = (Set)ValidationHelper.getComponentValidationProblems((IChild)child, (int)problemLevel).stream().map(p -> p.getDependency().getDescription()).collect(CollectorsUtils.toSet());
        depDescs.addAll(depDescsComponent);
        String problemMsg = depDescs.isEmpty() ? null : ChildValidationHelper.mergeProblems((String[])depDescs.toArray(new String[depDescs.size()]));
        StringBuilder result = new StringBuilder();
        if (child instanceof IComponentInstanceConfig) {
            IComponentInstanceConfig instanceConfig = (IComponentInstanceConfig)child;
            if (instanceConfig.getType().equals("custom_init")) {
                result.append(MessageFormat.format(Messages.get().ComponentsView_ComponentIsMarkedAsUsed, instanceConfig.getPeripheral()));
            } else {
                String comment;
                String status;
                boolean showStatusSection;
                result.append("<u>");
                result.append(UtilsText.htmlB((String)instanceConfig.getUiName()));
                result.append("[");
                String peripheralsString = "";
                @NonNull List peripherals = instanceConfig.getPeripherals();
                @NonNull Collection erroneousPeripherals = instanceConfig.getErroneousPeripherals();
                if (!erroneousPeripherals.isEmpty()) {
                    String erroneousPeripheralsText = CollectionsUtils.formatList((Collection)erroneousPeripherals, (String)", ", null);
                    peripheralsString = String.valueOf(peripheralsString) + ToolTipableFormatter.colorize((String)erroneousPeripheralsText, (String)"red");
                }
                peripherals.removeAll(erroneousPeripherals);
                if (!peripheralsString.isEmpty() && !peripherals.isEmpty()) {
                    peripheralsString = String.valueOf(peripheralsString) + ", ";
                }
                peripheralsString = String.valueOf(peripheralsString) + CollectionsUtils.formatList((Collection)peripherals, (String)", ", null);
                result.append(MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentEditor_Peripherals), peripheralsString));
                result.append("; " + Messages.get().ComponentsView_Tooltips_Component + ": " + instanceConfig.getComponent().getId());
                result.append("]</u><br/>");
                result.append(instanceConfig.getDescription());
                String categoryString = "";
                String categoryIdFinal = UtilsText.safeString((String)instanceConfig.getComponent().getCategory());
                IContext contextFinal = instanceConfig.getExpressionContext();
                if (categories != null) {
                    categoryString = categories.getCategoryLabel(categoryIdFinal, contextFinal);
                }
                if (categoryString != null) {
                    result.append("[").append(categoryString).append("]");
                }
                result.append("<br/>");
                boolean bl = showStatusSection = instanceConfig.isEditingLocked() || !instanceConfig.isEnabled();
                if (showStatusSection) {
                    result.append("<br/>");
                    result.append(UtilsText.htmlB((String)(String.valueOf(Messages.get().ComponentsView_Tooltips_Status) + ": ")));
                    if (instanceConfig.isEditingLocked()) {
                        result.append("<br/>");
                        result.append(Messages.get().ComponentInstance_Locked);
                    }
                    if (!instanceConfig.isEnabled()) {
                        result.append("<br/>");
                        result.append(Messages.get().ComponentsView_Tooltips_Disabled);
                    }
                }
                if (!(status = ToolTipableFormatter.createStatus((IToolTipable)instanceConfig, (String)problemMsg, (int)problemLevel)).isEmpty()) {
                    result.append("<br/>");
                    result.append(status);
                }
                if (!(comment = instanceConfig.getComment()).isEmpty()) {
                    result.append("<br/>");
                    result.append(UtilsText.htmlB((String)Messages.get().ComponentSettingView_CommentLabel));
                    result.append("<br/>");
                    comment = UtilsText.safeString((String)UtilsText.cutOffAfter((String)comment, (int)10)).replaceAll("\\r\\n|\\n", "<br/>");
                    result.append(comment);
                }
            }
        }
        if (child instanceof IComponentConfig) {
            ComponentConfig componentConfig = (ComponentConfig)child;
            List components = componentConfig.getComponent().getComponents();
            if (!components.isEmpty()) {
                result.append(UtilsText.htmlB((String)(String.valueOf(Messages.get().ComponentsView_Tooltips_SdkReferences) + ": ")));
                result.append("<br/>");
                for (SWComponent component : components) {
                    result.append(String.valueOf(component.getName()) + ": " + component.getVersion());
                    result.append("<br/>");
                }
            }
            result.append(UtilsText.htmlB((String)(String.valueOf(Messages.get().ComponentsView_Tooltips_TypeId) + ": ")));
            result.append("<br/>");
            result.append(componentConfig.getComponentTypeId());
            String status = ToolTipableFormatter.createStatus((IToolTipable)componentConfig, (String)problemMsg, (int)problemLevel);
            if (!status.isEmpty()) {
                result.append("<br/>");
                result.append(status);
            }
        }
        return result.length() == 0 ? null : ToolTipableFormatter.trimExcessBreakLine((String)UtilsText.safeString((String)result.toString()));
    }

    void refresh() {
        ArrayList<@NonNull TileCategoryData> tileCategoriesData = this.createTilesData();
        if (this.tileViewer != null) {
            TileViewer tileViewerLoc = this.tileViewer;
            tileViewerLoc.setInput(tileCategoriesData);
        }
    }

    void refresh(boolean fullRefresh) {
        if (fullRefresh) {
            this.refresh();
        } else if (this.tileViewer != null) {
            this.tileViewer.refresh();
        }
    }

    public static @NonNull Category createOtherCategory() {
        return new Category(CATEGORY_OTHER_ID, CATEGORY_OTHER_UI_NAME, null, CATEGORY_OTHER_DESCRIPTION);
    }

    protected void resetView() {
        super.resetView();
        if (this.filterText != null) {
            this.filterText.setText("");
        }
        if (this.tileViewer != null) {
            this.tileViewer.refresh();
        }
    }

    @Override
    public void dispose() {
        ValidationEngineFactory.removeListener((IValidationProblemListener)this.validationsListener);
        super.dispose();
    }
}

