/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.templates.component;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.controller.ConfigurationComponentUtils;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.templates.component.ComponentTemplateDetailDialog;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplateProperties;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ComponentTemplateManagerDialog
extends Dialog {
    private static final int VIEWER_INITIAL_ROWS_COUNT = 20;
    private ArrayList<TreeEntry> entries = new ArrayList();
    @Nullable
    TreeEntry currentlySelectedEntry = null;
    @Nullable
    private TreeViewer viewer;
    @Nullable
    private Button removeSelectedUseCaseButton;
    @Nullable
    private Button exportSelectedUseCaseButton;
    @Nullable
    private Button detailsButton;

    protected ComponentTemplateManagerDialog(Shell parentShell) {
        super(parentShell);
    }

    public static void open(Shell shell) {
        ComponentTemplateManagerDialog dialog = new ComponentTemplateManagerDialog(shell);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().ComponentTemplateManagerDialog_Title);
    }

    protected @Nullable Button createButton(@Nullable Composite parent, int id, @Nullable String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Composite contentComposite = new Composite(composite, 0);
        GridLayout contentCompositeLayout = new GridLayout(2, false);
        contentComposite.setLayout((Layout)contentCompositeLayout);
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createAndPrepareTreeViewer(contentComposite);
        this.createButtons(composite);
        this.updateButtons();
        Button detailsButtonLoc = this.detailsButton;
        if (detailsButtonLoc != null) {
            detailsButtonLoc.setEnabled(false);
        }
        return composite;
    }

    void updateDetailsSelection(TreeEntry entry) {
        this.currentlySelectedEntry = entry;
    }

    private void createAndPrepareTreeViewer(Composite contentComposite) {
        Composite treeComposite = new Composite(contentComposite, 0);
        GridLayout treeCompositeLayout = new GridLayout(1, false);
        treeComposite.setLayout((Layout)treeCompositeLayout);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filteredTree = new FilteredTree(treeComposite, 67588, patternFilter, true);
        final TreeViewer treeViewer = filteredTree.getViewer();
        assert (treeViewer != null) : "TreeViewer was not created in FilteredTree";
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)treeViewer);
        this.viewer = treeViewer;
        Tree tree = treeViewer.getTree();
        SWTFactoryProxy.INSTANCE.setTestId((Widget)tree, "periphsUseCasesManagerTree");
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridData treeData = new GridData(4, 4, true, true);
        treeData.heightHint = tree.getItemHeight() * 20;
        tree.setLayoutData((Object)treeData);
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(@Nullable DoubleClickEvent event) {
                ComponentTemplateManagerDialog.this.openDetailsDialog(treeViewer.getTree().getShell());
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent event) {
                ComponentTemplateManagerDialog.this.updateEnabledStateOfDetailsButton();
            }
        });
        TreeViewerColumn checkboxColumn = new TreeViewerColumn(treeViewer, 0);
        checkboxColumn.getColumn().setText(Messages.get().ComponentTemplateManagerDialog_ViewerColumnSelectHeader);
        checkboxColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                return null;
            }

            public @Nullable Image getImage(Object element) {
                TreeEntry treeEntry;
                if (element instanceof TreeEntry && (treeEntry = (TreeEntry)element).getProperties() != null) {
                    return ToolsImages.getImage((String)(treeEntry.isChecked() ? "icons/checkbox_checked.png" : "icons/checkbox_unchecked.png"));
                }
                return null;
            }
        });
        checkboxColumn.setEditingSupport(new EditingSupport((ColumnViewer)treeViewer){

            protected void setValue(Object element, @Nullable Object value) {
            }

            protected @Nullable Object getValue(Object element) {
                return null;
            }

            protected @Nullable CellEditor getCellEditor(Object element) {
                if (element instanceof TreeEntry) {
                    TreeEntry treeEntry = (TreeEntry)element;
                    if (treeEntry.getProperties() != null) {
                        treeEntry.setChecked(!treeEntry.isChecked());
                        ComponentTemplateManagerDialog.this.updateButtons();
                    }
                    treeViewer.update(element, null);
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TreeViewerColumn nameColumn = new TreeViewerColumn(treeViewer, 0);
        nameColumn.getColumn().setText(Messages.get().ComponentTemplateManagerDialog_ViewerColumnNameHeader);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof TreeEntry) {
                    TreeEntry treeEntry = (TreeEntry)element;
                    ComponentTemplateProperties properties = treeEntry.getProperties();
                    if (properties == null) {
                        return treeEntry.getType();
                    }
                    return properties.getName();
                }
                return null;
            }
        });
        TreeViewerColumn descriptionColumn = new TreeViewerColumn(treeViewer, 0);
        descriptionColumn.getColumn().setText(Messages.get().ComponentTemplateManagerDialog_ViewerColumnDescriptionHeader);
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                TreeEntry treeEntry;
                ComponentTemplateProperties properties;
                if (element instanceof TreeEntry && (properties = (treeEntry = (TreeEntry)element).getProperties()) != null) {
                    return properties.getDescription();
                }
                return null;
            }

            public @Nullable String getToolTipText(Object element) {
                TreeEntry treeEntry;
                ComponentTemplateProperties properties;
                if (element instanceof TreeEntry && (properties = (treeEntry = (TreeEntry)element).getProperties()) != null) {
                    return properties.getDescription();
                }
                return null;
            }
        });
        TreeViewerColumn sdkCompColumn = new TreeViewerColumn(treeViewer, 0);
        sdkCompColumn.getColumn().setText(Messages.get().ComponentTemplateManagerDialog_ViewerColumnSDKComponentHeader);
        sdkCompColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                TreeEntry treeEntry;
                ComponentTemplateProperties properties;
                if (element instanceof TreeEntry && (properties = (treeEntry = (TreeEntry)element).getProperties()) != null) {
                    return ConfigurationComponentUtils.buildDriverDependencyInfo((boolean)true, (List)properties.getSwCompRefs());
                }
                return null;
            }
        });
        TreeViewerColumn typeIdColumn = new TreeViewerColumn(treeViewer, 0);
        typeIdColumn.getColumn().setText(Messages.get().ComponentTemplateManagerDialog_ViewerColumnTypeIdHeader);
        typeIdColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof TreeEntry) {
                    TreeEntry treeEntry = (TreeEntry)element;
                    return treeEntry.getTypeId();
                }
                return null;
            }
        });
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof TreeEntry) {
                    return !((TreeEntry)element).getSubEntries().isEmpty();
                }
                return false;
            }

            public @Nullable Object getParent(Object element) {
                if (element instanceof TreeEntry) {
                    return ((TreeEntry)element).getParent();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List inputList = (List)inputElement;
                    return inputList.toArray(new Object[inputList.size()]);
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TreeEntry) {
                    List<TreeEntry> subEntries = ((TreeEntry)parentElement).getSubEntries();
                    return subEntries.toArray(new TreeEntry[subEntries.size()]);
                }
                return new Object[0];
            }

            public void inputChanged(Viewer changedViewer, @Nullable Object oldInput, @Nullable Object newInput) {
            }

            public void dispose() {
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent event) {
                StructuredSelection structureSelection;
                Object firstElement;
                if (event == null) {
                    return;
                }
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && (firstElement = (structureSelection = (StructuredSelection)selection).getFirstElement()) instanceof TreeEntry) {
                    ComponentTemplateManagerDialog.this.updateDetailsSelection((TreeEntry)firstElement);
                }
            }
        });
        ArrayList<TreeEntry> entriesLoc = ComponentTemplateManagerDialog.prepareEntries();
        this.entries = entriesLoc;
        treeViewer.setInput(entriesLoc);
        treeViewer.expandAll();
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        treeViewer.collapseAll();
    }

    protected void updateButtons() {
        boolean enabled;
        Button exportSelectedUseCaseButtonLoc = this.exportSelectedUseCaseButton;
        Button removeSelectedUseCaseButtonLoc = this.removeSelectedUseCaseButton;
        List<ComponentTemplateProperties> selectedUseCases = this.collectSelectedUseCases();
        boolean bl = enabled = !selectedUseCases.isEmpty();
        if (exportSelectedUseCaseButtonLoc != null) {
            exportSelectedUseCaseButtonLoc.setEnabled(enabled);
        }
        if (removeSelectedUseCaseButtonLoc != null) {
            removeSelectedUseCaseButtonLoc.setEnabled(enabled);
        }
    }

    public void updateEnabledStateOfDetailsButton() {
        StructuredSelection sel;
        Object firstElement;
        TreeViewer viewerLoc = this.viewer;
        Button detailsButtonLoc = this.detailsButton;
        if (viewerLoc == null) {
            return;
        }
        if (detailsButtonLoc == null) {
            return;
        }
        ISelection selection = viewerLoc.getSelection();
        if (selection instanceof StructuredSelection && (firstElement = (sel = (StructuredSelection)selection).getFirstElement()) instanceof TreeEntry) {
            TreeEntry entry = (TreeEntry)firstElement;
            ComponentTemplateProperties properties = entry.getProperties();
            detailsButtonLoc.setEnabled(properties != null);
        }
    }

    private static ArrayList<TreeEntry> prepareEntries() {
        ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>();
        Map allTemplateProperties = AvailableComponents.loadAllTemplateProperties((String)ComponentTemplate.getComponentTemplatesFolder());
        for (Map.Entry entry : allTemplateProperties.entrySet()) {
            String typeId = (String)entry.getKey();
            Collection propertiesCollection = ((Map)entry.getValue()).values();
            if (propertiesCollection.isEmpty()) continue;
            ComponentTemplateProperties firstTemplate = (ComponentTemplateProperties)propertiesCollection.iterator().next();
            TreeEntry componentEntry = new TreeEntry(firstTemplate.getType(), typeId);
            for (ComponentTemplateProperties properties : propertiesCollection) {
                componentEntry.addSubEntries(Arrays.asList(new TreeEntry(componentEntry, properties)));
            }
            entries.add(componentEntry);
        }
        return entries;
    }

    List<ComponentTemplateProperties> collectSelectedUseCases() {
        ArrayList<ComponentTemplateProperties> selectedUseCases = new ArrayList<ComponentTemplateProperties>();
        for (TreeEntry componentEntry : this.entries) {
            List<TreeEntry> useCaseEntries = componentEntry.getSubEntries();
            for (TreeEntry useCaseEntry : useCaseEntries) {
                ComponentTemplateProperties properties = useCaseEntry.getProperties();
                if (properties == null || !useCaseEntry.isChecked()) continue;
                selectedUseCases.add(properties);
            }
        }
        return selectedUseCases;
    }

    private static List<ComponentTemplateProperties> importTemplatesInternal(String folder, List<String> fileNames) {
        AvailableComponents availableComponents = Controller.getInstance().getMcu().getAvailableComponents();
        ArrayList<ComponentTemplateProperties> newProperties = new ArrayList<ComponentTemplateProperties>(fileNames.size());
        for (String fileName : fileNames) {
            ComponentTemplateProperties importTemplate;
            ComponentTemplate template;
            File file = new File(folder, fileName);
            if (!file.exists() || file.isDirectory() || (template = ComponentTemplate.loadTemplateFromFile((File)file)) == null || (importTemplate = ComponentTemplate.importTemplate((ComponentTemplate)template, (AvailableComponents)availableComponents)) == null) continue;
            newProperties.add(importTemplate);
        }
        return newProperties;
    }

    public void importUseCases(List<String> fileNames, String folder) {
        List<ComponentTemplateProperties> newProperties = ComponentTemplateManagerDialog.importTemplatesInternal(folder, fileNames);
        if (!newProperties.isEmpty()) {
            this.updateViewerContent(Collections.emptyList(), newProperties);
        }
    }

    public void removeSelectedUseCases() {
        boolean approved = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.get().ComponentTemplateManagerDialog_ButtonRemoveChecked_ConfirmationTitle, (String)Messages.get().ComponentTemplateManagerDialog_ButtonRemoveChecked_ConfirmationMessage);
        if (approved) {
            this.removedSelectedUseCasesInternal();
        }
    }

    private void removedSelectedUseCasesInternal() {
        List<ComponentTemplateProperties> selectedUseCases = this.collectSelectedUseCases();
        AvailableComponents availableComponents = Controller.getInstance().getMcu().getAvailableComponents();
        for (ComponentTemplateProperties useCase : selectedUseCases) {
            ComponentTemplate.delete((ComponentTemplateProperties)useCase, (AvailableComponents)availableComponents);
        }
        this.updateViewerContent(selectedUseCases, Collections.emptyList());
    }

    private static void exportUseCasesInternal(List<ComponentTemplateProperties> useCases, String locationOnDisk) {
        File exportDirectory = new File(locationOnDisk);
        if (!exportDirectory.exists()) {
            return;
        }
        if (!exportDirectory.isDirectory()) {
            return;
        }
        for (ComponentTemplateProperties properties : useCases) {
            ComponentTemplate.export((ComponentTemplateProperties)properties, (File)exportDirectory);
        }
    }

    public void exportSelectedUseCases(String pathToFolder) {
        List<ComponentTemplateProperties> selectedUseCases = this.collectSelectedUseCases();
        if (selectedUseCases.isEmpty()) {
            return;
        }
        ComponentTemplateManagerDialog.exportUseCasesInternal(selectedUseCases, pathToFolder);
    }

    public void openDetailsDialog(Shell shell) {
        TreeEntry currentlySelectedEntryLoc = this.currentlySelectedEntry;
        if (currentlySelectedEntryLoc == null) {
            return;
        }
        ComponentTemplateProperties properties = currentlySelectedEntryLoc.getProperties();
        if (properties == null) {
            return;
        }
        ComponentTemplateProperties dialogResult = ComponentTemplateDetailDialog.open(shell, properties);
        if (dialogResult != null) {
            this.updateViewerContent(Arrays.asList(properties), Arrays.asList(dialogResult));
        }
    }

    private void createButtons(Composite composite) {
        Button detailsButtonLoc;
        Button exportSelectedUseCaseButtonLoc;
        Button removeSelectedUseCaseButtonLoc;
        Composite mainButtonsComposite = new Composite(composite, 0);
        GridLayout mainButtonsCompositeLayout = new GridLayout(4, false);
        mainButtonsComposite.setLayout((Layout)mainButtonsCompositeLayout);
        mainButtonsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Button importUseCaseButton = new Button(mainButtonsComposite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)importUseCaseButton, "periphsImportUseCases");
        importUseCaseButton.setText(Messages.get().ComponentTemplateManagerDialog_ButtonImport);
        importUseCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ComponentTemplateManagerDialog.this.getShell(), 2);
                dialog.setText(Messages.get().ComponentTemplateManagerDialog_ButtonImportDialogTitle);
                dialog.setFilterExtensions(new String[]{"*.usecase"});
                String open = dialog.open();
                if (open == null) {
                    return;
                }
                List<String> fileNames = Arrays.asList(dialog.getFileNames());
                File firstFile = new File(open);
                String folder = firstFile.getParent();
                if (folder == null) {
                    return;
                }
                ComponentTemplateManagerDialog.this.importUseCases(fileNames, folder);
            }
        });
        this.removeSelectedUseCaseButton = removeSelectedUseCaseButtonLoc = new Button(mainButtonsComposite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)removeSelectedUseCaseButtonLoc, "periphsRemoveUseCases");
        removeSelectedUseCaseButtonLoc.setText(Messages.get().ComponentTemplateManagerDialog_ButtonRemoveChecked);
        removeSelectedUseCaseButtonLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentTemplateManagerDialog.this.removeSelectedUseCases();
            }
        });
        this.exportSelectedUseCaseButton = exportSelectedUseCaseButtonLoc = new Button(mainButtonsComposite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)exportSelectedUseCaseButtonLoc, "periphsExportUseCases");
        exportSelectedUseCaseButtonLoc.setText(Messages.get().ComponentTemplateManagerDialog_ButtonExportChecked);
        exportSelectedUseCaseButtonLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = ComponentTemplateManagerDialog.this.getShell();
                if (shell == null) {
                    return;
                }
                String pathForExport = SWTFactoryProxy.INSTANCE.openDirectoryDialog(shell, null, null, null);
                if (pathForExport == null) {
                    return;
                }
                ComponentTemplateManagerDialog.this.exportSelectedUseCases(pathForExport);
            }
        });
        this.detailsButton = detailsButtonLoc = new Button(mainButtonsComposite, 8);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)detailsButtonLoc, "periphsDetailsOfUseCase");
        detailsButtonLoc.setText(Messages.get().ComponentTemplateManagerDialog_ButtonDetailsOfSelected);
        detailsButtonLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = detailsButtonLoc.getShell();
                ComponentTemplateManagerDialog.this.openDetailsDialog(shell);
            }
        });
    }

    public void updateViewerContent(List<ComponentTemplateProperties> propertiesToRemove, List<ComponentTemplateProperties> propertiesToAdd) {
        TreeEntry componentEntry;
        TreeViewer viewerLoc = this.viewer;
        if (viewerLoc == null) {
            return;
        }
        for (ComponentTemplateProperties properties : propertiesToRemove) {
            componentEntry = (TreeEntry)CollectionsUtils.nullableOptionalGet(this.entries.stream().filter(x -> x.getTypeId().equals(properties.getTypeId())).findAny());
            if (componentEntry == null) continue;
            ArrayList<TreeEntry> subEntries = new ArrayList<TreeEntry>(componentEntry.getSubEntries());
            List entriesToRemove = (List)subEntries.stream().filter(entry -> entry.getProperties() != null && propertiesToRemove.contains(entry.getProperties())).collect(CollectorsUtils.toList());
            componentEntry.removeSubEntries(entriesToRemove);
        }
        if (!propertiesToRemove.isEmpty()) {
            List emptyComponentEntris = (List)this.entries.stream().filter(entry -> entry.getSubEntries().isEmpty()).collect(CollectorsUtils.toList());
            this.entries.removeAll(emptyComponentEntris);
        }
        for (ComponentTemplateProperties template : propertiesToAdd) {
            componentEntry = (TreeEntry)CollectionsUtils.nullableOptionalGet(this.entries.stream().filter(x -> x.getTypeId().equals(template.getTypeId())).findAny());
            if (componentEntry == null) {
                componentEntry = new TreeEntry(template.getType(), template.getTypeId());
                this.entries.add(componentEntry);
            }
            TreeEntry newEntry = new TreeEntry(componentEntry, template);
            componentEntry.addSubEntries(Arrays.asList(newEntry));
        }
        viewerLoc.refresh();
    }

    protected boolean isResizable() {
        return true;
    }

    private static class TreeEntry {
        private String type;
        private String typeId;
        private List<TreeEntry> subEntries = Collections.emptyList();
        @Nullable
        private ComponentTemplateProperties properties;
        @Nullable
        private TreeEntry parent;
        private boolean isChecked;

        public TreeEntry(String type, String typeId) {
            this.type = type;
            this.typeId = typeId;
        }

        public TreeEntry(TreeEntry parent, ComponentTemplateProperties properties) {
            this.type = parent.getType();
            this.typeId = parent.getTypeId();
            this.parent = parent;
            this.properties = properties;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public String getType() {
            return this.type;
        }

        public List<TreeEntry> getSubEntries() {
            return CollectionsUtils.unmodifiableList(this.subEntries);
        }

        public void addSubEntries(List<TreeEntry> newEntries) {
            if (!(this.subEntries instanceof ArrayList)) {
                this.subEntries = new ArrayList<TreeEntry>(newEntries.size());
            }
            this.subEntries.addAll(newEntries);
        }

        public void removeSubEntries(List<TreeEntry> entries) {
            this.subEntries.removeAll(entries);
        }

        public @Nullable TreeEntry getParent() {
            return this.parent;
        }

        public @Nullable ComponentTemplateProperties getProperties() {
            return this.properties;
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public void setChecked(boolean isChecked) {
            this.isChecked = isChecked;
        }
    }
}

