/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.templates.component;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplateProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ComponentTemplateDetailDialog
extends Dialog {
    private ComponentTemplateProperties properties;
    @Nullable
    private Text nameText;
    @Nullable
    private Text descriptionText;
    @Nullable
    private ComponentTemplateProperties result;

    public ComponentTemplateDetailDialog(Shell shell, ComponentTemplateProperties properties) {
        super(shell);
        this.properties = properties;
    }

    public static @Nullable ComponentTemplateProperties open(Shell shell, ComponentTemplateProperties properties) {
        ComponentTemplateDetailDialog dialog = new ComponentTemplateDetailDialog(shell, properties);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.getResult();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().ComponentTemplateDetailDialog_Title);
        Shell parentShell = this.getParentShell();
        if (parentShell != null) {
            int parentShellWidth = parentShell.getSize().x;
            int partOfParentWidth = (int)((double)parentShellWidth * 0.2);
            int width = Math.max(partOfParentWidth, 400);
            newShell.setSize(width, 400);
            newShell.setMinimumSize(width, 400);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Composite detailsComposite = new Composite(composite, 0);
        GridLayout detailsCompositeLayout = new GridLayout(1, false);
        detailsComposite.setLayout((Layout)detailsCompositeLayout);
        detailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label nameLabel = new Label(detailsComposite, 0);
        nameLabel.setText(Messages.get().ComponentTemplateDetailDialog_LabelName);
        nameLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        Text nameTextLoc = new Text(detailsComposite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)nameTextLoc, "periphsTemplateNameText");
        this.nameText = nameTextLoc;
        nameTextLoc.setText(this.properties.getName());
        nameTextLoc.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label descriptionLabel = new Label(detailsComposite, 0);
        descriptionLabel.setText(Messages.get().ComponentTemplateCreationDialog_DescriptionLabelText);
        descriptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        Text descriptionTextLoc = new Text(detailsComposite, 2562);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)descriptionTextLoc, "periphsTemplateDescriptionText");
        this.descriptionText = descriptionTextLoc;
        descriptionTextLoc.setText(this.properties.getDescription());
        GridData descriptionTextLayoutData = new GridData(4, 4, true, true, 1, 1);
        descriptionTextLayoutData.heightHint = 5 * descriptionTextLoc.getLineHeight();
        descriptionTextLoc.setLayoutData((Object)descriptionTextLayoutData);
        return composite;
    }

    protected void okPressed() {
        AvailableComponents availableComponents = Controller.getInstance().getMcu().getAvailableComponents();
        Text nameTextLoc = this.nameText;
        Text descriptionTextLoc = this.descriptionText;
        if (nameTextLoc != null && descriptionTextLoc != null) {
            this.setResult(ComponentTemplate.update((ComponentTemplateProperties)this.properties, (String)nameTextLoc.getText(), (String)descriptionTextLoc.getText(), (AvailableComponents)availableComponents));
        }
        super.okPressed();
    }

    private void setResult(@Nullable ComponentTemplateProperties result) {
        this.result = result;
    }

    private @Nullable ComponentTemplateProperties getResult() {
        return this.result;
    }

    protected boolean isResizable() {
        return true;
    }
}

