/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.templates.component;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.ControlDecorationUtils;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.text.TextBoxHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ComponentTemplateCreationDialog
extends Dialog {
    static final double SHELL_WIDTH_PERCENTAGE = 0.2;
    static final int SHELL_MINIMAL_WIDTH = 400;
    static final int SHELL_MINIMAL_HEIGHT = 400;
    static final int DESCRIPTION_TEXTBOX_LINES = 5;
    @Nullable
    private Text nameText;
    @Nullable
    private Text descriptionText;
    private IComponentInstanceConfig instanceConfig;
    private IControllerWrapper controllerWrapper;

    protected ComponentTemplateCreationDialog(Shell parentShell, IComponentInstanceConfig instanceConfig, IControllerWrapper controllerWrapper) {
        super(parentShell);
        this.instanceConfig = instanceConfig;
        this.controllerWrapper = controllerWrapper;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().ComponentTemplateCreationDialog_DialogTitle);
        Shell parentShell = this.getParentShell();
        if (parentShell != null) {
            int parentShellWidth = parentShell.getSize().x;
            int partOfParentWidth = (int)((double)parentShellWidth * 0.2);
            int width = Math.max(partOfParentWidth, 400);
            newShell.setSize(width, 400);
            newShell.setMinimumSize(width, 400);
            ShellProvider.centerShell((Shell)newShell, (Shell)parentShell);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.get().ComponentTemplateCreationDialog_NameLabelText);
        nameLabel.setToolTipText(Messages.get().ComponentTemplateCreationDialog_NameLabelTooltip);
        nameLabel.setLayoutData((Object)new GridData());
        Text nameTextLoc = this.nameText = new Text(composite, 2048);
        nameTextLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ControlDecorationUtils.createErrorDecoration((Control)nameTextLoc, (int)16512);
        ControlDecorationUtils.setImage((Control)nameTextLoc, (Image)ToolsImages.getStatusDecoratorImg((int)2));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)nameTextLoc, "periphsTemplateNameText");
        TextBoxHelper.attachModifyErrorListener(() -> "", (Text)nameTextLoc, input -> {
            if (this.templateExists((String)input)) {
                return TextBoxHelper.Status.VALUE_ERROR;
            }
            return TextBoxHelper.Status.OK;
        });
        TextBoxHelper.attachModifyListeners((Text)nameTextLoc, input -> {
            boolean templateExists = this.templateExists((String)input);
            this.getButton(0).setEnabled(!templateExists);
            String errorDescription = templateExists ? Messages.get().ComponentTemplateCreationDialog_NameTextErrorTooltip : null;
            ControlDecorationUtils.updateControlDecoration((Control)nameTextLoc, (String)errorDescription);
        }, (int)50);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.get().ComponentTemplateCreationDialog_DescriptionLabelText);
        descriptionLabel.setToolTipText(Messages.get().ComponentTemplateCreationDialog_DescriptionLabelTooltip);
        descriptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text descriptionTextLoc = this.descriptionText = new Text(composite, 2562);
        GridData descriptionTextLayoutData = new GridData(4, 4, true, true);
        descriptionTextLayoutData.heightHint = 5 * descriptionTextLoc.getLineHeight();
        descriptionTextLoc.setLayoutData((Object)descriptionTextLayoutData);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)descriptionTextLoc, "periphsTemplateDescriptionText");
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    private boolean templateExists(String input) {
        return this.controllerWrapper.getController().getMcu().getAvailableComponents().templateExists(String.valueOf(input) + "_" + this.instanceConfig.getComponentTypeId());
    }

    protected void okPressed() {
        Text nameTextLoc = this.nameText;
        Text descriptionTextLoc = this.descriptionText;
        if (nameTextLoc != null && descriptionTextLoc != null) {
            IMcu mcu = this.controllerWrapper.getController().getMcu();
            if (ComponentTemplate.createAndSaveTemplateFiles((String)nameTextLoc.getText(), (String)descriptionTextLoc.getText(), (String)mcu.getPackage(), (String)this.controllerWrapper.getController().getFunctionalGroup().getCore(), (IComponentInstanceConfig)this.instanceConfig, (AvailableComponents)mcu.getAvailableComponents())) {
                super.okPressed();
                return;
            }
            MessageDialog.openError((Shell)this.getParentShell(), (String)Messages.get().ComponentTemplateCreationDialog_CreationErrorTitle, (String)Messages.get().ComponentTemplateCreationDialog_CreationErrorMessage);
            return;
        }
        super.cancelPressed();
    }

    public static boolean open(Shell shell, IComponentInstanceConfig instanceConfig, IControllerWrapper controllerWrapper) {
        ComponentTemplateCreationDialog dialog = new ComponentTemplateCreationDialog(shell, instanceConfig, controllerWrapper);
        dialog.setBlockOnOpen(true);
        return dialog.open() == 0;
    }
}

