/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.perspective;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.perspective.ToolsBasePerspective;
import com.nxp.swtools.utils.preferences.KEPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

public class PeripheralsPerspective
extends ToolsBasePerspective {
    public static final String ID = "com.nxp.swtools.periphs.gui.perspective";
    public static final String EXTENSION_POINT_ID = "com.nxp.swtools.periphs.gui.perspective.additionalViews";
    private static final String DEBUG_VIEW_ID = "com.nxp.swtools.periphs.internal_development.view.DebugView";
    private static final String FOLDER_ID_SUFFIX = "Folder";
    private static final String EDITOR_FOLDER_CATEGORY = "editor";
    private static final String EDITOR_FOLDER_ID = "editorFolder";
    private static final String MAIN_FOLDER_CATEGORY = "main";
    private static final String MAIN_FOLDER_ID = "mainFolder";
    private static final String BOTTOM_FOLDER_CATEGORY = "bottom";
    private static final String BOTTOM_FOLDER_ID = "bottomFolder";
    private static final String SHARED_FOLDER_CATEGORY = "shared";
    private static final String SHARED_FOLDER_ID = "sharedFolder";

    public void createInitialLayout(IPageLayout layout) {
        super.createInitialLayout(layout);
        Map<String, Set<String>> externalViews = PeripheralsPerspective.getRegisteredExtensionViews();
        layout.setEditorAreaVisible(false);
        String editorArea = layout.getEditorArea();
        IFolderLayout mainFolder = layout.createFolder(MAIN_FOLDER_ID, 1, 0.2f, editorArea);
        mainFolder.addView("com.nxp.swtools.periphs.gui.view.componentsView");
        mainFolder.addView("com.nxp.swtools.periphs.gui.view.peripheralsView");
        this.addPlaceholdersToFolder(mainFolder, (Collection<String>)externalViews.get(MAIN_FOLDER_CATEGORY));
        IFolderLayout sharedFolder = layout.createFolder(SHARED_FOLDER_ID, 2, 0.68f, editorArea);
        sharedFolder.addView("com.nxp.swtools.dashboard.DashboardView");
        sharedFolder.addView("com.nxp.swtools.framework.SourcesView");
        sharedFolder.addPlaceholder("com.nxp.swtools.framework.RegistersView");
        sharedFolder.addPlaceholder("com.nxp.swtools.periphs.gui.view.documentationView:*");
        sharedFolder.addPlaceholder(DEBUG_VIEW_ID);
        this.addPlaceholdersToFolder(sharedFolder, (Collection<String>)externalViews.get(SHARED_FOLDER_CATEGORY));
        IFolderLayout bottomFolder = layout.createFolder(BOTTOM_FOLDER_ID, 4, 0.75f, SHARED_FOLDER_ID);
        bottomFolder.addView("com.nxp.swtools.validation.problems.view");
        this.addPlaceholdersToFolder(bottomFolder, (Collection<String>)externalViews.get(BOTTOM_FOLDER_CATEGORY));
        PeripheralsPerspective.addCheatSheetViewPlaceholder((IPageLayout)layout);
        PeripheralsPerspective.addConsoleViewPlaceholder((IPageLayout)layout);
        bottomFolder.addPlaceholder("com.nxp.swtools.snippets.views.ToolsSnippetView");
        IFolderLayout editorFolder = layout.createFolder(EDITOR_FOLDER_ID, 2, 0.5f, editorArea);
        editorFolder.addView("com.nxp.swtools.periphs.gui.view.DefaultComponentSettingsView");
        editorFolder.addPlaceholder("com.nxp.swtools.periphs.gui.view.componentsettings:*");
        editorFolder.addPlaceholder("com.nxp.swtools.periphs.gui.view.globalcomponentsettings");
        this.addPlaceholdersToFolder(editorFolder, (Collection<String>)externalViews.get(EDITOR_FOLDER_CATEGORY));
        if (Rap.isActive()) {
            UIJobHelper.runNowOrInJob(() -> PerspectivesHelper.showView((String)"com.nxp.swtools.periphs.gui.view.componentsView"), (String)"Selecting Components View", null);
        }
    }

    private static Map<String, Set<String>> getRegisteredExtensionViews() {
        IConfigurationElement[] registeredExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        HashMap<String, Set<String>> externalViews = new HashMap<String, Set<String>>();
        IConfigurationElement[] iConfigurationElementArray = registeredExtensions;
        int n = registeredExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            String id = UtilsText.safeString((String)extension.getAttribute("id"));
            String folder = UtilsText.safeString((String)extension.getAttribute("folder"));
            Set set = externalViews.computeIfAbsent(folder, x -> new HashSet());
            assert (set != null);
            set.add(id);
            ++n2;
        }
        return externalViews;
    }

    public List<String> getDefinedViewIDs() {
        return CollectionsUtils.unmodifiableList((List)new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("com.nxp.swtools.periphs.gui.view.peripheralsView");
                this.add("com.nxp.swtools.periphs.gui.view.componentsView");
                this.add("com.nxp.swtools.framework.SourcesView");
                this.add("com.nxp.swtools.utils.logging.UserLogView");
                this.add("com.nxp.swtools.validation.problems.view");
                if (KEPreferences.showRegistersViewShortcut()) {
                    this.add("com.nxp.swtools.framework.RegistersView");
                }
                if (!Rap.isActive()) {
                    this.add("com.nxp.swtools.dashboard.DashboardView");
                    this.add("com.nxp.swtools.snippets.views.ToolsSnippetView");
                }
            }
        });
    }

    protected void addPlaceholdersToFolder(IFolderLayout folder, @Nullable Collection<String> placeholders) {
        if (placeholders != null) {
            for (String placeholder : placeholders) {
                folder.addPlaceholder(placeholder);
            }
        }
    }
}

