/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.command.BoardResetDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ResetToBoardDefaultHandler
extends AbstractHandler {
    private static final Logger LOGGER = LogManager.getLogger(ResetToBoardDefaultHandler.class);

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        IFunctionalGroup changedFuncGroup = Controller.getInstance().getFunctionalGroup();
        Shell parentShell = ShellProvider.getAnyShellParent();
        final IMcu mcu = Controller.getInstance().getMcu();
        final String kitOrBoardName = UtilsText.nonEmpty((String)mcu.getKit()) ? mcu.getKit() : mcu.getBoard();
        ISharedConfiguration sharedConfigurationLoc = ConfigurationUtils.loadBoardConfiguration((String)kitOrBoardName, (String)mcu.getSdkVersion(), (String)mcu.getMexVariant());
        if (sharedConfigurationLoc != null && kitOrBoardName != null) {
            ITemplateInfo template;
            ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            ITemplateInfo iTemplateInfo = template = UtilsText.isEmpty((String)mcu.getKit()) ? derivatives.getBoardById(kitOrBoardName, mcu.getSdkVersion()) : derivatives.getKitById(kitOrBoardName, mcu.getSdkVersion());
            if (template == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] Can't find template for board/kit \"{0}\" to reset board defaults.", kitOrBoardName);
                return null;
            }
            StoragePeriphsTool periphs = sharedConfigurationLoc.getTools().getPeripherals();
            if (periphs != null) {
                ArrayList functions = periphs.getFuncGroups();
                if (functions.isEmpty()) {
                    ResetToBoardDefaultHandler.informUserThatResetCannotBePerformed(parentShell);
                    return null;
                }
                List funcNames = (List)functions.stream().map(StorageToolBaseConfiguration::getConfigurationName).collect(CollectorsUtils.toList());
                String defaultMexVariant = BoardResetDialog.getDefaultMexVariant((ICommonConfig)sharedConfigurationLoc.getCommonConfig());
                BoardResetDialog<List<StoragePeriphsFuncGroup>> dialog = new BoardResetDialog<List<StoragePeriphsFuncGroup>>(parentShell, funcNames, changedFuncGroup.getName(), template.getTemplateVariants(), defaultMexVariant){

                    public @Nullable Collection<@NonNull String> getConfigs(String mexVariant) {
                        StoragePeriphsTool tmpStorage;
                        ISharedConfiguration tmpConfig = ConfigurationUtils.loadBoardConfiguration((String)kitOrBoardName, (String)mcu.getSdkVersion(), (String)mexVariant);
                        if (tmpConfig != null && (tmpStorage = tmpConfig.getTools().getPeripherals()) != null) {
                            this.setCustomData(tmpStorage.getFuncGroups());
                            return (Collection)tmpStorage.getFuncGroups().stream().map(StorageToolBaseConfiguration::getConfigurationName).collect(CollectorsUtils.toList());
                        }
                        return Collections.emptyList();
                    }
                };
                dialog.setCustomData((Object)functions);
                if (dialog.open() == 0) {
                    Controller.getInstance().resetToStorageFuncGroup(Objects.requireNonNull((List)dialog.getCustomData()), UtilsText.safeString((String)dialog.getSelectedConfiguration()), changedFuncGroup.getStorageFuncGroup());
                }
            } else {
                ResetToBoardDefaultHandler.informUserThatResetCannotBePerformed(parentShell);
            }
        } else {
            LOGGER.severe("[TOOL] Unable to load shared configuration to reset board defaults");
        }
        return null;
    }

    private static void informUserThatResetCannotBePerformed(Shell parentShell) {
        MessageDialog.openInformation((Shell)parentShell, (String)Messages.get().ResetToBoardDefaults_NoPeripherals_DialogTitle, (String)Messages.get().ResetToBoardDefaults_NoPeripherals_DialogTitle);
    }
}

