/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.view.MigrationOfferDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MigrationOfferDialogHelper {
    private static boolean delayedOpen;

    private MigrationOfferDialogHelper() {
    }

    public static void perspectiveActivated() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        if (delayedOpen && shell != null) {
            MigrationOfferDialogHelper.openDialogIfAnyMigrationIsAvailable(shell);
            delayedOpen = false;
        }
    }

    private static void openDialogIfAnyMigrationIsAvailable(Shell shell) {
        if (!MigrationOfferDialog.shouldMigrationOfferDialogopenAutomatically(PeriphControllerWrapper.getInstance())) {
            return;
        }
        MigrationOfferDialog.open(shell, PeriphControllerWrapper.getInstance());
    }

    public static void openNowOrWhenPeripheralsPerspectiveIsActive() {
        UIJobHelper.runUIJob(() -> {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IPerspectiveDescriptor perspective = activePage.getPerspective();
            if (perspective == null) {
                return;
            }
            String perspectiveId = perspective.getId();
            if ("com.nxp.swtools.periphs.gui.perspective".equals(perspectiveId)) {
                Shell shell = activeWorkbenchWindow.getShell();
                if (shell == null) {
                    return;
                }
                MigrationOfferDialogHelper.openDialogIfAnyMigrationIsAvailable(shell);
            } else {
                delayedOpen = true;
            }
        }, (String)"Open migration offer dialog", (boolean)false, null, (long)500L);
    }
}

