/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.handler.AHttpPeriphHandler;
import com.nxp.swtools.periphs.gui.view.AddComponentDialog;
import com.nxp.swtools.periphs.gui.view.AddComponentDialogProperties;
import com.nxp.swtools.utils.httpserver.HttpRequest;
import com.nxp.swtools.utils.httpserver.Response;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;

public class HttpOpenAddComponentDialogHandler
extends AHttpPeriphHandler {
    private static final String REGEX_PERIPHERAL_GROUP_ID = "peripheral";
    private static final String PREFIX = "/periph/openAddComponentDialog";
    private static final Pattern pattern = Pattern.compile("/periph/openAddComponentDialog/(?<peripheral>\\w+)");

    public boolean canHandle(HttpRequest query) {
        return query.getLocation().startsWith(PREFIX);
    }

    public void handle(HttpRequest query) {
        PeriphControllerWrapper wrapper = PeriphControllerWrapper.getInstance();
        Display display = wrapper.getController().getDisplay();
        if (display == null) {
            query.setResponse(new Response(500, "Could not retrieve display"));
            return;
        }
        display.asyncExec(() -> {
            this.putShellToTop();
            this.openPeripheralsPerspective();
            IViewSite currentViewSite = wrapper.getGUIController().getCurrentViewSite();
            if (currentViewSite == null) {
                query.setResponse(new Response(500, "Could not retrieve current view site"));
                return;
            }
            Matcher matcher = pattern.matcher(query.getLocation());
            String peripheral = null;
            if (matcher.matches()) {
                peripheral = matcher.group(REGEX_PERIPHERAL_GROUP_ID);
            }
            AddComponentDialogProperties properties = new AddComponentDialogProperties(currentViewSite, wrapper.getController().getFunctionalGroup().getId(), wrapper, true, true);
            properties.setBlockOnOpen(false);
            if (peripheral != null) {
                properties.setPeripheral(peripheral);
            }
            AddComponentDialog.open(properties);
            query.setResponse(new Response(200, "OK"));
        });
    }
}

