/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.Fonts;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationListInput;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationListInputElement;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.TreeContentProviderAdapter;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import com.nxp.s32ds.ext.rcp.jface.viewers.IgnoreCaseSubstringViewerFilter;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class MigrationListComposite
extends Composite {
    private static final boolean IS_APPLICABLE_ONLY = true;
    private static final int WIDTH_HINT = 100;
    private final Consumer<MigrationSequenceDescriptor> migrationChangedConsumer;
    private final String listLabel;
    private Text migrationsFilterText;
    private TreeViewer migrationsTreeViewer;
    private Button applicableMigrationsFilterButton;
    private MigrationListInput input;

    public MigrationListComposite(Composite parent, String listLabel, Consumer<MigrationSequenceDescriptor> migrationChangedConsumer) {
        super(parent, 0);
        this.listLabel = listLabel;
        this.migrationChangedConsumer = migrationChangedConsumer;
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).applyTo((Composite)this);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)this);
        this.doCreateMigrationsSelector(this);
    }

    public boolean isListEmpty() {
        return this.migrationsTreeViewer.getTree().getItemCount() == 0;
    }

    public MigrationSequenceDescriptor getMigration() {
        IStructuredSelection migrationSelection = (IStructuredSelection)this.migrationsTreeViewer.getSelection();
        if (migrationSelection.isEmpty()) {
            return null;
        }
        Object firstElement = migrationSelection.getFirstElement();
        if (firstElement != null) {
            return ((MigrationListInputElement)firstElement).getDescriptor();
        }
        return null;
    }

    public void setProjects(Collection<IProject> projects) {
        this.input.setProjects(projects);
    }

    public IStatus validate() {
        if (this.getMigration() == null) {
            return MigrationUiActivator.getInstance().createStatus(1, Messages.MigrationComposite_select_a_migration);
        }
        return Status.OK_STATUS;
    }

    private void doCreateMigrationsSelector(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).equalWidth(false).applyTo(composite);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)label);
        label.setText(this.listLabel);
        this.doCreateMigrationsFilterText(composite);
        this.doCreateMigrationsListViewer(composite);
        this.doCreateApplicableMigrationsFilterButton(composite);
        this.updateFilters();
    }

    private void doCreateApplicableMigrationsFilterButton(Composite parent) {
        this.applicableMigrationsFilterButton = new Button(parent, 32);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.applicableMigrationsFilterButton);
        this.applicableMigrationsFilterButton.setText(Messages.MigrationListComposite_show_applicable_migrations);
        this.applicableMigrationsFilterButton.setSelection(true);
        this.applicableMigrationsFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationListComposite.this.input.setApplicableOnly(MigrationListComposite.this.applicableMigrationsFilterButton.getSelection());
            }
        });
    }

    private void doCreateMigrationsFilterText(Composite parent) {
        this.migrationsFilterText = new Text(parent, 2048);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 1).applyTo((Control)this.migrationsFilterText);
        this.migrationsFilterText.addListener(24, e -> this.updateFilters());
    }

    private void updateFilters() {
        if (this.migrationsTreeViewer == null || this.migrationsTreeViewer.getControl().isDisposed()) {
            return;
        }
        ISelection selection = this.migrationsTreeViewer.getSelection();
        this.migrationsTreeViewer.setFilters(new ViewerFilter[]{new IgnoreCaseSubstringViewerFilter(this.migrationsFilterText.getText())});
        this.migrationsTreeViewer.setSelection(selection);
    }

    private void doCreateMigrationsListViewer(Composite composite) {
        this.migrationsTreeViewer = new TreeViewer(composite, 2816);
        Tree tree = this.migrationsTreeViewer.getTree();
        int width = (int)Fonts.getFontMetrics((Drawable)tree).getAverageCharacterWidth();
        GridDataFactory.swtDefaults().grab(true, true).hint(width * 100, tree.getItemHeight() * 10).align(4, 4).applyTo((Control)tree);
        this.migrationsTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new MigrationListInputColumnLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.migrationsTreeViewer.setComparator(new ViewerComparator());
        this.migrationsTreeViewer.setContentProvider((IContentProvider)new MigrationListInputTreeContentProvider());
        this.input = new MigrationListInput(this.migrationsTreeViewer, true);
        this.migrationsTreeViewer.setInput((Object)this.input);
        this.migrationsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MigrationListComposite.this.migrationChangedConsumer.accept(MigrationListComposite.this.getMigration());
            }
        });
    }

    private static final class MigrationListInputColumnLabelProvider
    extends ColumnLabelProvider {
        private MigrationListInputColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MigrationListInputElement) {
                return ((MigrationListInputElement)element).getDescriptor().getName();
            }
            return super.getText(element);
        }

        public String getToolTipText(Object element) {
            if (element instanceof MigrationListInputElement) {
                return ((MigrationListInputElement)element).getDescriptor().getDescription();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof MigrationListInputElement) {
                return MigrationUiActivator.getInstance().getImage("icon_sequence");
            }
            return super.getImage(element);
        }
    }

    private static final class MigrationListInputTreeContentProvider
    extends TreeContentProviderAdapter {
        private MigrationListInputTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof MigrationListInput) {
                return ((MigrationListInput)inputElement).getElements();
            }
            return null;
        }
    }
}

