/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.internal.ui.MigrationUiActivator;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrateProjectComposite;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrateProjectWizardPage;
import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationLogger;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileExportOperation;

public class BackupComposite
extends Composite {
    private static final String DOT = ".";
    private static final String ZIP = "zip";
    private static final String TAR = "tar";
    private static final String TAR_GZ = "tar.gz";
    private static final String TGZ = "tgz";
    private static final String COMPOSITE_NAME = BackupComposite.class.getSimpleName();
    private static final String[] EXTENSIONS = new String[]{"zip", "tar", "tar.gz", "tgz"};
    private static final String CREATE_BACKUP_OPTION_NAME = String.valueOf(COMPOSITE_NAME) + ".create_backup";
    private static final String FILE_OPTION_NAME = String.valueOf(COMPOSITE_NAME) + ".file";
    private static final String TAR_OPTION_NAME = String.valueOf(COMPOSITE_NAME) + ".tar";
    private static final String COMPRESS_OPTION_NAME = String.valueOf(COMPOSITE_NAME) + ".compress1";
    private static final String BACKUP_LINKED_OPTION_NAME = String.valueOf(COMPOSITE_NAME) + ".backup_linked";
    private Button createBackup;
    private Label fileLabel;
    private Text fileText;
    private Button fileButton;
    private Button useZipButton;
    private Button useTarButton;
    private Button compressButton;
    private Button backupLinkedResources;
    private final MigrateProjectComposite migrationComposite;
    private MigrateProjectWizardPage page;

    public BackupComposite(Composite parent, MigrateProjectComposite migrationComposite) {
        super(parent, 0);
        this.migrationComposite = migrationComposite;
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).applyTo((Composite)this);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 4).applyTo((Control)this);
        this.createBackup = new Button((Composite)this, 32);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.createBackup);
        this.createBackup.setText(Messages.BackupComposite_create_backup);
        this.createBackup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BackupComposite.this.updateBackupEnabled();
            }
        });
        this.doCreateBackupComposite(this);
    }

    public void setPage(MigrateProjectWizardPage page) {
        this.page = page;
    }

    private void doCreateBackupComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).applyTo(composite);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).indent(18, -1).applyTo((Control)composite);
        this.doCreateFileField(composite);
        this.doCreateOptions(composite);
    }

    private void doCreateFileField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).equalWidth(false).applyTo(composite);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)composite);
        this.fileLabel = new Label(composite, 0);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.fileLabel);
        this.fileLabel.setText(Messages.BackupComposite_file);
        this.fileText = new Text(composite, 2048);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fileText);
        this.fileText.addModifyListener(e -> {
            this.updateArchiveType();
            this.updatePageComplete();
        });
        this.fileButton = new Button(composite, 8);
        GridDataFactory.swtDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)this.fileButton);
        this.fileButton.setText(Messages.BackupComposite_browse);
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BackupComposite.this.selectFile();
            }
        });
    }

    private void updateArchiveType() {
        String text = this.fileText.getText();
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        try {
            Path path = Paths.get(text, new String[0]);
            String name = path.getFileName().toString();
            if (name.endsWith(".zip")) {
                this.useZipButton.setSelection(true);
                this.useTarButton.setSelection(false);
                this.compressButton.setSelection(true);
            } else if (name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
                this.useZipButton.setSelection(false);
                this.useTarButton.setSelection(true);
                this.compressButton.setSelection(true);
            } else if (name.endsWith(".tar")) {
                this.useZipButton.setSelection(false);
                this.useTarButton.setSelection(true);
                this.compressButton.setSelection(false);
            }
        }
        catch (InvalidPathException invalidPathException) {
            return;
        }
    }

    private void updatePageComplete() {
        if (this.page != null) {
            this.page.updatePageComplete();
        }
    }

    private void doCreateOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).equalWidth(true).applyTo(composite);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)composite);
        this.useZipButton = new Button(composite, 16);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.useZipButton);
        this.useZipButton.setText(Messages.BackupComposite_use_zip_format);
        this.useZipButton.setSelection(true);
        this.compressButton = new Button(composite, 32);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.compressButton);
        this.compressButton.setText(Messages.BackupComposite_compress_the_content);
        this.compressButton.setSelection(true);
        this.useTarButton = new Button(composite, 16);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.useTarButton);
        this.useTarButton.setText(Messages.BackupComposite_use_tar_format);
        this.backupLinkedResources = new Button(composite, 32);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.backupLinkedResources);
        this.backupLinkedResources.setText(Messages.BackupComposite_backup_linked_resources);
    }

    public void restoreWidgetState(IDialogSettings settings) {
        boolean tar;
        this.createBackup.setSelection(settings.getBoolean(CREATE_BACKUP_OPTION_NAME));
        String string = settings.get(FILE_OPTION_NAME);
        if (string != null) {
            this.fileText.setText(string);
        }
        this.useZipButton.setSelection(!(tar = settings.getBoolean(TAR_OPTION_NAME)));
        this.useTarButton.setSelection(tar);
        if (settings.get(COMPRESS_OPTION_NAME) != null) {
            this.compressButton.setSelection(settings.getBoolean(COMPRESS_OPTION_NAME));
        }
        this.backupLinkedResources.setSelection(settings.getBoolean(BACKUP_LINKED_OPTION_NAME));
        this.updateBackupEnabled();
    }

    public void saveWidgetState(IDialogSettings settings) {
        settings.put(CREATE_BACKUP_OPTION_NAME, this.createBackup.getSelection());
        settings.put(FILE_OPTION_NAME, this.fileText.getText());
        settings.put(TAR_OPTION_NAME, this.useTarButton.getSelection());
        settings.put(COMPRESS_OPTION_NAME, this.compressButton.getSelection());
        settings.put(BACKUP_LINKED_OPTION_NAME, this.backupLinkedResources.getSelection());
    }

    protected void updateBackupEnabled() {
        boolean selection = this.createBackup.getSelection();
        this.fileLabel.setEnabled(selection);
        this.fileText.setEnabled(selection);
        this.fileButton.setEnabled(selection);
        this.useZipButton.setEnabled(selection);
        this.useTarButton.setEnabled(selection);
        this.compressButton.setEnabled(selection);
        this.backupLinkedResources.setEnabled(selection);
        this.updatePageComplete();
    }

    protected void selectFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFilterExtensions((String[])Arrays.stream(EXTENSIONS).map(s -> "*." + s).toArray(String[]::new));
        dialog.setText(Messages.BackupComposite_select_file);
        String file = dialog.open();
        if (file != null) {
            this.fileText.setText(file);
        }
    }

    public IStatus validate() {
        Path path;
        if (!this.createBackup.getSelection()) {
            return Status.OK_STATUS;
        }
        String text = this.fileText.getText();
        if (text == null || text.trim().isEmpty()) {
            return MigrationUiActivator.getInstance().createStatus(1, Messages.BackupComposite_select_a_file_for_backup);
        }
        try {
            path = Paths.get(text, new String[0]);
        }
        catch (InvalidPathException e) {
            return MigrationUiActivator.getInstance().createStatus(4, NLS.bind((String)Messages.BackupComposite_path_is_invalid_0, (Object)e.getMessage()));
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return MigrationUiActivator.getInstance().createStatus(4, Messages.BackupComposite_selected_path_is_a_directory);
        }
        if (!Files.exists(path, new LinkOption[0]) && path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0])) {
            return MigrationUiActivator.getInstance().createStatus(4, Messages.BackupComposite_path_to_file_does_not_exist);
        }
        return Status.OK_STATUS;
    }

    public boolean createBackup() {
        return this.createBackup.getSelection();
    }

    public boolean continueIfExist() {
        if (Files.exists(Paths.get(this.fileText.getText(), new String[0]), new LinkOption[0])) {
            return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.BackupComposite_confirm, (String)Messages.BackupComposite_backup_file_already_exists_do_you_want_to_replace_it);
        }
        return true;
    }

    public IRunnableWithProgress getBackupOperation() {
        List<IProject> projects = this.migrationComposite.getSelectedProjects();
        String projectsNames = String.join((CharSequence)", ", projects.stream().map(IResource::getName).collect(Collectors.toList()));
        String outputFile = this.fileText.getText();
        ArchiveFileExportOperation operation = new ArchiveFileExportOperation(projects, outputFile);
        boolean useCompression = this.compressButton.getSelection();
        operation.setUseCompression(useCompression);
        boolean includeLinkedResources = this.backupLinkedResources.getSelection();
        operation.setIncludeLinkedResources(includeLinkedResources);
        boolean useTarFormat = this.useTarButton.getSelection();
        operation.setUseTarFormat(useTarFormat);
        return m -> MigrationLogger.wrap(MigrationLogger.logEntry(Messages.BackupComposite_backup, MigrationLogger.strings("projects", "destination", "use compression", "include linked resources", "use tar format"), MigrationLogger.objects(projectsNames, outputFile, useCompression, includeLinkedResources, useTarFormat)), () -> {
            operation.run(m);
            IStatus status = operation.getStatus();
            if (!status.isOK()) {
                throw new InvocationTargetException((Throwable)new CoreException(status));
            }
        });
    }
}

