/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.utils;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.GridPaneStructNode;
import com.nxp.swtools.gtm.controls.StructSettingNode;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.utils.AGtmAction;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class GtmOpenDocumentationAction
extends AGtmAction {
    private static final Logger LOGGER = LogManager.getLogger(GtmOpenDocumentationAction.class);

    protected GtmOpenDocumentationAction(Pattern actionPattern) {
        super(actionPattern);
    }

    @Override
    public void doAction() {
        try {
            String[] components;
            String documentationToOpen;
            if (this.actionMatcher != null && (documentationToOpen = this.actionMatcher.group(2)) != null && (components = documentationToOpen.split(",")).length == 2) {
                IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
                String componentId = components[0];
                String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
                String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
                Node node = GtmSceneCreator.getNodeById(componentId);
                ABaseUIComponentSetting componentSetting = UctUtils.getComponentSettingById((IMcu)mcu, (String)componentId);
                String docFullPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + components[1];
                if (node == null) {
                    Node parentNode;
                    String parentId = GtmUtils.getParentId((GtmStructSetting)GtmController.getInstance().getGtmMcu().getGtmLayoutContent(), (String)componentId);
                    if (parentId != null && (parentNode = GtmSceneCreator.getNodeById(parentId)) instanceof GridPaneStructNode && componentSetting != null) {
                        GridPaneStructNode gpNode = (GridPaneStructNode)parentNode;
                        StructSettingNode stSetting = new StructSettingNode((GtmStructSetting)componentSetting);
                        componentSetting.setVisibleState(true);
                        UctLayoutUtils.updateNodeState((Node)stSetting.getRegion(), (ABaseUIComponentSetting)componentSetting);
                        gpNode.getChildren().add((Object)stSetting.getRegion());
                        GridPane.setFillWidth((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                        GridPane.setFillHeight((Node)stSetting.getRegion(), (Boolean)Boolean.TRUE);
                        GridPane.setValignment((Node)stSetting.getRegion(), (VPos)VPos.TOP);
                        GtmOpenDocumentationAction.loadDocumentation(docFullPath, stSetting.getRegion());
                        GtmLayoutUtils.ensureVisible(parentNode, 0.0);
                    }
                } else if (node instanceof GridPaneStructNode && componentSetting != null) {
                    GridPaneStructNode gpNode = (GridPaneStructNode)node;
                    componentSetting.setVisibleState(true);
                    UctLayoutUtils.updateNodeState((Node)gpNode, (ABaseUIComponentSetting)componentSetting);
                    GtmOpenDocumentationAction.loadDocumentation(docFullPath, (Region)gpNode);
                    GtmLayoutUtils.ensureVisible(node, 0.0);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.log(Level.SEVERE, "The action cannot be performed since there is no match");
        }
    }

    private static void loadDocumentation(String documentationPath, Region region) {
        if (region instanceof GridPaneStructNode) {
            GridPaneStructNode gpNode = (GridPaneStructNode)region;
            gpNode.getChildren().clear();
            WebView wView = new WebView();
            wView.addEventFilter(ScrollEvent.SCROLL, e -> {
                double deltaY = e.getDeltaY();
                if (e.isControlDown() && deltaY > 0.0) {
                    wView.setZoom(wView.getZoom() * 1.1);
                    e.consume();
                } else if (e.isControlDown() && deltaY < 0.0) {
                    wView.setZoom(wView.getZoom() / 1.1);
                    e.consume();
                }
            });
            WebEngine webEngine = wView.getEngine();
            gpNode.getChildren().add((Object)wView);
            File f = new File(documentationPath);
            if (f.exists()) {
                webEngine.load(f.toURI().toString());
            }
        }
    }
}

