/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.handler;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.gui.handler.AHttpGtmHandler;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.utils.httpserver.HttpRequest;
import com.nxp.swtools.utils.httpserver.Response;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpGetSettingsHandler
extends AHttpGtmHandler {
    private static final Logger LOGGER = LogManager.getLogger(HttpGetSettingsHandler.class);
    private static final String REGEX_SETTING_GROUP_ID = "setting";
    private static final String PREFIX = "/gtm/getSettings";
    private static final Pattern pattern = Pattern.compile("/gtm/getSettings/(?<setting>[^\\/]+)");

    public boolean canHandle(HttpRequest request) {
        return request.getLocation().startsWith(PREFIX);
    }

    public void handle(HttpRequest request) {
        JSONObject res;
        block8: {
            Matcher matcher = pattern.matcher(request.getLocation());
            String settingId = null;
            if (matcher.matches()) {
                settingId = matcher.group(REGEX_SETTING_GROUP_ID);
            }
            IGtmMcu gtmMcu = GtmController.getInstance().getGtmMcu();
            res = new JSONObject();
            try {
                if (settingId != null) {
                    ABaseUIComponentSetting componentSetting = UctUtils.getComponentSettingById((IMcu)gtmMcu, (String)settingId);
                    if (componentSetting == null) break block8;
                    try {
                        res.put(componentSetting.getId(), (Object)componentSetting.getCurrentValue());
                        break block8;
                    }
                    catch (JSONException e) {
                        assert (false) : e.getMessage();
                        break block8;
                    }
                }
                for (ABaseUIComponentSetting componentSetting : gtmMcu.getAllGuiComponentSettings()) {
                    res.put(componentSetting.getId(), (Object)componentSetting.getCurrentValue());
                }
            }
            catch (JSONException e) {
                String message = MessageFormat.format("Problem with serializing shared configuration to JSON object in {0}: {1}", HttpGetSettingsHandler.class, e.getLocalizedMessage());
                LOGGER.log(Level.SEVERE, message);
                request.setResponse(new Response(500, message));
            }
        }
        request.setResponse(new Response(200, res.toString()));
    }
}

