/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.view.ToolView;
import java.util.HashMap;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Scene;
import org.eclipse.swt.widgets.Composite;

public class GtmView
extends ToolView {
    public static final String ID = "com.nxp.swtools.gtm.gui.GtmView";
    @Nullable
    private GtmSceneCreator sceneCreator;
    @Nullable
    private Composite parentComposite;
    private HashMap<IEventListener, Integer> listenersMap = new HashMap();
    protected final IEventListener showProblemListener = event -> {
        if (event.originator instanceof GtmProblem && !PerspectivesHelper.isViewVisible((String)ID)) {
            PerspectivesHelper.showView((String)ID);
        }
    };

    public void createPartControl(@Nullable Composite parent) {
        this.parentComposite = parent;
        FXCanvas canvas = new FXCanvas(parent, 0);
        this.sceneCreator = new GtmSceneCreator();
        Scene gtmScene = this.sceneCreator.getRootScene();
        canvas.setScene(gtmScene);
        this.setToolSceneState();
        assert (this.sceneCreator != null);
        this.sceneCreator.createLayout();
        assert (this.sceneCreator != null);
        IEventListener createUIListener = event -> this.sceneCreator.createLayout();
        GtmController.getInstance().addListener(8, createUIListener);
        this.listenersMap.put(createUIListener, 8);
        IEventListener setSceneStateListener = event -> this.setToolSceneState();
        GtmController.getInstance().addListener(2, setSceneStateListener);
        this.listenersMap.put(setSceneStateListener, 2);
        IEventListener refreshUIListener = event -> GtmLayoutUtils.refreshUI(gtmScene);
        GtmController.getInstance().addListener(16, refreshUIListener);
        this.listenersMap.put(createUIListener, 16);
        GtmController.getInstance().addListener(1024, this.showProblemListener);
        this.listenersMap.put(this.showProblemListener, 1024);
    }

    public void setFocus() {
        if (this.parentComposite != null) {
            this.parentComposite.setFocus();
        }
    }

    public void dispose() {
        this.listenersMap.entrySet().forEach(entry -> GtmController.getInstance().removeListener(((Integer)entry.getValue()).intValue(), (IEventListener)entry.getKey()));
        this.listenersMap.clear();
        super.dispose();
        if (this.sceneCreator != null) {
            this.sceneCreator.dispose();
        }
    }

    public void setToolSceneState() {
        IGtmMcu selectedMcu = GtmController.getInstance().getGtmMcu();
        boolean isMcuSupported = AUctController.isMcuSupported((IMcu)selectedMcu);
        if (isMcuSupported && GtmController.getInstance().isToolEnabled().get() && this.sceneCreator != null) {
            this.sceneCreator.getRootScene().getRoot().setVisible(true);
            GtmLayoutUtils.runActions(GtmController.getInstance().getGtmMcu().getGtmLayoutContent());
        } else if (!(isMcuSupported && GtmController.getInstance().isToolEnabled().get() || this.sceneCreator == null)) {
            this.sceneCreator.getRootScene().getRoot().setVisible(false);
        }
    }
}

