/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.annotation.NonNull;
import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeItemSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeStructSetting;
import com.nxp.swtools.common.uct.utils.UctXmlSettingsUtils;
import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.controls.ListenerHandle;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.GtmTreeCell;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.gui.utils.GtmToolActions;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.utils.GtmXmlSettingsUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmConfiguration;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmTool;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import com.nxp.swtools.utils.resources.IToolsImages;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import javafx.util.Duration;
import org.eclipse.ui.services.IDisposable;

public class TreeStructSettingNode
extends TreeView<Label>
implements IBaseControl,
IDisposable {
    private static final Logger LOGGER = LogManager.getLogger(TreeStructSettingNode.class);
    private TreeStructSetting treeStruct;
    private ChangeListener<TreeItem<Label>> selectionListener;
    protected final IEventListener showProblemListener = event -> {
        if (event.originator instanceof GtmProblem) {
            TreeItem<Label> treeItem;
            TreeItem treeRoot;
            GtmProblem gtmProblem = (GtmProblem)event.originator;
            IProblemUIContainer problemSourceContainer = gtmProblem.getSourceContainer();
            ABaseUIComponentSetting problemSource = (ABaseUIComponentSetting)gtmProblem.getProblemSource();
            TreeItemSetting actionTreeItemSetting = null;
            if (problemSourceContainer != null) {
                Node currentNode = (Node)problemSourceContainer;
                while (currentNode != null) {
                    if (currentNode.getId() == null || currentNode.getId().isEmpty() || (actionTreeItemSetting = TreeStructSettingNode.getTreeItemSettingByAction(this.treeStruct.getTreeItems(), String.format("setVisible(%s)", currentNode.getId()))) == null) {
                        currentNode = currentNode.getParent();
                        continue;
                    }
                    break;
                }
            } else {
                List parents = GtmXmlSettingsUtils.getParentIds((GtmStructSetting)GtmController.getInstance().getGtmMcu().getGtmLayoutContent(), (String)problemSource.getId());
                for (String parentId : parents) {
                    actionTreeItemSetting = TreeStructSettingNode.getTreeItemSettingByAction(this.treeStruct.getTreeItems(), String.format("setVisible(%s)", parentId));
                    if (actionTreeItemSetting == null) {
                        continue;
                    }
                    break;
                }
            }
            if (actionTreeItemSetting != null && this.getRoot() != null && (treeRoot = this.getRoot()) != null && (treeItem = TreeStructSettingNode.getTreeItemByLabel((TreeItem<Label>)treeRoot, actionTreeItemSetting.getLabel())) != null) {
                this.getSelectionModel().select(treeItem);
                if (problemSourceContainer == null) {
                    Timeline timeline = new Timeline();
                    timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)100.0), eventTimeline -> {
                        Node problemNode = GtmSceneCreator.getNodeById(problemSource.getId());
                        if (problemNode != null) {
                            gtmProblem.setSourceContainer((IProblemUIContainer)problemNode);
                            timeline.stop();
                            Platform.runLater(() -> GtmController.getInstance().handleEvent(new ToolEvent.Builder(1024).setOriginator((Object)gtmProblem).setObject((Object)treeRoot).build()));
                        }
                    }, new KeyValue[0]));
                    timeline.setCycleCount(-1);
                    timeline.play();
                }
            }
        }
    };

    public TreeStructSettingNode(TreeStructSetting treeStruct) {
        this.treeStruct = treeStruct;
        this.selectionListener = this.createSelectionListener();
        this.create();
    }

    public void create() {
        Label rootLabel = new Label(this.treeStruct.getLabel());
        rootLabel.setId(this.treeStruct.getId());
        TreeItem rootItem = new TreeItem((Object)rootLabel);
        for (TreeItemSetting treeItemSettingInStruct : this.treeStruct.getTreeItems()) {
            Label treeItemInStructLabel = new Label(treeItemSettingInStruct.getLabel());
            treeItemInStructLabel.setId(treeItemSettingInStruct.getId());
            TreeItem treeItemInStruct = new TreeItem((Object)treeItemInStructLabel);
            treeItemInStruct.setExpanded(true);
            for (TreeItemSetting childTreeItemSetting1 : treeItemSettingInStruct.getTreeItems()) {
                Label childTreeItemSetting1Label = new Label(childTreeItemSetting1.getLabel());
                childTreeItemSetting1Label.setId(childTreeItemSetting1.getId());
                TreeItem childTreeItem1 = new TreeItem((Object)childTreeItemSetting1Label);
                childTreeItem1.setExpanded(true);
                for (TreeItemSetting childTreeItemSetting2 : childTreeItemSetting1.getTreeItems()) {
                    Label childTreeItemSetting2Label = new Label(childTreeItemSetting2.getLabel());
                    childTreeItemSetting2Label.setId(childTreeItemSetting2.getId());
                    TreeItem childTreeItem2 = new TreeItem((Object)childTreeItemSetting2Label);
                    childTreeItem1.getChildren().add((Object)childTreeItem2);
                }
                treeItemInStruct.getChildren().add((Object)childTreeItem1);
            }
            rootItem.getChildren().add((Object)treeItemInStruct);
        }
        this.setRoot(rootItem);
        this.setShowRoot(false);
        this.getRoot().setExpanded(true);
        this.setCellFactory(this.createTreeViewCellFactory());
        this.getSelectionModel().selectedItemProperty().addListener(this.selectionListener);
        GtmController.getInstance().addListener(1024, this.showProblemListener);
    }

    private Callback<TreeView<Label>, TreeCell<Label>> createTreeViewCellFactory() {
        return new Callback<TreeView<Label>, TreeCell<Label>>(){

            public TreeCell<Label> call(TreeView<Label> p) {
                GtmTreeCell<Label> cell = new GtmTreeCell<Label>(){

                    protected void updateItem(Label label, boolean empty) {
                        super.updateItem((Object)label, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(label.getText());
                            TreeItemSetting treeItemSetting = TreeStructSettingNode.this.getTreeItemSettingById(label.getId());
                            if (treeItemSetting != null) {
                                TreeStructSettingNode.createTreeItemIcon(treeItemSetting, this);
                                ContextMenu contextMenu = new ContextMenu();
                                TreeStructSettingNode.createOpenDocumentationMenuItem(treeItemSetting, contextMenu);
                                TreeStructSettingNode.createOpenUseCasesMenuItem(treeItemSetting, contextMenu);
                                this.setOnContextMenuRequested(e -> contextMenu.show((Node)this, e.getScreenX(), e.getScreenY()));
                                this.disableProperty().bind((ObservableValue)treeItemSetting.getDisabledProperty());
                                this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"disabled-tree-item"), this.isDisabled());
                                ListenerHandle<Boolean> disableStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)treeItemSetting.getDisabledProperty(), TreeStructSettingNode.createDisableListener(treeItemSetting));
                                this.setListenerHandle(disableStateHandle);
                            }
                        }
                    }
                };
                return cell;
            }
        };
    }

    protected @Nullable TreeItemSetting getTreeItemSettingById(String id) {
        for (TreeItemSetting treeItemSettingInStruct : this.treeStruct.getTreeItems()) {
            if (treeItemSettingInStruct.getId().equals(id)) {
                return treeItemSettingInStruct;
            }
            for (TreeItemSetting childTreeItemSetting1 : treeItemSettingInStruct.getTreeItems()) {
                if (childTreeItemSetting1.getId().equals(id)) {
                    return childTreeItemSetting1;
                }
                for (TreeItemSetting childTreeItemSetting2 : childTreeItemSetting1.getTreeItems()) {
                    if (!childTreeItemSetting2.getId().equals(id)) continue;
                    return childTreeItemSetting2;
                }
            }
        }
        return null;
    }

    protected static @Nullable TreeItemSetting getTreeItemSettingByAction(List<TreeItemSetting> treeItemSettings, String action) {
        TreeItemSetting treeItemSettingResult = null;
        action = action.toLowerCase();
        for (TreeItemSetting treeItemSettingInStruct : treeItemSettings) {
            if (!treeItemSettingInStruct.getAction().isEmpty() && treeItemSettingInStruct.getAction().toLowerCase().contains(action)) {
                return treeItemSettingInStruct;
            }
            treeItemSettingResult = TreeStructSettingNode.getTreeItemSettingByAction(treeItemSettingInStruct.getTreeItems(), action);
            if (treeItemSettingResult == null) continue;
            return treeItemSettingResult;
        }
        return null;
    }

    protected static @Nullable TreeItem<@NonNull Label> getTreeItemByLabel(TreeItem<@NonNull Label> root, String label) {
        TreeItem<Label> treeItemResult = null;
        for (TreeItem treeItemInTree : root.getChildren()) {
            if (label.equalsIgnoreCase(((Label)treeItemInTree.getValue()).getText())) {
                return treeItemInTree;
            }
            treeItemResult = TreeStructSettingNode.getTreeItemByLabel((TreeItem<Label>)treeItemInTree, label);
            if (treeItemResult == null) continue;
            return treeItemResult;
        }
        return null;
    }

    protected static void createTreeItemIcon(TreeItemSetting treeItemSetting, TreeCell<Label> treeCell) {
        String treeItemIcon = treeItemSetting.getIcon();
        if (!treeItemIcon.isEmpty()) {
            Image showContentImage = new Image(IToolsImages.getIconUrl((String)treeItemIcon).toExternalForm());
            treeCell.setGraphic((Node)new ImageView(showContentImage));
        }
    }

    protected static void createOpenUseCasesMenuItem(TreeItemSetting treeItemSetting, ContextMenu contextMenu) {
        String useCases = treeItemSetting.getUseCases();
        if (!useCases.isEmpty()) {
            Menu menu = new Menu(Messages.ApplyUseCase);
            String[] useCasesArr = useCases.split(",");
            int i = 0;
            while (i < useCasesArr.length) {
                String[] useCaseComponents = useCasesArr[i].split("=");
                if (useCaseComponents.length == 2) {
                    String useCaseLabel = useCaseComponents[0];
                    String useCaseMexRelPath = useCaseComponents[1];
                    MenuItem menuItem = new MenuItem(useCaseLabel);
                    menuItem.setOnAction(e -> {
                        IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
                        String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
                        String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
                        String useCaseMexFullPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + useCaseMexRelPath;
                        File mexFile = new File(useCaseMexFullPath);
                        if (mexFile.exists() && mexFile.isFile()) {
                            try {
                                Throwable throwable = null;
                                Object var8_10 = null;
                                try (FileInputStream is = new FileInputStream(mexFile);){
                                    StorageGtmConfiguration stGtmConfiguration;
                                    ISharedConfiguration sharedCfg = SharedConfigurationFactory.loadSharedConfigurationFromXml((InputStream)is);
                                    StorageGtmTool stGtmTool = sharedCfg.getTools().getGtmTool();
                                    if (stGtmTool != null && (stGtmConfiguration = stGtmTool.getGtmConfiguration()) != null) {
                                        GtmController.getInstance().loadGtmSettingsFromContainers((List)stGtmConfiguration.getContainers());
                                        StorageGtmUtils.updateStorageContainers((List)stGtmConfiguration.getContainers());
                                        GtmController.getInstance().validate();
                                        GtmController.getInstance().handleSettingChange(16, (Object)sharedCfg, null, null);
                                        GtmController.getInstance().requestRegenerateCode();
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Exception ex) {
                                LOGGER.warning(ex.getLocalizedMessage());
                            }
                        }
                    });
                    menu.getItems().add((Object)menuItem);
                }
                ++i;
            }
            contextMenu.getItems().add((Object)menu);
        }
    }

    protected static void createOpenDocumentationMenuItem(TreeItemSetting treeItemSetting, ContextMenu contextMenu) {
        Matcher openDocumentationMatcher = GtmToolActions.OPEN_DOCUMENTATION_REGEX.matcher(treeItemSetting.getAction());
        if (openDocumentationMatcher.find() && openDocumentationMatcher.groupCount() == 2) {
            MenuItem openDocMenuItem = new MenuItem(Messages.OpenDocumentationInBrowser);
            openDocMenuItem.setOnAction(e -> TreeStructSettingNode.openDocumentation(openDocumentationMatcher));
            contextMenu.getItems().add((Object)openDocMenuItem);
        }
    }

    private static void openDocumentation(Matcher openDocumentationMatcher) {
        String[] components;
        String documentationToOpen = openDocumentationMatcher.group(2);
        if (documentationToOpen != null && (components = documentationToOpen.split(",")).length == 2) {
            IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
            String docRelPath = components[1];
            String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
            String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
            String docFullPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + docRelPath;
            if (new File(docFullPath).exists()) {
                SWTFactoryProxy.INSTANCE.openFileInExternalApp(docFullPath);
            }
        }
    }

    private ChangeListener<TreeItem<Label>> createSelectionListener() {
        return (observable, oldValue, newValue) -> {
            TreeItemSetting newItemSetting;
            TreeItemSetting oldItemSetting;
            GtmController.getInstance().changeInTreePane();
            if (oldValue != null && (oldItemSetting = UctXmlSettingsUtils.getTreeItemByLabel((TreeStructSetting)this.getTreeStruct(), (String)((Label)oldValue.getValue()).getText())) != null && !oldItemSetting.getAction().isEmpty()) {
                GtmToolActions.removeRefreshListeners(oldItemSetting.getAction());
            }
            if ((newItemSetting = UctXmlSettingsUtils.getTreeItemByLabel((TreeStructSetting)this.getTreeStruct(), (String)((Label)newValue.getValue()).getText())) != null) {
                GtmLayoutUtils.resetAllStructSettingsState();
                if (!newItemSetting.getAction().isEmpty()) {
                    GtmToolActions.executeAction(newItemSetting.getAction());
                }
            }
            GtmController.getInstance().updateConstraintsDeque();
        };
    }

    public ChangeListener<TreeItem<Label>> getSelectionListener() {
        return this.selectionListener;
    }

    protected void refreshScene() {
        Scene scene = this.getScene();
        if (scene != null) {
            GtmLayoutUtils.refreshUI(scene);
        }
    }

    public void dispose() {
        MultipleSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.selectedItemProperty().removeListener(this.selectionListener);
        }
        List<GtmTreeCell> list = this.lookupAll(".tree-cell").stream().filter(GtmTreeCell.class::isInstance).map(GtmTreeCell.class::cast).collect(Collectors.toList());
        list.forEach(cell -> {
            ListenerHandle<Boolean> listenerHandle = cell.getListenerHandle();
            if (listenerHandle != null) {
                listenerHandle.detach();
            }
        });
        GtmController.getInstance().removeListener(this.showProblemListener);
        this.getChildren().clear();
    }

    public TreeStructSetting getTreeStruct() {
        return this.treeStruct;
    }

    private static ChangeListener<Boolean> createDisableListener(TreeItemSetting treeSetting) {
        return (obs, wasDisabled, isDisabled) -> {
            Matcher panelMatcher;
            String treeAction = treeSetting.getAction();
            if (!treeAction.isEmpty() && (panelMatcher = GtmToolActions.SET_VISIBLE_REGEX.matcher(treeAction)).find() && panelMatcher.groupCount() == 2) {
                String panelID = panelMatcher.group(2);
                assert (panelID != null);
                ABaseUIComponentSetting setting = GtmUtils.getUIComponentSettingById((IGtmMcu)GtmController.getInstance().getGtmMcu(), (String)panelID);
                if (setting instanceof GtmStructSetting) {
                    GtmLayoutUtils.setAllNestedIntegerDisableState((GtmStructSetting)setting, isDisabled);
                }
            }
        };
    }
}

