/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.controls.ListenerHandle;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.GtmValidatedTextfield;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.tasks.GtmRefreshTask;
import com.nxp.swtools.gtm.tasks.GtmUpdateDisabledStateTextStyleTask;
import com.nxp.swtools.gtm.tasks.GtmUpdateTextFieldStyleTask;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import com.nxp.swtools.utils.events.IEventListener;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.eclipse.ui.services.IDisposable;

public class IntegerSettingControl
extends HBox
implements IRefreshableBaseControl,
IChildControl,
IDisposable {
    private GtmIntegerSetting integerSetting;
    protected Parent parent;
    private GtmValidatedTextfield integerSettingTxt;
    private ListenerHandle<String> textFieldHandle;
    private ListenerHandle<Boolean> isValueValidHandle;
    private ListenerHandle<Boolean> disableStateHandle;
    private ListenerHandle<Boolean> disableStateTextStyleHandle;
    protected final IEventListener showProblemListener = event -> {
        GtmProblem gtmProblem;
        IProblemUIContainer problemSourceContainer;
        Node currentNode;
        if (event.originator instanceof GtmProblem && (currentNode = (Node)(problemSourceContainer = (gtmProblem = (GtmProblem)event.originator).getSourceContainer())) != null) {
            GtmLayoutUtils.ensureVisible(currentNode, currentNode);
            PerspectivesHelper.showView((String)"com.nxp.swtools.gtm.gui.GtmView");
            UctUtils.runNowOrRunLater(() -> currentNode.requestFocus());
        }
    };

    public IntegerSettingControl(GtmIntegerSetting integerSetting, Parent parent) {
        this.integerSetting = integerSetting;
        this.parent = parent;
        this.integerSettingTxt = new GtmValidatedTextfield();
        this.textFieldHandle = new ListenerHandle<String>((ObservableValue<String>)this.integerSettingTxt.textProperty(), this.createIntegerTxtFieldListener());
        this.isValueValidHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)integerSetting.getIsValueValidProperty(), this.createIsValueValidTextStyleListener());
        this.disableStateTextStyleHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)integerSetting.getDisabledProperty(), this.createDisabledStateTextStyleListener());
        this.disableStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)integerSetting.getDisabledProperty(), this.createBoolRefreshListener());
        this.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTextfieldStyle() {
        GtmIntegerSetting gtmIntegerSetting = this.integerSetting;
        synchronized (gtmIntegerSetting) {
            List integerProblems = GtmController.getInstance().getProblemsManager().getProblemListForSource((IProblemSource)this.integerSetting);
            if (integerProblems.isEmpty()) {
                this.integerSettingTxt.resetStyle();
            } else {
                for (GtmProblem problem : integerProblems) {
                    problem.setSourceContainer((IProblemUIContainer)this.integerSettingTxt);
                }
                this.integerSettingTxt.setTextFieldErrorStyle();
            }
        }
    }

    public void create() {
        this.integerSettingTxt.setId(this.integerSetting.getId());
        Label integerSettingLbl = new Label(this.integerSetting.getLabel());
        integerSettingLbl.setContentDisplay(ContentDisplay.RIGHT);
        integerSettingLbl.getStyleClass().add((Object)"default-c-style");
        integerSettingLbl.setGraphic((Node)this.integerSettingTxt);
        integerSettingLbl.setPadding(new Insets(20.0));
        this.getChildren().add((Object)integerSettingLbl);
        this.getChildren().add((Object)this.integerSettingTxt);
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.integerSetting);
        this.integerSettingTxt.setDisable(this.integerSetting.isReadOnly());
        String initialValue = Long.toString(UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue()));
        String modelValue = this.integerSetting.getCurrentValue();
        if (!NumberFormatValidator.isValidDecimal((String)modelValue) && !NumberFormatValidator.isValidHexadecimal((String)modelValue) && UctUtils.getLongValueFromString((String)modelValue) != 0L) {
            initialValue = modelValue;
        }
        this.integerSettingTxt.setText(initialValue);
        this.updateTextfieldStyle();
        UctLayoutUtils.registerListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this, (int)4);
        GtmSceneCreator.getNodes().add((Node)this);
        GtmSceneCreator.getNodes().add((Node)this.integerSettingTxt);
        GtmSceneCreator.getNodes().add((Node)integerSettingLbl);
        this.disableStateTextStyleHandle.attach();
        this.addRefreshListeners();
        GtmController.getInstance().addListener(1024, this.showProblemListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        GtmIntegerSetting gtmIntegerSetting = this.integerSetting;
        synchronized (gtmIntegerSetting) {
            UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.integerSetting);
            long currentIntegerSettingTxtValue = UctUtils.getLongValueFromString((String)UtilsText.safeString((String)this.integerSettingTxt.getText()));
            long currentIntegerSettingValue = -1L;
            if (NumberFormatValidator.isValidDecimal((String)this.integerSetting.getCurrentValue()) || UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue()) == 0L || NumberFormatValidator.isValidHexadecimal((String)this.integerSetting.getCurrentValue())) {
                currentIntegerSettingValue = UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue());
                if (currentIntegerSettingTxtValue != currentIntegerSettingValue) {
                    this.integerSettingTxt.setText("0x" + Long.toHexString(currentIntegerSettingValue));
                }
            } else {
                this.integerSettingTxt.setText(this.integerSetting.getCurrentValue());
            }
            this.updateTextfieldStyle();
        }
    }

    public void addRefreshListeners() {
        this.textFieldHandle.attach();
        this.isValueValidHandle.attach();
        this.disableStateHandle.attach();
    }

    public void removeRefreshListeners() {
        this.textFieldHandle.detach();
        this.isValueValidHandle.detach();
        this.disableStateHandle.detach();
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    private ChangeListener<String> createIntegerTxtFieldListener() {
        return (observable, oldValue, newValue) -> {
            GtmController.getInstance().changeInCurrentPane();
            GtmIntegerSetting gtmIntegerSetting = this.integerSetting;
            synchronized (gtmIntegerSetting) {
                this.integerSetting.setCurrentValue(newValue);
                if (NumberFormatValidator.isValidNumerical((String)newValue) && !this.integerSetting.isDisabled() && GtmValidatedTextfield.isTextFieldValueValid(this.integerSettingTxt)) {
                    StorageGtmUtils.updateStorageForComponent((Object)((Object)this), (ABaseUIComponentSetting)this.integerSetting);
                }
            }
            GtmController.getInstance().checkRemainingVisibleSettings();
            GtmController.getInstance().validate();
            GtmController.getInstance().updateConstraintsDeque();
            this.updateTextfieldStyle();
        };
    }

    private ChangeListener<Boolean> createBoolRefreshListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmRefreshTask((IBaseControl)this)));
    }

    private ChangeListener<Boolean> createIsValueValidTextStyleListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmUpdateTextFieldStyleTask(this)));
    }

    private ChangeListener<Boolean> createDisabledStateTextStyleListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmUpdateDisabledStateTextStyleTask(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisabledStateTextStyle() {
        GtmIntegerSetting gtmIntegerSetting = this.integerSetting;
        synchronized (gtmIntegerSetting) {
            if (this.integerSetting.isDisabled()) {
                this.integerSettingTxt.resetStyle();
            } else {
                List integerProblems = GtmController.getInstance().getProblemsManager().getProblemListForSource((IProblemSource)this.integerSetting);
                if (!integerProblems.isEmpty()) {
                    this.integerSettingTxt.setTextFieldErrorStyle();
                }
            }
        }
    }

    public GtmIntegerSetting getIntegerSetting() {
        return this.integerSetting;
    }

    public void dispose() {
        this.textFieldHandle.detach();
        this.isValueValidHandle.detach();
        this.disableStateTextStyleHandle.detach();
        this.removeRefreshListeners();
        GtmController.getInstance().getProblemsManager().clearProblems((IProblemSource)this.integerSetting);
        UctLayoutUtils.removeListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this);
        GtmSceneCreator.getNodes().remove((Object)this);
        GtmSceneCreator.getNodes().remove((Object)this.integerSettingTxt);
        GtmController.getInstance().removeListener(this.showProblemListener);
        this.getChildren().clear();
    }

    public GtmValidatedTextfield getIntegerSettingTxt() {
        return this.integerSettingTxt;
    }
}

